[client] 
port            = 3306 
socket          = "%QSPATH%/mysql/mysql.sock"
character-set-server=utf8  

[mysqld]
port= 3306
socket = "%QSPATH%/mysql/mysql.sock"
basedir = "%QSPATH%/mysql" 
tmpdir = "%QSPATH%/mysql/tmp" 
datadir = "%QSPATH%/mysql/data"
pid_file = "mysql.pid"
# enable-named-pipe
key_buffer = 512M
max_allowed_packet = 16M
sort_buffer_size = 1M
net_buffer_length = 32K
read_buffer_size = 1M
read_rnd_buffer_size = 1M
myisam_sort_buffer_size = 128M
max_heap_table_size = 128M
tmp_table_size = 128M
log_error = "mysql_error.log"
explicit_defaults_for_timestamp=true 
sql_mode=''
thread_cache_size=80
#thread_concurrency=32
table_open_cache=4096
max_connections=130
back_log=100
interactive_timeout=5
wait_timeout=5
table_definition_cache=512
open_files_limit=65535
skip-name-resolve

#skip-networking
skip-federated
default-storage-engine = MyISAM

#server-id	= 1
#log-bin=mysql-bin


#server-id       = 2
#master-host     =   <hostname>
#master-user     =   <username>
#master-password =   <password>
#master-port     =  <port>
#log-bin=mysql-bin


# Point the following paths to different dedicated disks
#tmpdir = "%QSPATH%/mysql/tmp"
#log-update = /path-to-dedicated-directory/hostname

# Uncomment the following if you are using BDB tables
#bdb_cache_size = 4M
#bdb_max_lock = 10000

# Comment the following if you are using InnoDB tables
#skip-innodb
innodb_data_home_dir = "%QSPATH%/mysql/data"
innodb_data_file_path = ibdata1:10M:autoextend
innodb_log_group_home_dir = "%QSPATH%/mysql/data"
#innodb_log_arch_dir = "%QSPATH%/mysql/data"
## You can set .._buffer_pool_size up to 50 - 80 %
## of RAM but beware of setting memory usage too high
innodb_buffer_pool_size = 128M
innodb_additional_mem_pool_size = 2M
## Set .._log_file_size to 25 % of buffer pool size
innodb_log_file_size = 5M
innodb_log_buffer_size = 4M
innodb_flush_log_at_trx_commit = 1
innodb_lock_wait_timeout = 50

## UTF 8 Settings
init-connect='SET NAMES utf8'
#collation_server=utf8_unicode_ci
skip-character-set-client-handshake
#character_sets-dir="%QSPATH%/mysql/share/charsets"
character-set-server=utf8  
character-set-client=utf8

[mysqldump]
quick
max_allowed_packet = 16M

[mysql]
no-auto-rehash
# Remove the next comment character if you are not familiar with SQL
#safe-updates

[isamchk]
key_buffer = 20M
sort_buffer_size = 20M
read_buffer = 2M
write_buffer = 2M

[myisamchk]
key_buffer = 20M
sort_buffer_size = 20M
read_buffer = 2M
write_buffer = 2M

[mysqlhotcopy]
interactive-timeout
