#! /bin/sh

###########################################################
# This script is used to modify Linux kernel parameters for 
# maximum performance.  It is automatically called by the 
# safe3waf.sh script when starting safe3waf.
#
# The following parameters are modified:
#
# /proc/sys/net/core/rmem_max
# The maximum size of the kernel socket read buffer, in bytes.
# Set to 8388608 (8 MB) if current value is less.
#
# /proc/sys/net/core/wmem_max
# The maximum size of the kernel socket write buffer, in bytes.
# Set to 8388608 (8 MB) if current value is less.
#
# /proc/sys/net/ipv4/tcp_rmem
# The mimimum, default, and maximum size of tcp read buffer, in bytes.
# The maximum size is set to 4194304 (4 MB) if current value is less.
#
# /proc/sys/net/ipv4/tcp_wmem
# The mimimum, default, and maximum size of tcp write buffer, in bytes.
# The maximum size is set to 4194304 (4 MB) if current value is less.
#
############################################################

uname -a | grep -i linux > /dev/null
if [ $? != 0 ]
then
    exit 1
fi

if [ `whoami` != "root" ]
then
    #echo "optimiz_kernel.sh: Not root, skipping kernel parameter tuning"
    exit 1
fi

rmem_max=`cat /proc/sys/net/core/rmem_max`
wmem_max=`cat /proc/sys/net/core/wmem_max`

if [ $rmem_max -lt 8388608 ]
then
    echo "8388608" > /proc/sys/net/core/rmem_max
fi
if [ $wmem_max -lt 8388608 ]
then
    echo "8388608" > /proc/sys/net/core/wmem_max
fi

tcp_rmem1=`cat /proc/sys/net/ipv4/tcp_rmem | awk '{print $1}'`
tcp_rmem2=`cat /proc/sys/net/ipv4/tcp_rmem | awk '{print $2}'`
tcp_rmem3=`cat /proc/sys/net/ipv4/tcp_rmem | awk '{print $3}'`

tcp_wmem1=`cat /proc/sys/net/ipv4/tcp_wmem | awk '{print $1}'`
tcp_wmem2=`cat /proc/sys/net/ipv4/tcp_wmem | awk '{print $2}'`
tcp_wmem3=`cat /proc/sys/net/ipv4/tcp_wmem | awk '{print $3}'`

if [ $tcp_rmem3 -lt 4194304 ]
then
    echo "$tcp_rmem1 $tcp_rmem2 4194304" > /proc/sys/net/ipv4/tcp_rmem
fi

if [ $tcp_wmem3 -lt 4194304 ]
then
    echo "$tcp_wmem1 $tcp_wmem2 4194304" > /proc/sys/net/ipv4/tcp_wmem
fi



