#!/bin/sh

# safe3waf server start/stop script
#
# Usage: safe3waf.sh [start|stop|status]
#    start:   Start the safe3waf server
#    stop:    Stop the safe3waf server
#    status:  Check whether safe3waf is running or not
#
# See safe3waf.conf for configuration options
#
# Put this in /etc/init.d or /etc/rc3.d/ to start safe3waf
# at boot time 

basedir=/usr/local/safe3waf
pidfile=/var/run/safe3waf.pid
server=$basedir/bin/safe3waf
conffile=$basedir/etc/safe3waf.conf
pid=""

if [ -f $pidfile ]
then
    pid=`cat $pidfile`
    result=`ps -ef | grep safe3waf | grep $pid | grep -v grep`
    if [ "$result" = "" ]
    then
        rm -f $pidfile
        pid=""
    fi
fi

case $1 in 
start)
    if [ "$pid" != "" ]
    then
        
        echo "$0 start: safe3waf (pid $pid) already running"
        exit 0
    else
        # Increase maximum file descriptors if possible
        user=`whoami`
        nfile=`ulimit -n`

        if [ "$user" = "root" ]
        then
            $basedir/bin/optimiz_kernel.sh
        fi
        if [ "$user" = "root" -a "$nfile" -lt 64000 ]
        then
            ulimit -n 64000 > /dev/null 2>&1
        fi

        $server $conffile
        result=$? 
        if [ $result = 0 ]
        then
            echo "$0 start: safe3waf started" 
        else
            echo "$0 start: Error starting safe3waf"
            exit 1
        fi
    fi
    ;;
stop)
    if [ "$pid" != "" ]
    then
        kill -INT $pid
        rm -f $pidfile
        echo "$0 stop: safe3waf pid $pid has stopped"
    fi
    ;;
status)
    if [ "$pid" != "" ]
    then
        echo "safe3waf is running, pid $pid"
    else
        echo "safe3waf is not running"
    fi
    ;;
*)
    echo "Usage: $0 [start|stop|status]"
    echo "   start:   Start the safe3waf server"
    echo "   stop:    Stop the safe3waf server"
    echo "   status:  Check whether safe3waf is running or not"
    echo ""
    echo "See $conffile for configuration options"
    exit 2
esac

