#!/usr/bin/env python
import os
import sys
import time
import subprocess
import glob


def my_str(string):
    if sys.version_info[0] == 2:
        return str(string)
    if sys.version_info[0] == 3:
        return str(string, encoding='utf-8')


def fPopen(aCmd):
    p = subprocess.Popen(aCmd, shell=True, bufsize=4096, stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                         stderr=subprocess.PIPE, close_fds=True)
    sOut = my_str(p.stdout.read())
    sErr = my_str(p.stderr.read())
    return (sOut, sErr)


def doExit():
    print("Installation aborted!")
    sys.exit(1)
    return


def check_app_needed():
    sOut, sErr = fPopen("getenforce")
    if sOut[0:9] == "Enforcing":
        print("Selinux is running, can not install safedog!Please run setenforce 0 to disable")
        return False
    sOut, sErr = fPopen("cat /etc/selinux/config  | grep SELINUX=enforcing")
    if len(sOut) > 0:
        sOut = sOut.strip()
        if sOut[0:1] != "#":
            print("Selinux is enabled in /etc/selinux/config, can not install safedog!Please set disabled to SELINUX")
            return False

    arrApplist = "file whoami locate dmidecode lspci find python cat grep egrep awk netstat df free iptables zcat ifconfig sort uniq head hostname cp echo touch ps bash tail vmstat du mv tar mkdir rm chown chmod service killall kill ifdown ifup sed basename date uname ls cut diff iptables-save iptables-restore".split()
    for sApp in arrApplist:
        sOut, sErr = fPopen("which %s" % sApp)
        if len(sOut) == 0:
            print("Need system command '" + sApp + "' to install safedog for linux.")
            return False
    return True


def main():
    parent_dir, file_name = os.path.split(sys.argv[0])
    os.chdir(parent_dir)

    sOut, sErr = fPopen("getconf LONG_BIT")
    if int(sOut) == 32:
        longbit = 32
    else:
        longbit = 64

    glob_param = "./*_linux" + str(longbit) + ".tar.gz"
    webdogset = glob.glob(glob_param)

    glob_param = "./*linux" + str(longbit) + "_*.tar.gz"
    safedogset = glob.glob(glob_param)

    # print(webdogset)
    # print(safedogset)

    if len(safedogset) == 0:
        print("Safedog package is not found, check your file!")
        doExit()
    if not check_app_needed():
        doExit()

    basedir = safedogset[0][:-len(".tar.gz")]
    # print(basedir)
    if not os.path.exists(basedir):
        os.system("rm -rf "+ basedir)

        print("extracting files ...")
        safedog_tar_cmd = "tar xfz " + safedogset[0] + " -C ./"
        # print(safedog_tar_cmd)
        os.system(safedog_tar_cmd)

        for webdog_zippath in webdogset:
            webdog_rm_cmd = "rm -rf " + basedir + "/install_files/" + os.path.basename(webdog_zippath)[:-len(".tar.gz")]
            # print(webdog_rm_cmd)
            os.system(webdog_rm_cmd)
            webdog_tar_cmd = "tar xfz " + webdog_zippath + " -C " + basedir + "/install_files/"
            # print(webdog_tar_cmd)
            os.system(webdog_tar_cmd)

        # print(basedir)
        os.chdir(basedir)

        args = " -s"

        sOut, sErr = fPopen("cat install.py | grep \"python install_core.py \-s\" | grep \"\-p\"")
        if len(sOut) != 0:
            args += " -p"

        if len(glob.glob("./install_files/safedogwz_*")) != 0:
            args += " -a"
        if len(glob.glob("./install_files/safedog_nginx*")) != 0:
            args += " -n"
        if len(glob.glob("./install_files/safedog_tomcat*")) != 0:
            args += " -t"
        if len(glob.glob("./install_files/safedog_weblogic*")) != 0:
            args += " -w"
        # print(args)


        cmd = '''sed -e 's/dcmd = "python install_core.py.*/dcmd = "python install_core.py''' + args + '''"/g' install.py > 1;mv 1 install.py'''
        os.system(cmd)
        cmd = '''sed -e 's/dcmd = "python3 install_core.py.*/dcmd = "python3 install_core.py''' + args + '''"/g' install.py > 1;mv 1 install.py'''
        os.system(cmd)
        cmd = '''sed -e 's/dcmd = "python uninstall_core.py.*/dcmd = "python uninstall_core.py''' + args + '''"/g' uninstall.py > 1;mv 1 uninstall.py'''
        os.system(cmd)
        cmd = '''sed -e 's/dcmd = "python3 uninstall_core.py.*/dcmd = "python3 uninstall_core.py''' + args + '''"/g' uninstall.py > 1;mv 1 uninstall.py'''
        os.system(cmd)
        os.system("chmod 755 *.py")
    else:
        os.chdir(basedir)

    # print(sys.argv[1:])
    cmd = "./uninstall.py"
    for arg in sys.argv[1:]:
        cmd += " " + arg
    # print(cmd)
    os.system(cmd)
    return


if __name__ == "__main__":
    main()
    sys.exit(0)
