PrefabFiles = {
	"starsapphirefire",
	"starsapphire",
	"starsapphire_none",
	"starsapphirehat",
	"starsapphiremushroom",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/starsapphire.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/starsapphire.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/starsapphire.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/starsapphire.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/starsapphire_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/starsapphire_silho.xml" ),

    Asset( "IMAGE", "bigportraits/starsapphire.tex" ),
    Asset( "ATLAS", "bigportraits/starsapphire.xml" ),
	
	Asset( "IMAGE", "images/map_icons/starsapphire.tex" ),
	Asset( "ATLAS", "images/map_icons/starsapphire.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_starsapphire.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_starsapphire.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_starsapphire.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_starsapphire.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_starsapphire.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_starsapphire.xml" ),
	
	Asset( "IMAGE", "images/names_starsapphire.tex" ),
    Asset( "ATLAS", "images/names_starsapphire.xml" ),
	
    Asset( "IMAGE", "bigportraits/starsapphire_none.tex" ),
    Asset( "ATLAS", "bigportraits/starsapphire_none.xml" ),

Asset("ATLAS", "images/inventoryimages/starsapphiremushroomblue.xml"),
Asset("ATLAS", "images/inventoryimages/starsapphiremushroomchicken.xml"),
Asset("ATLAS", "images/inventoryimages/starsapphiremushroomcolorfull.xml"),
Asset("ATLAS", "images/inventoryimages/starsapphiremushroomdry.xml"),
Asset("ATLAS", "images/inventoryimages/starsapphiremushroomgreen.xml"),
Asset("ATLAS", "images/inventoryimages/starsapphiremushroomred.xml"),
Asset("IMAGE", "images/inventoryimages/starsapphiremushroomblue.tex"),
Asset("IMAGE", "images/inventoryimages/starsapphiremushroomchicken.tex"),
Asset("IMAGE", "images/inventoryimages/starsapphiremushroomcolorfull.tex"),
Asset("IMAGE", "images/inventoryimages/starsapphiremushroomdry.tex"),
Asset("IMAGE", "images/inventoryimages/starsapphiremushroomgreen.tex"),
Asset("IMAGE", "images/inventoryimages/starsapphiremushroomred.tex"),

}
_G = GLOBAL
local CHARACTER_INGREDIENT = GLOBAL.CHARACTER_INGREDIENT
local require = _G.require
local STRINGS = _G.STRINGS
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH

-- The character select screen lines
STRINGS.CHARACTER_TITLES.starsapphire = "The Fairy of The Stars"
STRINGS.CHARACTER_NAMES.starsapphire = "Star Sapphire"
STRINGS.CHARACTER_DESCRIPTIONS.starsapphire = "*Bless from the stars\n*Mushroom cook\n*Little Black Heart"
STRINGS.CHARACTER_QUOTES.starsapphire = "\"Take my umbrella. I'll go home~\""
STRINGS.CHARACTERS.STARSAPPHIRE = require "speech_starsapphire"

-- Custom speech strings

-- The character's name as appears in-game 
STRINGS.NAMES.SUNNY = "Star Sapphire"

local tellIsChinese = function()
	local isChinese = false
	for folder, mod in pairs(_G.KnownModIndex.savedata.known_mods) do
		local name = mod.modinfo.name
		if name then
			local isEnabled = ( (mod.enabled or mod.temp_enabled or _G.KnownModIndex:IsModForceEnabled(folder) or _G.KnownModIndex:IsModEnabled(folder) ) and not mod.temp_disabled ) and true or false
			--modnametofolder[name] = folder
			local idx = string.find(name,"Chinese Language Pack")
			if idx ~= nil and isEnabled == true then
				isChinese = true
				break
			end
		end
	end
	return isChinese
end
if tellIsChinese() == true then
	STRINGS.CHARACTERS.STARSAPPHIRE = require "speech_starsapphire_cn"
	STRINGS.CHARACTER_TITLES.starsapphire = "星光的妖精"
	STRINGS.CHARACTER_DESCRIPTIONS.starsapphire = "*群星的祝福\n*擅长料理蘑菇\n*小腹黑"
	STRINGS.CHARACTER_QUOTES.starsapphire = "\"来，这把伞先借给你们俩，我先回了~\""
end

AddMinimapAtlas("images/map_icons/starsapphire.xml")


--AddRecipe("starsapphiremushroomred", { Ingredient("red_cap", 3),Ingredient(CHARACTER_INGREDIENT.SANITY, 5)}, RECIPETABS.FARM,  TECH.MAGIC_TWO, nil, nil, nil, nil, "starsapphirecrafter", "images/inventoryimages/sunnylaser.xml" )

AddRecipe("starsapphiremushroomred", { Ingredient("red_cap", 3),Ingredient(CHARACTER_INGREDIENT.SANITY, 10)}, RECIPETABS.FARM,  TECH.SCIENCE_ONE, nil, nil, nil, nil, "starsapphirecrafter", "images/inventoryimages/starsapphiremushroomred.xml" )
AddRecipe("starsapphiremushroomblue", { Ingredient("blue_cap", 3),Ingredient(CHARACTER_INGREDIENT.SANITY, 5)}, RECIPETABS.FARM,  TECH.SCIENCE_ONE, nil, nil, nil, nil, "starsapphirecrafter", "images/inventoryimages/starsapphiremushroomblue.xml" )
AddRecipe("starsapphiremushroomgreen", { Ingredient("green_cap", 3),Ingredient(CHARACTER_INGREDIENT.SANITY, 5)}, RECIPETABS.FARM,  TECH.SCIENCE_ONE, nil, nil, nil, nil, "starsapphirecrafter", "images/inventoryimages/starsapphiremushroomgreen.xml" )
AddRecipe("starsapphiremushroomcolorfull", { Ingredient("red_cap", 2),Ingredient("green_cap", 1),Ingredient("blue_cap", 1)}, RECIPETABS.FARM,  TECH.MAGIC_TWO, nil, nil, nil, nil, "starsapphirecrafter", "images/inventoryimages/starsapphiremushroomcolorfull.xml" )
AddRecipe("starsapphiremushroomchicken", { Ingredient("blue_cap", 2),Ingredient("drumstick_cooked", 1),Ingredient(CHARACTER_INGREDIENT.SANITY, 10)}, RECIPETABS.FARM,  TECH.MAGIC_TWO, nil, nil, nil, nil, "starsapphirecrafter", "images/inventoryimages/starsapphiremushroomchicken.xml" )
AddRecipe("starsapphiremushroomdry", {Ingredient("red_cap", 2),Ingredient("green_cap", 1),Ingredient(CHARACTER_INGREDIENT.SANITY, 5)}, RECIPETABS.FARM,  TECH.MAGIC_TWO, nil, nil, nil, nil, "starsapphirecrafter", "images/inventoryimages/starsapphiremushroomdry.xml" )
AddRecipe("starsapphirehat", { Ingredient("silk", 3),Ingredient(CHARACTER_INGREDIENT.SANITY, 35)}, RECIPETABS.DRESS,  TECH.SCIENCE_ONE, nil, nil, nil, nil, "starsapphirecrafter", "images/inventoryimages/starsapphirehat.xml")
-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("starsapphire", "FEMALE")

