
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {
	"starsapphirefire",
}

-- Custom starting items
local start_inv = {"starsapphirehat","starsapphiremushroomdry","starsapphiremushroomdry","starsapphiremushroomdry"}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when reviving from ghost (optional)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "starsapphire_speed_mod", 1)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "starsapphire_speed_mod")
end


local function perkstats(inst)

	if TheWorld.state.phase == "day" then
	
		inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 1.07 )
		inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 1.07 )

	elseif TheWorld.state.phase == "dusk" then
	
		inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 1.07 )
		inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 1.07 )
		
	elseif TheWorld.state.phase == "night" then
	
		inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 1.07 )
		inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 1.07 )
	
	elseif tempCaveVar == true and TheWorld.state.phase == "caveday" then
	
		inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 1.07 )
		inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 1.07 )
		
	elseif tempCaveVar == true and TheWorld.state.phase == "cavedusk" then
	
		inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 1.07 )
		inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 1.07 )
		
	elseif tempCaveVar == true and TheWorld.state.phase == "cavenight" then
	
		inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 1.07 )
		inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 1.07 )
		
	end
	
end

-- When loading or spawning the character
local function onload(inst)
	inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
	inst:ListenForEvent("ms_becameghost", onbecameghost)

	if inst:HasTag("playerghost") then
		onbecameghost(inst)
	else
		onbecamehuman(inst)
	end
	perkstats(inst)
	inst:DoPeriodicTask(0.5, function() -- So, this one is set only once.
		print("1")
		local x,y,z = inst.Transform:GetWorldPosition()
		local ents = TheSim:FindEntities(x, y, z, 30, {"player"})
		local anotherPlayersHP = {}
		if inst.otherPlayersHP == nil then
			inst.otherPlayersHP = {}
		end
		if inst.lightedCreatures == nil then
			inst.lightedCreatures = {}
		end
		print("2")
		if inst.components.health:IsDead() == false and inst:HasTag("playerghost") == false then
			for k,v in pairs(ents) do
				if v ~= inst and v~=nil and v.components~= nil and v.components.health ~= nil and v.components.health:IsDead()==false and v:HasTag("playerghost") == false then
					if inst.otherPlayersHP[v] ~= nil and inst.otherPlayersHP[v] > v.components.health.currenthealth then
						inst.components.sanity:DoDelta(2)
						if inst.otherPlayersHP[v] >= 20 and v.components.health.currenthealth < 20 then
							if inst.components.sanity.max < 350 then
								inst.components.sanity.max = (inst.components.sanity.max + 1)
							end
						end
					end
					print("set current hp "..v.components.health.currenthealth)
					anotherPlayersHP[v] = v.components.health.currenthealth
				end
			end
		end
		print("3")
		inst.otherPlayersHP = anotherPlayersHP

		local lightedCreaturesNow = {}
		local _iscave = inst:HasTag("cave")
		print(_iscave)
		print("4")
		if inst.components.health:IsDead() == false and inst:HasTag("playerghost") == false then
			if TheWorld.state.phase == "night" or _iscave then
				ents = TheSim:FindEntities(x, y, z, 30, nil, nil, {"animal","character","smallcreature","monster"})
				for k,v in pairs(ents) do
					if v ~= inst and v ~= nil and v.entity ~= nil and v.components.health ~= nil and v.entity ~= nil and v.GUID ~= nil and v.components.health:IsDead()==false and v:HasTag("playerghost") == false and v:HasTag("player") == false then
						if v.components ~= nil and inst.userid ~= nil and inst.userid:len() > 0 then
							if v["starfires"..inst.userid] == nil then
								print(inst.userid.."see creature start1")
								v["starfires"..inst.userid] = {}
								print(inst.userid.."see creature start2")
								local fx = nil
								xpcall(
									function()
										fx = SpawnPrefab("starsapphirefire")
										print(inst.userid.."see creature spawned")
									end,
									function(e)
										print(inst.userid.."see creature failed")
										print(e)
										print(debug.traceback())
										fx = nil
										return e
									end
								)
								if fx ~= nil then
									fx.entity:SetParent(v.entity)
									fx.entity:AddFollower()
									fx.Follower:FollowSymbol(v.GUID, "base_point", 0, fx.fx_offset, 0)
			            					table.insert(v["starfires"..inst.userid], fx)
								end
								print(inst.userid.."see creature end")
							end
							lightedCreaturesNow[v] = 1
							print(inst.userid.."see creature ")
						end
					end
				end
			end
		end
		print("5")
		for k,v in pairs(inst.lightedCreatures) do
			if  k ~= nil and lightedCreaturesNow[k] == nil then
				print(inst.userid.."remove fire start")
			    if k["starfires"..inst.userid] ~= nil then
			        for i, fx in ipairs(k["starfires"..inst.userid]) do
				    if fx ~= nil then
			        	fx:Remove()
				    end
			        end
			        k["starfires"..inst.userid] = nil
			    end
				print(inst.userid.."remove fire end")
			end
		end
		inst.lightedCreatures = lightedCreaturesNow
		print("6")
		-- print("set inst hp "..inst.prefab.name)
	end)
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst:AddTag("starsapphirecrafter")
	inst.MiniMapEntity:SetIcon( "starsapphire.tex" )
end

local function onsave(inst, data)
		data.maxsanity = inst.components.sanity.max or nil
end

local function onpreload(inst, data)
		inst.components.sanity:SetMax(data.maxsanity)
		
end
-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(90)
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(125)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 0.95 * TUNING.WILSON_HUNGER_RATE
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload


	inst:WatchWorldState( "startday", function(inst) perkstats(inst) end )
	inst:WatchWorldState( "startdusk", function(inst) perkstats(inst) end )
	inst:WatchWorldState( "startnight", function(inst) perkstats(inst) end )
	inst:WatchWorldState( "startcaveday", function(inst) perkstats(inst) end )
	inst:WatchWorldState( "startcavedusk", function(inst) perkstats(inst) end )
	inst:WatchWorldState( "startcavenight", function(inst) perkstats(inst) end )
	perkstats(inst)
end

function getAllData(t, prevKey, prevData)
  -- if prevData == nil, start empty, otherwise start with prevData

  -- copy all the attributes from t
  local dataForGoIn = {}
  local keyForGoIn = {}
  local j = 0
  for k,v in pairs(t) do
	local i = 0
	if prevData ~= nil then
	  	for k2,v2 in pairs(prevData) do
			i = i + 1
			if v == v2 then 
				v=nil
				--print("break")
			else
				--print(tostring(v2).."!="..tostring(v))
			end
		end
	else
		prevData = {}
	end
	if v~=nil then 
		prevData[i] = v
		local key = tostring(k)
		if prevKey~=nil then key = tostring(prevKey).."."..key end
		print(key)
		print(v)
		if type(v)=='table' then
			j = j + 1
			dataForGoIn[j] = v
			keyForGoIn[j] = key
		end
	end
  end
  for k,v in pairs(dataForGoIn) do
	local key = keyForGoIn[j]
  	getAllData(v, key, prevData)
  end

  -- get t's metatable, or exit if not existing
  --local mt = getmetatable(t)
  --if type(mt)~='table' then return data end

  -- get the __index from mt, or exit if not table
  --local index = mt.__index
  --if type(index)~='table' then return data end

  -- include the data from index into data, recursively, and return
  --return getAllData(index, data)
end

return MakePlayerCharacter("starsapphire", prefabs, assets, common_postinit, master_postinit, start_inv)
