local assets={
Asset("ANIM", "anim/starsapphirehat.zip"),
Asset("ANIM", "anim/starsapphirehat_swap.zip"),
Asset("ATLAS", "images/inventoryimages/starsapphirehat.xml"),
Asset("IMAGE", "images/inventoryimages/starsapphirehat.tex"),
}
prefabs = {}

local tellIsChinese = function()
	local isChinese = false
	for folder, mod in pairs(_G.KnownModIndex.savedata.known_mods) do
		local name = mod.modinfo.name
		if name then
			local isEnabled = ( (mod.enabled or mod.temp_enabled or _G.KnownModIndex:IsModForceEnabled(folder) or _G.KnownModIndex:IsModEnabled(folder) ) and not mod.temp_disabled ) and true or false
			--modnametofolder[name] = folder
			local idx = string.find(name,"Chinese Language Pack")
			if idx ~= nil and isEnabled == true then
				isChinese = true
				break
			end
		end
	end
	return isChinese
end

STRINGS.NAMES.STARSAPPHIREHAT = "Star Sapphire's Hat"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.STARSAPPHIREHAT = "As cute as Star Sapphire herself" 
STRINGS.RECIPE_DESC.STARSAPPHIREHAT = "As cute as Star Sapphire herself" 
if tellIsChinese() == true then
	STRINGS.NAMES.STARSAPPHIREHAT = "斯塔帽"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.STARSAPPHIREHAT = "增强斯塔的可爱程度" 
	STRINGS.RECIPE_DESC.STARSAPPHIREHAT = "增强斯塔的可爱程度" 
end

local function onequip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "starsapphirehat_swap", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
	
end

local function onunequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")

end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	inst.entity:AddNetwork()
    
    inst:AddTag("hat")
    
	inst.isWeared = false
	inst.isDropped = false
	
    anim:SetBank("starsapphirehat")
    anim:SetBuild("starsapphirehat")
    anim:PlayAnimation("idle")    
        
    inst:AddComponent("inspectable")
    inst:AddComponent("tradable")
    
	if not TheWorld.ismastersim then
        return inst
    end
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/starsapphirehat.xml"
	
	inst:AddComponent("armor")
    inst.components.armor:InitCondition(30,  .5)   
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD

    inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL
	
    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )	
	
    return inst
end


return Prefab( "common/inventory/starsapphirehat", fn, assets) 
