local assets={
Asset("ANIM", "anim/starsapphiremushroom.zip"),
Asset("ANIM", "anim/swap_starsapphiremushroom.zip"),
Asset("ATLAS", "images/inventoryimages/starsapphiremushroomblue.xml"),
Asset("ATLAS", "images/inventoryimages/starsapphiremushroomchicken.xml"),
Asset("ATLAS", "images/inventoryimages/starsapphiremushroomcolorfull.xml"),
Asset("ATLAS", "images/inventoryimages/starsapphiremushroomdry.xml"),
Asset("ATLAS", "images/inventoryimages/starsapphiremushroomgreen.xml"),
Asset("ATLAS", "images/inventoryimages/starsapphiremushroomred.xml"),
Asset("IMAGE", "images/inventoryimages/starsapphiremushroomblue.tex"),
Asset("IMAGE", "images/inventoryimages/starsapphiremushroomchicken.tex"),
Asset("IMAGE", "images/inventoryimages/starsapphiremushroomcolorfull.tex"),
Asset("IMAGE", "images/inventoryimages/starsapphiremushroomdry.tex"),
Asset("IMAGE", "images/inventoryimages/starsapphiremushroomgreen.tex"),
Asset("IMAGE", "images/inventoryimages/starsapphiremushroomred.tex"),
}
prefabs = {}

local tellIsChinese = function()
	local isChinese = false
	for folder, mod in pairs(_G.KnownModIndex.savedata.known_mods) do
		local name = mod.modinfo.name
		if name then
			local isEnabled = ( (mod.enabled or mod.temp_enabled or _G.KnownModIndex:IsModForceEnabled(folder) or _G.KnownModIndex:IsModEnabled(folder) ) and not mod.temp_disabled ) and true or false
			--modnametofolder[name] = folder
			local idx = string.find(name,"Chinese Language Pack")
			if idx ~= nil and isEnabled == true then
				isChinese = true
				break
			end
		end
	end
	return isChinese
end

STRINGS.NAMES.STARSAPPHIREMUSHROOMGREEN = "Green mushroom soap"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.STARSAPPHIREMUSHROOMGREEN = "Made by Star.Not for increasing bombs." 
STRINGS.RECIPE_DESC.STARSAPPHIREMUSHROOMGREEN = "Not for increasing bombs."

STRINGS.NAMES.STARSAPPHIREMUSHROOMRED = "Red mushroom soap"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.STARSAPPHIREMUSHROOMRED = "Made by Star.Not for extending." 
STRINGS.RECIPE_DESC.STARSAPPHIREMUSHROOMRED = "Not for extending." 

STRINGS.NAMES.STARSAPPHIREMUSHROOMBLUE = "Blue mushroom soap"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.STARSAPPHIREMUSHROOMBLUE = "Made by Star.Not for points." 
STRINGS.RECIPE_DESC.STARSAPPHIREMUSHROOMBLUE = "Not for points." 

STRINGS.NAMES.STARSAPPHIREMUSHROOMCOLORFULL = "Colorful mushroom soap"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.STARSAPPHIREMUSHROOMCOLORFULL = "Made by Star.Not for changing points to power." 
STRINGS.RECIPE_DESC.STARSAPPHIREMUSHROOMCOLORFULL = "Not for changing points to power." 

STRINGS.NAMES.STARSAPPHIREMUSHROOMCHICKEN = "Chicken & mushroom soap"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.STARSAPPHIREMUSHROOMCHICKEN = "Made by Star.Meat in it!" 
STRINGS.RECIPE_DESC.STARSAPPHIREMUSHROOMCHICKEN = "Meat in it!" 

STRINGS.NAMES.STARSAPPHIREMUSHROOMDRY = "Dried mushroom"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.STARSAPPHIREMUSHROOMDRY = "Made by Star.Hard to perish." 
STRINGS.RECIPE_DESC.STARSAPPHIREMUSHROOMDRY = "Hard to perish." 
if tellIsChinese() == true then
	STRINGS.NAMES.STARSAPPHIREMUSHROOMGREEN = "绿色蘑菇汤"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.STARSAPPHIREMUSHROOMGREEN = "斯塔料理，虽然是绿色但不能用来增加Bomb" 
	STRINGS.RECIPE_DESC.STARSAPPHIREMUSHROOMGREEN = "虽然是绿色但不能用来增加Bomb" 
	STRINGS.NAMES.STARSAPPHIREMUSHROOMRED = "红色蘑菇汤"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.STARSAPPHIREMUSHROOMRED = "斯塔料理，虽然是绿色但不能用来增加残机" 
	STRINGS.RECIPE_DESC.STARSAPPHIREMUSHROOMRED = "虽然是绿色但不能用来增加残机" 
	STRINGS.NAMES.STARSAPPHIREMUSHROOMBLUE = "蓝色香菇汤"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.STARSAPPHIREMUSHROOMBLUE = "斯塔料理，虽然是蓝色但不能用来增加分数" 
	STRINGS.RECIPE_DESC.STARSAPPHIREMUSHROOMBLUE = "虽然是蓝色但不能用来增加分数" 
	STRINGS.NAMES.STARSAPPHIREMUSHROOMCOLORFULL = "彩色蘑菇汤"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.STARSAPPHIREMUSHROOMCOLORFULL = "斯塔料理，虽然是彩色但不能用来装换点和P的" 
	STRINGS.RECIPE_DESC.STARSAPPHIREMUSHROOMCOLORFULL = "虽然是彩色但不能用来装换点和P的" 
	STRINGS.NAMES.STARSAPPHIREMUSHROOMCHICKEN = "小鸡炖蘑菇"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.STARSAPPHIREMUSHROOMCHICKEN = "斯塔料理，虽然是名字很像但并不是东北名菜" 
	STRINGS.RECIPE_DESC.STARSAPPHIREMUSHROOMCHICKEN = "虽然是名字很像但并不是东北名菜" 
	STRINGS.NAMES.STARSAPPHIREMUSHROOMDRY = "蘑菇干"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.STARSAPPHIREMUSHROOMDRY = "斯塔料理，易于保存的美味~" 
	STRINGS.RECIPE_DESC.STARSAPPHIREMUSHROOMDRY = "易于保存的美味~" 
end


local function OnHauntCapOrCooked(inst, haunter)
    if math.random() <= TUNING.HAUNT_CHANCE_RARE then
        local x, y, z = inst.Transform:GetWorldPosition()
        SpawnPrefab("small_puff").Transform:SetPosition(x, y, z)
        local prefab = pickswitchprefab(inst)
        local new = prefab ~= nil and SpawnPrefab(prefab) or nil
        if new ~= nil then
            new.Transform:SetPosition(x, y, z)
            if new.components.stackable ~= nil and inst.components.stackable ~= nil and inst.components.stackable:IsStack() then
                new.components.stackable:SetStackSize(inst.components.stackable:StackSize())
            end
            if new.components.inventoryitem ~= nil and inst.components.inventoryitem ~= nil then
                new.components.inventoryitem:InheritMoisture(inst.components.inventoryitem:GetMoisture(), inst.components.inventoryitem:IsWet())
            end
            if new.components.perishable ~= nil and inst.components.perishable ~= nil then
                new.components.perishable:SetPercent(inst.components.perishable:GetPercent())
            end
            new:PushEvent("spawnedfromhaunt", { haunter = haunter, oldPrefab = inst })
            inst:PushEvent("despawnedfromhaunt", { haunter = haunter, newPrefab = new })
            inst.persists = false
            inst.entity:Hide()
            inst:DoTaskInTime(0, inst.Remove)
        end
        inst.components.hauntable.hauntvalue = TUNING.HAUNT_MEDIUM
        return true
    end
    return false
end

local function OnSpawnedFromHaunt(inst, data)
    Launch(inst, data.haunter, TUNING.LAUNCH_SPEED_SMALL)
end

local function fn(data)
    print(data.animname)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("starsapphiremushroom")
    inst.AnimState:SetBuild("starsapphiremushroom")
    inst.AnimState:PlayAnimation(data.animname)

    --cookable (from cookable component) added to pristine state for optimization
    --inst:AddTag("cookable")
    inst:AddTag("mushroom")
    inst:AddTag("starsapphiremushroom")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = data.size

    inst:AddComponent("tradable")
    inst:AddComponent("inspectable")

    MakeSmallBurnable(inst, TUNING.TINY_BURNTIME)
    MakeSmallPropagator(inst)
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "starsapphiremushroom"..data.animname
    inst.components.inventoryitem.atlasname = "images/inventoryimages/starsapphiremushroom"..data.animname..".xml"

    --this is where it gets interesting
    inst:AddComponent("edible")
    inst.components.edible.healthvalue = data.health
    inst.components.edible.hungervalue = data.hunger
    inst.components.edible.sanityvalue = data.sanity
    inst.components.edible.foodtype = data.foodtype
    inst.components.edible.temperaturedelta = data.temperaturedelta
    inst.components.edible.temperatureduration = data.temperatureduration

    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(data.perishtime)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"

    MakeHauntableLaunchAndPerish(inst)
    AddHauntableCustomReaction(inst, OnHauntCapOrCooked, true, false, true)
    inst:ListenForEvent("spawnedfromhaunt", OnSpawnedFromHaunt)

    return inst
end

local data =
{
    {
        name = "starsapphiremushroomred",
        animname="red",
        sanity = TUNING.SANITY_TINY,
        health = TUNING.HEALING_MEDSMALL,
        hunger = TUNING.CALORIES_TINY,
        foodtype = FOODTYPE.VEGGIE,
	perishtime = TUNING.PERISH_ONE_DAY,
	size = TUNING.STACK_SIZE_LARGEITEM,
	temperaturedelta = 20,
	temperatureduration = TUNING.FOOD_TEMP_BRIEF,
    },
    {
        name = "starsapphiremushroomgreen",
        animname="green",
        sanity = TUNING.SANITY_TINY,
        health = 0,
        hunger = TUNING.CALORIES_MED,
        foodtype = FOODTYPE.VEGGIE,
	perishtime = TUNING.PERISH_ONE_DAY,
	size = TUNING.STACK_SIZE_LARGEITEM,
	temperaturedelta = 20,
	temperatureduration = TUNING.FOOD_TEMP_BRIEF,
    },
    {
        name = "starsapphiremushroomblue",
        animname="blue",
        sanity = TUNING.SANITY_LARGE,
        health = TUNING.HEALING_TINY,
        hunger = TUNING.CALORIES_TINY,
        foodtype = FOODTYPE.VEGGIE,
	perishtime = TUNING.PERISH_ONE_DAY,
	size = TUNING.STACK_SIZE_LARGEITEM,
	temperaturedelta = 20,
	temperatureduration = TUNING.FOOD_TEMP_BRIEF,
    },
    {
        name = "starsapphiremushroomcolorfull",
        animname="colorfull",
        sanity = TUNING.SANITY_SMALL,
        health = TUNING.CALORIES_MED,
        hunger = TUNING.CALORIES_MEDSMALL,
        foodtype = FOODTYPE.VEGGIE,
	perishtime = TUNING.PERISH_ONE_DAY,
	size = TUNING.STACK_SIZE_LARGEITEM,
	temperaturedelta = 20,
	temperatureduration = TUNING.FOOD_TEMP_BRIEF,
    },
    {
        name = "starsapphiremushroomchicken",
        animname="chicken",
        sanity = TUNING.SANITY_LARGE,
        health = TUNING.HEALING_MED,
        hunger = TUNING.CALORIES_LARGE,
        foodtype = FOODTYPE.MEAT,
	perishtime = TUNING.PERISH_ONE_DAY,
	size = TUNING.STACK_SIZE_LARGEITEM,
	temperaturedelta = 40,
	temperatureduration = TUNING.FOOD_TEMP_LONG,
    },
    {
        name = "starsapphiremushroomdry",
        animname="dry",
        sanity = TUNING.SANITY_SMALL,
        health = TUNING.HEALING_SMALL,
        hunger = TUNING.CALORIES_MEDSMALL,
        foodtype = FOODTYPE.VEGGIE,
	perishtime = TUNING.PERISH_SUPERSLOW,
	size = TUNING.STACK_SIZE_SMALLITEM,
	temperaturedelta = 0,
	temperatureduration = 0,
    },
}

local prefabs = {}

for k,v in pairs(data) do
    local function mushfn()
        return fn(v)
    end
    local shroom = Prefab( v.name, mushfn, assets)
    table.insert(prefabs, shroom)
end

return unpack(prefabs)
--return Prefab( "common/inventory/starsapphiremushroom", fn, assets) 
