/*
 * Decompiled with CFR 0.152.
 */
package com.github.blitzsy.dwarvenproc.network;

import com.github.blitzsy.dwarvenproc.util.VarUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ParticlePacketMessage
implements IMessage,
IMessageHandler<ParticlePacketMessage, IMessage> {
    public String particleName;
    public double locationX;
    public double locationY;
    public double locationZ;
    public int particleAmount;

    public ParticlePacketMessage() {
        this("", 0.0, 0.0, 0.0, 0);
    }

    public ParticlePacketMessage(String particleName, double locationX, double locationY, double locationZ, int particleAmount) {
        this.particleName = particleName;
        this.locationX = locationX;
        this.locationY = locationY;
        this.locationZ = locationZ;
        this.particleAmount = particleAmount;
    }

    public void fromBytes(ByteBuf buf) {
        this.particleName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.locationX = buf.readDouble();
        this.locationY = buf.readDouble();
        this.locationZ = buf.readDouble();
        this.particleAmount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.particleName);
        buf.writeDouble(this.locationX);
        buf.writeDouble(this.locationY);
        buf.writeDouble(this.locationZ);
        buf.writeInt(this.particleAmount);
    }

    public IMessage onMessage(ParticlePacketMessage message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            for (int i = 0; i < message.particleAmount; ++i) {
                Minecraft.func_71410_x().field_71441_e.func_175688_a(VarUtils.lookupParticleByName(message.particleName), message.locationX + VarUtils.RANDOM.nextGaussian() * 1.0, message.locationY + VarUtils.RANDOM.nextGaussian() * 1.5, message.locationZ + VarUtils.RANDOM.nextGaussian() * 1.0, VarUtils.RANDOM.nextGaussian() * 0.05, VarUtils.RANDOM.nextGaussian() * 0.05, VarUtils.RANDOM.nextGaussian() * 0.05, new int[0]);
            }
        }
        return null;
    }
}

