/*
 * Decompiled with CFR 0.152.
 */
package com.github.blitzsy.dwarvenproc.util;

import java.lang.reflect.Field;
import net.minecraft.potion.Potion;

public class PotionUtils {
    public static boolean isPotionIDSlotFree(int slot) {
        return Potion.field_76425_a[slot] == null;
    }

    public static int getFreePotionIDSlot() {
        for (int potionIndex = 1; potionIndex < 128; ++potionIndex) {
            if (Potion.field_76425_a[potionIndex] != null) continue;
            return potionIndex;
        }
        return -1;
    }

    public static void resizePotionArray() {
        if (Potion.field_76425_a.length < 256) {
            for (Field f : Potion.class.getDeclaredFields()) {
                if (!f.getName().equals("potionTypes") && !f.getName().equals("field_76425_a")) continue;
                try {
                    Field modfield = Field.class.getDeclaredField("modifiers");
                    modfield.setAccessible(true);
                    modfield.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                    Potion[] potionTypes = (Potion[])f.get(null);
                    Potion[] newPotionTypes = new Potion[256];
                    System.arraycopy(potionTypes, 0, newPotionTypes, 0, potionTypes.length);
                    f.set(null, newPotionTypes);
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                    System.err.println("Failed to resize potion array, The mod may work incorrectly until this is fixed! Please report this to the mod author ASAP.");
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    System.err.println("Failed to resize potion array, The mod may work incorrectly until this is fixed! Please report this to the mod author ASAP.");
                }
            }
        }
    }
}

