/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public final class TgaLoader {
    public static final int TYPE_NO_IMAGE = 0;
    public static final int TYPE_COLORMAPPED = 1;
    public static final int TYPE_TRUECOLOR = 2;
    public static final int TYPE_BLACKANDWHITE = 3;
    public static final int TYPE_COLORMAPPED_RLE = 9;
    public static final int TYPE_TRUECOLOR_RLE = 10;
    public static final int TYPE_BLACKANDWHITE_RLE = 11;

    private TgaLoader() {
    }

    public static ImageData loadImage(InputStream inputStream) throws IOException {
        return TgaLoader.loadImage(inputStream, true);
    }

    public static ImageData loadImage(InputStream inputStream, boolean bl) throws IOException {
        return TgaLoader.loadImage(inputStream, false, bl);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageData loadImage(InputStream inputStream, boolean bl, boolean bl2) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        byte[] byArray;
        int n6;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 8192);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        int n7 = dataInputStream.readUnsignedByte();
        int n8 = dataInputStream.readUnsignedByte();
        int n9 = dataInputStream.readUnsignedByte();
        if (n9 != 1 && n9 != 9 && n9 != 2 && n9 != 10) {
            throw new IOException("Unsupported TGA type: " + n9);
        }
        dataInputStream.readShort();
        short s = TgaLoader.flipEndian(dataInputStream.readShort());
        int n10 = dataInputStream.readUnsignedByte();
        dataInputStream.readShort();
        dataInputStream.readShort();
        int n11 = TgaLoader.flipEndian(dataInputStream.readShort());
        int n12 = TgaLoader.flipEndian(dataInputStream.readShort());
        int n13 = dataInputStream.readUnsignedByte();
        boolean bl3 = false;
        int n14 = dataInputStream.readUnsignedByte();
        if ((n14 & 0x20) != 0) {
            bl3 = true;
        }
        if (n7 > 0) {
            bufferedInputStream.skip(n7);
        }
        ColorMapEntry[] colorMapEntryArray = null;
        if (n8 != 0) {
            int n15 = n10 * s >> 3;
            n6 = Math.min(n10 / 3, 8);
            byArray = new byte[n15];
            bufferedInputStream.read(byArray);
            if (n9 == 1 || n9 == 9) {
                colorMapEntryArray = new ColorMapEntry[s];
                n5 = n10 - 3 * n6;
                float f = 255.0f / ((float)Math.pow(2.0, n6) - 1.0f);
                float f2 = 255.0f / ((float)Math.pow(2.0, n5) - 1.0f);
                for (n4 = 0; n4 < s; ++n4) {
                    ColorMapEntry colorMapEntry = new ColorMapEntry();
                    n3 = n10 * n4;
                    colorMapEntry.blue = (byte)((float)TgaLoader.getBitsAsByte(byArray, n3, n6) * f);
                    colorMapEntry.green = (byte)((float)TgaLoader.getBitsAsByte(byArray, n3 + n6, n6) * f);
                    colorMapEntry.red = (byte)((float)TgaLoader.getBitsAsByte(byArray, n3 + 2 * n6, n6) * f);
                    colorMapEntry.alpha = n5 <= 0 ? (byte)-1 : (byte)((float)TgaLoader.getBitsAsByte(byArray, n3 + 3 * n6, n5) * f2);
                    colorMapEntryArray[n4] = colorMapEntry;
                }
            }
        }
        byte[] byArray2 = null;
        if (n13 == 32 || bl) {
            byArray2 = new byte[n11 * n12 * 4];
            n6 = 4;
        } else {
            byArray2 = new byte[n11 * n12 * 3];
            n6 = 3;
        }
        byArray = null;
        if (n13 == 16) {
            byArray = new byte[n11 * n12 * 2];
        }
        n5 = 0;
        if (n9 == 2) {
            byte by = 0;
            byte by2 = 0;
            n4 = 0;
            int n16 = 0;
            if (n13 == 16) {
                float f = 8.225806f;
                byte[] byArray3 = new byte[2];
                for (n2 = 0; n2 < n12; ++n2) {
                    if (!bl3) {
                        n5 = (n12 - 1 - n2) * n11 * n6;
                    }
                    for (n = 0; n < n11; ++n) {
                        byArray3[1] = dataInputStream.readByte();
                        byArray3[0] = dataInputStream.readByte();
                        byArray[n5 * 2 / n6 + 1] = byArray3[1];
                        byArray[n5 * 2 / n6] = byArray3[0];
                        byArray2[n5++] = (byte)((float)TgaLoader.getBitsAsByte(byArray3, 1, 5) * f);
                        byArray2[n5++] = (byte)((float)TgaLoader.getBitsAsByte(byArray3, 6, 5) * f);
                        byArray2[n5++] = (byte)((float)TgaLoader.getBitsAsByte(byArray3, 11, 5) * f);
                        if (n6 != 4) continue;
                        n16 = TgaLoader.getBitsAsByte(byArray3, 0, 1);
                        if (n16 == 1) {
                            n16 = -1;
                        }
                        byArray2[n5++] = n16;
                    }
                }
            } else {
                if (n13 != 24 && n13 != 32) throw new IOException("Unsupported TGA true color depth: " + n13);
                for (n3 = 0; n3 < n12; ++n3) {
                    if (!bl3) {
                        n5 = (n12 - 1 - n3) * n11 * n6;
                    }
                    for (int i = 0; i < n11; ++i) {
                        n4 = dataInputStream.readByte();
                        by2 = dataInputStream.readByte();
                        by = dataInputStream.readByte();
                        byArray2[n5++] = by;
                        byArray2[n5++] = by2;
                        byArray2[n5++] = n4;
                        if (n13 == 32) {
                            n16 = dataInputStream.readByte();
                            byArray2[n5++] = n16;
                            continue;
                        }
                        if (n6 != 4) continue;
                        byArray2[n5++] = -1;
                    }
                }
            }
        } else if (n9 == 10) {
            int n17 = n13 / 8;
            if (n17 < 2 || n17 > 4) {
                throw new IOException("TGA: unknown colormap indexing size used: " + n17);
            }
            byte[][] byArray4 = new byte[n11 * n12][n17];
            n4 = 0;
            while (n4 != byArray4.length) {
                int n18 = dataInputStream.readByte();
                if ((n18 & 0x80) != 0) {
                    n18 &= 0x7F;
                    byte[] byArray5 = new byte[n17];
                    for (int i = 0; i < n17; ++i) {
                        byArray5[i] = dataInputStream.readByte();
                    }
                    while (n18-- >= 0) {
                        byArray4[n4++] = byArray5;
                    }
                    continue;
                }
                while (n18-- >= 0) {
                    for (int i = 0; i < n17; ++i) {
                        byArray4[n4][i] = dataInputStream.readByte();
                    }
                    ++n4;
                }
            }
            if (n13 == 32 || n13 == 24) {
                for (int i = 0; i < n12; ++i) {
                    if (!bl3) {
                        n5 = (n12 - 1 - i) * n11 * n6;
                    }
                    for (int j = 0; j < n11; ++j) {
                        byArray2[n5++] = byArray4[i * n11 + j][2];
                        byArray2[n5++] = byArray4[i * n11 + j][1];
                        byArray2[n5++] = byArray4[i * n11 + j][0];
                        if (n13 == 32) {
                            byArray2[n5++] = byArray4[i * n11 + j][3];
                            continue;
                        }
                        if (n6 != 4) continue;
                        byArray2[n5++] = -1;
                    }
                }
            } else {
                void var25_58;
                if (n13 != 16) throw new IOException("Unsupported TGA true color depth: " + n13);
                float f = 8.225806f;
                byte[] byArray6 = new byte[2];
                boolean bl4 = false;
                while (var25_58 < n12) {
                    if (!bl3) {
                        n5 = (n12 - 1 - var25_58) * n11 * n6;
                    }
                    for (n2 = 0; n2 < n11; ++n2) {
                        byArray6[1] = byArray4[var25_58 * n11 + n2][0];
                        byArray6[0] = byArray4[var25_58 * n11 + n2][1];
                        byArray[n5 * 2 / n6 + 1] = byArray6[1];
                        byArray[n5 * 2 / n6] = byArray6[0];
                        byArray2[n5++] = (byte)((float)TgaLoader.getBitsAsByte(byArray6, 11, 5) * f);
                        byArray2[n5++] = (byte)((float)TgaLoader.getBitsAsByte(byArray6, 6, 5) * f);
                        byArray2[n5++] = (byte)((float)TgaLoader.getBitsAsByte(byArray6, 1, 5) * f);
                        if (n6 != 4) continue;
                        byArray2[n5++] = -1;
                    }
                    ++var25_58;
                }
            }
        } else if (n9 == 1) {
            int n19 = n13 / 8;
            for (int i = 0; i < n12; ++i) {
                if (!bl3) {
                    n5 = (n12 - 1 - i) * n11 * n6;
                }
                for (n4 = 0; n4 < n11; ++n4) {
                    int n20;
                    if (n19 == 1) {
                        n20 = dataInputStream.readUnsignedByte();
                    } else {
                        if (n19 != 2) throw new IOException("TGA: unknown colormap indexing size used: " + n19);
                        n20 = TgaLoader.flipEndian(dataInputStream.readShort());
                    }
                    if (n20 >= colorMapEntryArray.length || n20 < 0) {
                        throw new IOException("TGA: Invalid color map entry referenced: " + n20);
                    }
                    ColorMapEntry colorMapEntry = colorMapEntryArray[n20];
                    byArray2[n5++] = colorMapEntry.red;
                    byArray2[n5++] = colorMapEntry.green;
                    byArray2[n5++] = colorMapEntry.blue;
                    if (n6 != 4) continue;
                    byArray2[n5++] = colorMapEntry.alpha;
                }
            }
        } else if (n9 == 9) {
            int n21 = n13 / 8;
            int[] nArray = new int[n11 * n12];
            n4 = 0;
            while (n4 != nArray.length) {
                int n22 = dataInputStream.readByte();
                if ((n22 & 0x80) != 0) {
                    n22 &= 0x7F;
                    if (n21 == 1) {
                        n3 = dataInputStream.readUnsignedByte();
                    } else {
                        if (n21 != 2) throw new IOException("TGA: unknown colormap indexing size used: " + n21);
                        n3 = TgaLoader.flipEndian(dataInputStream.readShort());
                    }
                    if (n3 >= colorMapEntryArray.length || n3 < 0) {
                        throw new IOException("TGA: Invalid color map entry referenced: " + nArray[n4]);
                    }
                    while (n22-- >= 0) {
                        nArray[n4++] = n3;
                    }
                    continue;
                }
                while (n22-- >= 0) {
                    if (n21 == 1) {
                        nArray[n4] = dataInputStream.readUnsignedByte();
                    } else {
                        if (n21 != 2) throw new IOException("TGA: unknown colormap indexing size used: " + n21);
                        nArray[n4] = TgaLoader.flipEndian(dataInputStream.readShort());
                    }
                    if (nArray[n4] >= colorMapEntryArray.length || nArray[n4] < 0) {
                        throw new IOException("TGA: Invalid color map entry referenced: " + nArray[n4]);
                    }
                    ++n4;
                }
            }
            for (int i = 0; i < n12; ++i) {
                if (!bl3) {
                    n5 = (n12 - 1 - i) * n11 * n6;
                }
                for (n3 = 0; n3 < n11; ++n3) {
                    ColorMapEntry colorMapEntry = colorMapEntryArray[nArray[i * n11 + n3]];
                    byArray2[n5++] = colorMapEntry.red;
                    byArray2[n5++] = colorMapEntry.green;
                    byArray2[n5++] = colorMapEntry.blue;
                    if (n6 != 4) continue;
                    byArray2[n5++] = colorMapEntry.alpha;
                }
            }
        }
        inputStream.close();
        PaletteData paletteData = TgaLoader.loadPalette(colorMapEntryArray, n13);
        if (n6 == 4) {
            int n23;
            int[] nArray = new int[n11 * n12];
            int[] nArray2 = new int[n11 * n12];
            n2 = 0;
            for (n = 0; n != n11; ++n) {
                for (n23 = 0; n23 != n12; ++n23) {
                    if (byArray != null) {
                        nArray[n2] = (byArray[(n23 + n * n12) * 2 + 1] & 0xFF) << 0 | (byArray[(n23 + n * n12) * 2] & 0xFF) << 8;
                    } else {
                        byte by = byArray2[(n23 + n * n12) * 4];
                        byte by3 = byArray2[(n23 + n * n12) * 4 + 1];
                        n4 = byArray2[(n23 + n * n12) * 4 + 2];
                        RGB rGB = new RGB(by & 0xFF, by3 & 0xFF, n4 & 0xFF);
                        nArray[n2] = paletteData.getPixel(rGB);
                    }
                    nArray2[n2] = byArray2[(n23 + n * n12) * 4 + 3] & 0xFF;
                    ++n2;
                }
            }
            ImageData imageData = new ImageData(n11, n12, n13, paletteData);
            for (n23 = 0; n23 < imageData.height; ++n23) {
                for (int i = 0; i < imageData.width; ++i) {
                    imageData.setPixel(i, n23, nArray[n23 * n11 + i]);
                    if (!bl2) continue;
                    imageData.setAlpha(i, n23, nArray2[n23 * n11 + i]);
                }
            }
            return imageData;
        }
        int[] nArray = new int[n11 * n12];
        boolean bl5 = false;
        for (n2 = 0; n2 != n11; ++n2) {
            for (n = 0; n != n12; ++n) {
                if (byArray != null) {
                    nArray[var25_62++] = (byArray[(n + n2 * n12) * 2 + 1] & 0xFF) << 0 | (byArray[(n + n2 * n12) * 2] & 0xFF) << 8;
                    continue;
                }
                byte by = byArray2[(n + n2 * n12) * 3];
                byte by4 = byArray2[(n + n2 * n12) * 3 + 1];
                n4 = byArray2[(n + n2 * n12) * 3 + 2];
                RGB rGB = new RGB(by & 0xFF, by4 & 0xFF, n4 & 0xFF);
                nArray[var25_62++] = paletteData.getPixel(rGB);
            }
        }
        ImageData imageData = new ImageData(n11, n12, n13, paletteData);
        for (n = 0; n < imageData.height; ++n) {
            for (int i = 0; i < imageData.width; ++i) {
                imageData.setPixel(i, n, nArray[n * n11 + i]);
            }
        }
        return imageData;
    }

    public static void saveImage(OutputStream outputStream, ImageData imageData) throws IOException {
        TgaLoader.saveImage(outputStream, imageData, false, false, true);
    }

    public static void saveImage(OutputStream outputStream, ImageData imageData, boolean bl) throws IOException {
        TgaLoader.saveImage(outputStream, imageData, false, false, bl);
    }

    public static void saveImage(OutputStream outputStream, ImageData imageData, boolean bl, boolean bl2, boolean bl3) throws IOException {
        int n = imageData.depth == 32 || bl2 ? 4 : (imageData.getTransparencyType() == 0 ? 3 : 4);
        boolean bl4 = n == 3 && !imageData.palette.isDirect;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 8192);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        dataOutputStream.writeByte(0);
        if (bl4) {
            dataOutputStream.writeByte(1);
        } else {
            dataOutputStream.writeByte(0);
        }
        if (bl4) {
            if (bl3) {
                dataOutputStream.writeByte(9);
            } else {
                dataOutputStream.writeByte(1);
            }
        } else if (bl3) {
            dataOutputStream.writeByte(10);
        } else {
            dataOutputStream.writeByte(2);
        }
        if (bl4) {
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(TgaLoader.flipEndian((short)imageData.palette.getRGBs().length));
            dataOutputStream.writeByte(24);
        } else {
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(TgaLoader.flipEndian((short)imageData.width));
        dataOutputStream.writeShort(TgaLoader.flipEndian((short)imageData.height));
        if (n == 4) {
            dataOutputStream.writeByte(32);
        } else {
            dataOutputStream.writeByte(imageData.depth);
        }
        int n2 = 0;
        if (n == 4) {
            n2 = 8;
        } else if (bl4) {
            n2 = 0;
        } else if (imageData.depth == 24) {
            n2 = 0;
        } else if (imageData.depth == 16) {
            n2 = 1;
        }
        if (bl && !bl4) {
            n2 |= 0x20;
        }
        dataOutputStream.writeByte(n2);
        boolean bl5 = false;
        if ((n2 & 0x20) != 0) {
            bl5 = true;
        }
        if (bl4) {
            for (int i = 0; i < imageData.palette.getRGBs().length; ++i) {
                RGB rGB = imageData.palette.getRGBs()[i];
                dataOutputStream.writeByte((byte)rGB.blue);
                dataOutputStream.writeByte((byte)rGB.green);
                dataOutputStream.writeByte((byte)rGB.red);
            }
        }
        byte[] byArray = null;
        if (n == 4) {
            byArray = new byte[imageData.width * imageData.height * 4];
        } else if (n == 3) {
            byArray = new byte[imageData.width * imageData.height * 3];
        }
        int n3 = imageData.height;
        int n4 = imageData.width;
        int n5 = 0;
        if (n == 3) {
            RGB rGB;
            int n6;
            int n7;
            int n8;
            for (n8 = 0; n8 < n3; ++n8) {
                if (!bl5) {
                    n5 = (n3 - 1 - n8) * n4 * n;
                }
                for (n7 = 0; n7 < n4; ++n7) {
                    n6 = imageData.getPixel(n7, n8);
                    rGB = imageData.palette.getRGB(n6);
                    byArray[n5++] = (byte)rGB.red;
                    byArray[n5++] = (byte)rGB.green;
                    byArray[n5++] = (byte)rGB.blue;
                }
            }
            if (!bl3) {
                if (bl4) {
                    n8 = imageData.depth / 8;
                    List<RGB> list = Arrays.asList(imageData.palette.getRGBs());
                    for (n6 = 0; n6 < byArray.length; n6 += 3) {
                        rGB = new RGB(byArray[n6] & 0xFF, byArray[n6 + 1] & 0xFF, byArray[n6 + 2] & 0xFF);
                        int n9 = list.indexOf(rGB);
                        if (n9 > -1) {
                            if (n8 == 1) {
                                dataOutputStream.writeByte(n9);
                                continue;
                            }
                            if (n8 == 2) {
                                dataOutputStream.writeShort(TgaLoader.flipEndian((short)n9));
                                continue;
                            }
                            throw new IOException("TGA: unknown colormap indexing size used: " + n8);
                        }
                        throw new IOException("TGA: Invalid color map entry referenced: " + n9);
                    }
                } else if (imageData.depth == 24) {
                    for (n8 = 0; n8 < byArray.length; n8 += 3) {
                        dataOutputStream.writeByte(byArray[n8 + 2]);
                        dataOutputStream.writeByte(byArray[n8 + 1]);
                        dataOutputStream.writeByte(byArray[n8]);
                    }
                } else if (imageData.depth == 16) {
                    for (n8 = 0; n8 < byArray.length; n8 += 3) {
                        RGB rGB2 = new RGB(byArray[n8] & 0xFF, byArray[n8 + 1] & 0xFF, byArray[n8 + 2] & 0xFF);
                        n6 = imageData.palette.getPixel(rGB2);
                        dataOutputStream.writeByte((byte)(n6 & 0xFF));
                        dataOutputStream.writeByte((byte)(n6 >> 8 & 0xFF));
                    }
                }
            } else {
                CompressColor[] compressColorArray = new CompressColor[byArray.length / 3];
                for (n7 = 0; n7 < byArray.length / 3; ++n7) {
                    if (n7 < byArray.length / 3 - 1) {
                        compressColorArray[n7] = new CompressColor(new int[]{byArray[n7 * 3], byArray[n7 * 3 + 1], byArray[n7 * 3 + 2]}, new int[]{byArray[(n7 + 1) * 3], byArray[(n7 + 1) * 3 + 1], byArray[(n7 + 1) * 3 + 2]}, n7);
                        continue;
                    }
                    if (n7 != byArray.length / 3 - 1) continue;
                    compressColorArray[n7] = new CompressColor(new int[]{byArray[n7 * 3], byArray[n7 * 3 + 1], byArray[n7 * 3 + 2]}, null, n7);
                }
                List list = TgaLoader.getCompressColorMap(compressColorArray, imageData.width);
                if (bl4) {
                    n6 = imageData.depth / 8;
                    rGB = Arrays.asList(imageData.palette.getRGBs());
                    for (int i = 0; i < list.size(); ++i) {
                        CompressColor[] compressColorArray2 = (CompressColor[])list.get(i);
                        if (TgaLoader.equalColor(compressColorArray2[0].self, compressColorArray2[0].right)) {
                            dataOutputStream.writeByte(0x80 | compressColorArray2.length - 1);
                            RGB rGB3 = new RGB(byArray[compressColorArray2[0].index * 3] & 0xFF, byArray[compressColorArray2[0].index * 3 + 1] & 0xFF, byArray[compressColorArray2[0].index * 3 + 2] & 0xFF);
                            int n10 = rGB.indexOf(rGB3);
                            if (n10 > -1) {
                                if (n6 == 1) {
                                    dataOutputStream.writeByte(n10);
                                    continue;
                                }
                                if (n6 == 2) {
                                    dataOutputStream.writeShort(TgaLoader.flipEndian((short)n10));
                                    continue;
                                }
                                throw new IOException("TGA: unknown colormap indexing size used: " + n6);
                            }
                            throw new IOException("TGA: Invalid color map entry referenced: " + n10);
                        }
                        dataOutputStream.writeByte(0 | compressColorArray2.length - 1);
                        for (int j = 0; j < compressColorArray2.length; ++j) {
                            RGB rGB4 = new RGB(byArray[compressColorArray2[j].index * 3] & 0xFF, byArray[compressColorArray2[j].index * 3 + 1] & 0xFF, byArray[compressColorArray2[j].index * 3 + 2] & 0xFF);
                            int n11 = rGB.indexOf(rGB4);
                            if (n11 > -1) {
                                if (n6 == 1) {
                                    dataOutputStream.writeByte(n11);
                                    continue;
                                }
                                if (n6 == 2) {
                                    dataOutputStream.writeShort(TgaLoader.flipEndian((short)n11));
                                    continue;
                                }
                                throw new IOException("TGA: unknown colormap indexing size used: " + n6);
                            }
                            throw new IOException("TGA: Invalid color map entry referenced: " + n11);
                        }
                    }
                } else {
                    for (n6 = 0; n6 < list.size(); ++n6) {
                        rGB = (RGB)list.get(n6);
                        if (TgaLoader.equalColor(rGB[0].self, rGB[0].right)) {
                            dataOutputStream.writeByte(0x80 | ((RGB)rGB).length - 1);
                            if (imageData.depth == 24) {
                                dataOutputStream.writeByte(rGB[0].self[2]);
                                dataOutputStream.writeByte(rGB[0].self[1]);
                                dataOutputStream.writeByte(rGB[0].self[0]);
                                continue;
                            }
                            if (imageData.depth != 16) continue;
                            RGB rGB5 = new RGB(rGB[0].self[0] & 0xFF, rGB[0].self[1] & 0xFF, rGB[0].self[2] & 0xFF);
                            int n12 = imageData.palette.getPixel(rGB5);
                            dataOutputStream.writeByte((byte)(n12 & 0xFF));
                            dataOutputStream.writeByte((byte)(n12 >> 8 & 0xFF));
                            continue;
                        }
                        dataOutputStream.writeByte(0 | ((RGB)rGB).length - 1);
                        for (int i = 0; i < ((RGB)rGB).length; ++i) {
                            if (imageData.depth == 24) {
                                dataOutputStream.writeByte(rGB[i].self[2]);
                                dataOutputStream.writeByte(rGB[i].self[1]);
                                dataOutputStream.writeByte(rGB[i].self[0]);
                                continue;
                            }
                            if (imageData.depth != 16) continue;
                            RGB rGB6 = new RGB(rGB[i].self[0] & 0xFF, rGB[i].self[1] & 0xFF, rGB[i].self[2] & 0xFF);
                            int n13 = imageData.palette.getPixel(rGB6);
                            dataOutputStream.writeByte((byte)(n13 & 0xFF));
                            dataOutputStream.writeByte((byte)(n13 >> 8 & 0xFF));
                        }
                    }
                }
            }
        } else if (n == 4) {
            int n14;
            CompressColor[] compressColorArray;
            int n15;
            int n16;
            int n17;
            ImageData imageData2 = null;
            int n18 = 0;
            int n19 = 0;
            if (imageData.maskData != null) {
                imageData2 = imageData.getTransparencyMask();
                n18 = ~(imageData.palette.redMask | imageData.palette.greenMask | imageData.palette.blueMask);
                while (n18 != 0 && (n18 >>> n19 & 1) == 0) {
                    ++n19;
                }
            }
            for (n17 = 0; n17 < n3; ++n17) {
                if (!bl5) {
                    n5 = (n3 - 1 - n17) * n4 * n;
                }
                for (n16 = 0; n16 < n4; ++n16) {
                    n15 = imageData.getPixel(n16, n17);
                    compressColorArray = imageData.palette.getRGB(n15);
                    byArray[n5++] = (byte)compressColorArray.red;
                    byArray[n5++] = (byte)compressColorArray.green;
                    byArray[n5++] = (byte)compressColorArray.blue;
                    n14 = 255;
                    if (imageData.maskData != null) {
                        if (imageData.depth == 32) {
                            n14 = (n15 & n18) >>> n19;
                            if (n14 == 0) {
                                n14 = imageData2.getPixel(n16, n17) != 0 ? 255 : 0;
                            }
                        } else if (imageData2.getPixel(n16, n17) == 0) {
                            n14 = 0;
                        }
                    } else if (imageData.transparentPixel != -1) {
                        if (imageData.transparentPixel == n15) {
                            n14 = 0;
                        }
                    } else if (imageData.alpha != -1) {
                        n14 = imageData.alpha;
                    } else if (imageData.alphaData != null) {
                        n14 = imageData.getAlpha(n16, n17);
                    }
                    byArray[n5++] = (byte)n14;
                }
            }
            if (!bl3) {
                for (n17 = 0; n17 < byArray.length; n17 += 4) {
                    dataOutputStream.writeByte(byArray[n17 + 2]);
                    dataOutputStream.writeByte(byArray[n17 + 1]);
                    dataOutputStream.writeByte(byArray[n17]);
                    dataOutputStream.writeByte(byArray[n17 + 3]);
                }
            } else {
                CompressColor[] compressColorArray3 = new CompressColor[byArray.length / 4];
                for (n16 = 0; n16 < byArray.length / 4; ++n16) {
                    if (n16 < byArray.length / 4 - 1) {
                        compressColorArray3[n16] = new CompressColor(new int[]{byArray[n16 * 4], byArray[n16 * 4 + 1], byArray[n16 * 4 + 2], byArray[n16 * 4 + 3]}, new int[]{byArray[(n16 + 1) * 4], byArray[(n16 + 1) * 4 + 1], byArray[(n16 + 1) * 4 + 2], byArray[(n16 + 1) * 4 + 3]}, n16);
                        continue;
                    }
                    if (n16 != byArray.length / 4 - 1) continue;
                    compressColorArray3[n16] = new CompressColor(new int[]{byArray[n16 * 4], byArray[n16 * 4 + 1], byArray[n16 * 4 + 2], byArray[n16 * 4 + 3]}, null, n16);
                }
                List list = TgaLoader.getCompressColorMap(compressColorArray3, imageData.width);
                for (n15 = 0; n15 < list.size(); ++n15) {
                    compressColorArray = (CompressColor[])list.get(n15);
                    if (TgaLoader.equalColor(compressColorArray[0].self, compressColorArray[0].right)) {
                        dataOutputStream.writeByte(0x80 | compressColorArray.length - 1);
                        dataOutputStream.writeByte(compressColorArray[0].self[2]);
                        dataOutputStream.writeByte(compressColorArray[0].self[1]);
                        dataOutputStream.writeByte(compressColorArray[0].self[0]);
                        dataOutputStream.writeByte(compressColorArray[0].self[3]);
                        continue;
                    }
                    dataOutputStream.writeByte(0 | compressColorArray.length - 1);
                    for (n14 = 0; n14 < compressColorArray.length; ++n14) {
                        dataOutputStream.writeByte(compressColorArray[n14].self[2]);
                        dataOutputStream.writeByte(compressColorArray[n14].self[1]);
                        dataOutputStream.writeByte(compressColorArray[n14].self[0]);
                        dataOutputStream.writeByte(compressColorArray[n14].self[3]);
                    }
                }
            }
        }
        dataOutputStream.close();
    }

    private static List getCompressColorMap(CompressColor[] compressColorArray, int n) {
        ArrayList<CompressColor[]> arrayList = new ArrayList<CompressColor[]>();
        ArrayList<CompressColor> arrayList2 = new ArrayList<CompressColor>();
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < compressColorArray.length; ++i) {
            CompressColor compressColor = compressColorArray[i];
            if (n2 == -1) {
                n2 = TgaLoader.equalColor(compressColor.self, compressColor.right) ? 1 : 0;
                arrayList2.add(compressColor);
                if (++n3 != n) continue;
                n2 = -1;
                arrayList.add(arrayList2.toArray(new CompressColor[0]));
                arrayList2.clear();
                n3 = 0;
                continue;
            }
            if (n2 == 0) {
                arrayList2.add(compressColor);
                if (!TgaLoader.equalColor(compressColor.self, compressColor.right) && arrayList2.size() != 128 && ++n3 != n) continue;
                n2 = -1;
                arrayList.add(arrayList2.toArray(new CompressColor[0]));
                arrayList2.clear();
                if (n3 != n) continue;
                n3 = 0;
                continue;
            }
            if (n2 != 1) continue;
            arrayList2.add(compressColor);
            if (TgaLoader.equalColor(compressColor.self, compressColor.right) && arrayList2.size() != 128 && ++n3 != n) continue;
            n2 = -1;
            arrayList.add(arrayList2.toArray(new CompressColor[0]));
            arrayList2.clear();
            if (n3 != n) continue;
            n3 = 0;
        }
        return arrayList;
    }

    private static boolean equalColor(int[] nArray, int[] nArray2) {
        if (nArray == null && nArray2 != null) {
            return false;
        }
        if (nArray != null && nArray2 == null) {
            return false;
        }
        if (nArray != null && nArray2 != null) {
            if (nArray.length != nArray2.length) {
                return false;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                return false;
            }
        }
        return true;
    }

    private static byte getBitsAsByte(byte[] byArray, int n, int n2) {
        int n3 = n / 8;
        int n4 = n % 8;
        int n5 = 0;
        int n6 = n2;
        while (--n6 >= 0) {
            int n7;
            byte by = byArray[n3];
            int n8 = n7 = n4 == 7 ? 1 : 2 << 6 - n4;
            if ((by & n7) != 0) {
                n5 = n6 == 0 ? ++n5 : (n5 += 2 << n6 - 1);
            }
            if (++n4 != 8) continue;
            n4 = 0;
            ++n3;
        }
        return (byte)n5;
    }

    private static short flipEndian(short s) {
        int n = s & 0xFFFF;
        return (short)(n << 8 | (n & 0xFF00) >>> 8);
    }

    private static PaletteData loadPalette(ColorMapEntry[] colorMapEntryArray, int n) throws IOException {
        if (colorMapEntryArray != null && colorMapEntryArray.length > 0) {
            int n2 = colorMapEntryArray.length;
            if (n2 == 0) {
                n2 = 1 << n;
            }
            return TgaLoader.paletteFromBytes(colorMapEntryArray, n2);
        }
        if (n < 16) {
            throw new IOException("Unsupported TGA color depth: " + n);
        }
        if (n == 16) {
            return new PaletteData(31744, 992, 31);
        }
        return new PaletteData(255, 65280, 0xFF0000);
    }

    private static PaletteData paletteFromBytes(ColorMapEntry[] colorMapEntryArray, int n) {
        RGB[] rGBArray = new RGB[n];
        for (int i = 0; i < n; ++i) {
            rGBArray[i] = new RGB(colorMapEntryArray[i].red & 0xFF, colorMapEntryArray[i].green & 0xFF, colorMapEntryArray[i].blue & 0xFF);
        }
        return new PaletteData(rGBArray);
    }

    static class ColorMapEntry {
        byte red;
        byte green;
        byte blue;
        byte alpha;

        ColorMapEntry() {
        }

        public String toString() {
            return "entry: " + this.red + "," + this.green + "," + this.blue + "," + this.alpha;
        }
    }

    static class CompressColor {
        int[] self;
        int[] right;
        int index;

        public CompressColor(int[] nArray, int[] nArray2, int n) {
            this.self = nArray;
            this.right = nArray2;
            this.index = n;
        }
    }
}

