/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna;

import org.sf.feeling.swt.win32.internal.extension.Extension;

public final class Function {
    private int fPoint;
    private int dllHandle;
    private final String dll;
    private final String name;
    private final int hash;

    public Function(String string, String string2) throws Exception {
        if (string == null || string2 == null) {
            throw new NullPointerException("neither the DLL name (" + string + ") or the function name (" + string2 + ") can be null");
        }
        this.name = string2;
        this.dll = string;
        this.dllHandle = Extension.LoadLibrary(string);
        this.fPoint = Extension.LoadFunction(this.dllHandle, string2);
        this.hash = string.hashCode() ^ string2.hashCode();
    }

    public int hashCode() {
        return this.hash;
    }

    public int getHandle() {
        this.checkState();
        return this.fPoint;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Function function = (Function)object;
        return this.dll.equals(function.dll) && this.name.equals(function.name);
    }

    public String toString() {
        return "[" + this.dll + ":" + this.name + "]";
    }

    public synchronized void close() throws Exception {
        if (this.fPoint != 0) {
            Extension.FreeLibrary((int)this.dllHandle);
            this.dllHandle = 0;
            this.fPoint = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void checkState() {
        if (this.fPoint == 0) {
            throw new IllegalStateException(this.toString() + " has been closed");
        }
    }

    public int invoke_I() throws Exception {
        this.checkState();
        return Extension.Invoke_I(this.fPoint);
    }

    public int invoke_I(int n) throws Exception {
        this.checkState();
        return Extension.InvokeI_I(n, this.fPoint);
    }

    public boolean invoke_B(int n) throws Exception {
        return this.invoke_I(n) != 0;
    }

    public boolean invoke_B(boolean bl) throws Exception {
        return this.invoke_I(bl ? 1 : 0) != 0;
    }

    public int invoke_I(int n, int n2) throws Exception {
        this.checkState();
        return Extension.InvokeII_I(n, n2, this.fPoint);
    }

    public int invoke_I(int n, int n2, int n3) throws Exception {
        this.checkState();
        return Extension.InvokeIII_I(n, n2, n3, this.fPoint);
    }

    public boolean invoke_B(int n, int n2, int n3) throws Exception {
        return this.invoke_I(n, n2, n3) != 0;
    }

    public int invoke_I(int n, int n2, int n3, int n4) throws Exception {
        this.checkState();
        return Extension.InvokeIIII_I(n, n2, n3, n4, this.fPoint);
    }

    public int invoke_I(String string) throws Exception {
        this.checkState();
        return Extension.InvokeG_I(string, this.fPoint);
    }

    public int invoke_I(String string, String string2) throws Exception {
        this.checkState();
        return Extension.InvokeGG_I(string, string2, this.fPoint);
    }

    public int invoke_I(int n, String string) throws Exception {
        this.checkState();
        return Extension.InvokeIG_I(n, string, this.fPoint);
    }

    public int invoke_I(int n, String string, String string2, int n2) throws Exception {
        this.checkState();
        return Extension.InvokeIGGI_I(n, string, string2, n2, this.fPoint);
    }

    public int invoke_I(byte[] byArray) throws Exception {
        this.checkState();
        return Extension.InvokeP_I(byArray, this.fPoint);
    }

    public int invoke_OI(int n) throws Exception {
        this.checkState();
        return Extension.InvokeIO(n, this.fPoint);
    }

    public int invoke_OI(int n, int n2, int n3, int n4) throws Exception {
        this.checkState();
        return Extension.InvokeIIIIO(n, n2, n3, n4, this.fPoint);
    }

    public int invoke_OI(int n, String string) throws Exception {
        this.checkState();
        return Extension.InvokeIGO(n, string, this.fPoint);
    }

    public byte[] invoke_S(int n, int n2) throws Exception {
        this.checkState();
        return Extension.InvokeI_S(n, n2, this.fPoint);
    }

    public byte[] invoke_S(byte[] byArray, int n) throws Exception {
        this.checkState();
        return Extension.InvokeP_S(byArray, n, this.fPoint);
    }

    public byte[] invoke_S(byte[] byArray, int n, int n2) throws Exception {
        this.checkState();
        return Extension.InvokePI_S(byArray, n, n2, this.fPoint);
    }
}

