/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.shell;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.SHELLEXECUTEINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.sf.feeling.swt.win32.extension.jna.Function;
import org.sf.feeling.swt.win32.extension.jna.ptr.IntByReference;
import org.sf.feeling.swt.win32.extension.shell.IExtractIcon;
import org.sf.feeling.swt.win32.extension.shell.ShellFolder;
import org.sf.feeling.swt.win32.extension.shell.ShellIcon;
import org.sf.feeling.swt.win32.internal.extension.Extension;
import org.sf.feeling.swt.win32.internal.extension.SHFILEINFO;
import org.sf.feeling.swt.win32.internal.extension.SHFILEINFOA;
import org.sf.feeling.swt.win32.internal.extension.SHFILEINFOW;

public class IShellFolder {
    private static DesktopFolder desktop;
    private static List PIDLList;
    private static int ppMalloc;
    private static final String SHEll32_LIB = "shell32";
    private static List ShellFolderList;
    CanonicalPIDL bindingPIDL;
    int handle;
    int hWnd;

    public static int getAttributes(PIDL pIDL) {
        if (pIDL == null || pIDL.getPidl() == 0) {
            return 0;
        }
        SHFILEINFO sHFILEINFO = Extension.IsUnicode ? new SHFILEINFOW() : new SHFILEINFOA();
        Extension.SHGetFileInfo(pIDL.getPidl(), 0, sHFILEINFO, SHFILEINFO.sizeof, 2056);
        return sHFILEINFO.dwAttributes;
    }

    public static CanonicalPIDL getCanonicalPIDL(DesktopFolder desktopFolder, String string) {
        RelativePIDL relativePIDL = desktopFolder.getPIDL(string);
        if (relativePIDL != null) {
            return desktopFolder.getCanonicalPIDL(relativePIDL);
        }
        return null;
    }

    public static DesktopFolder getDesktopFolder(int n) {
        if (desktop != null && !desktop.isDisposed()) {
            return desktop;
        }
        IShellFolder.init();
        try {
            Function function = new Function(SHEll32_LIB, "SHGetDesktopFolder");
            IntByReference intByReference = new IntByReference();
            function.invoke_I(intByReference.getPointer().getPointer());
            function.close();
            if (intByReference.getValue() == 0) {
                return null;
            }
            CanonicalPIDL canonicalPIDL = ShellFolder.getFolderPIDL(ShellFolder.DESKTOP);
            desktop = new DesktopFolder(n, intByReference.getValue(), canonicalPIDL);
            return desktop;
        }
        catch (Exception exception) {
            SWT.error((int)47);
            return null;
        }
    }

    public static Image getIcon(PIDL pIDL, boolean bl) {
        if (pIDL == null || pIDL.getPidl() == 0) {
            return null;
        }
        int n = 0;
        n = !bl ? (n |= 1) : (n |= 0);
        SHFILEINFO sHFILEINFO = Extension.IsUnicode ? new SHFILEINFOW() : new SHFILEINFOA();
        Extension.SHGetFileInfo(pIDL.getPidl(), 0, sHFILEINFO, SHFILEINFO.sizeof, 0x108 | n);
        if (sHFILEINFO.hIcon != 0) {
            return Image.win32_new(null, (int)1, (int)sHFILEINFO.hIcon);
        }
        return null;
    }

    public static String getPIDLCanonicalName(DesktopFolder desktopFolder, CanonicalPIDL canonicalPIDL) {
        RelativePIDL relativePIDL = new RelativePIDL(canonicalPIDL);
        return desktopFolder.getPIDLName(relativePIDL);
    }

    public static String getPIDLDisplayName(DesktopFolder desktopFolder, CanonicalPIDL canonicalPIDL, int n) {
        RelativePIDL relativePIDL = new RelativePIDL(canonicalPIDL);
        return desktopFolder.getPIDLDisplayName(relativePIDL, n);
    }

    public static IShellFolder getRelativeParent(DesktopFolder desktopFolder, CanonicalPIDL canonicalPIDL) {
        if (canonicalPIDL == null || canonicalPIDL.getPidl() == 0 || desktopFolder == null) {
            return null;
        }
        int n = Extension.IShellFolder_GetParent(canonicalPIDL.getPidl());
        return new IShellFolder(desktopFolder.hWnd, n);
    }

    public static RelativePIDL getRelativePIDL(CanonicalPIDL canonicalPIDL) {
        if (canonicalPIDL == null || canonicalPIDL.getPidl() == 0) {
            return null;
        }
        int n = Extension.IShellFolder_GetRelativeHandle(canonicalPIDL.getPidl());
        if (n == 0) {
            return null;
        }
        return new RelativePIDL(n);
    }

    public static String getTypeName(PIDL pIDL) {
        if (pIDL == null || pIDL.getPidl() == 0) {
            return null;
        }
        SHFILEINFO sHFILEINFO = Extension.IsUnicode ? new SHFILEINFOW() : new SHFILEINFOA();
        Extension.SHGetFileInfo(pIDL.getPidl(), 0, sHFILEINFO, SHFILEINFO.sizeof, 1032);
        if (!Extension.IsUnicode) {
            byte[] byArray = ((SHFILEINFOA)sHFILEINFO).szTypeName;
            TCHAR tCHAR = new TCHAR(0, byArray.length);
            tCHAR.bytes = byArray;
            return tCHAR.toString(0, tCHAR.strlen());
        }
        char[] cArray = sHFILEINFO.szTypeName;
        TCHAR tCHAR = new TCHAR(0, cArray.length);
        tCHAR.chars = cArray;
        return tCHAR.toString(0, tCHAR.strlen());
    }

    public static boolean hasSubFolder(PIDL pIDL) {
        if (pIDL == null || pIDL.getPidl() == 0) {
            return false;
        }
        int n = Integer.MIN_VALUE;
        int n2 = IShellFolder.getAttributes(pIDL);
        return (n2 & n) != 0;
    }

    private static void init() {
        if (ppMalloc == 0) {
            ppMalloc = Extension.SHGetMalloc();
        }
    }

    public static boolean isFileSystem(PIDL pIDL) {
        if (pIDL == null || pIDL.getPidl() == 0) {
            return true;
        }
        int n = 0x40000000;
        int n2 = IShellFolder.getAttributes(pIDL);
        return (n2 & n) != 0;
    }

    public static boolean isFolder(PIDL pIDL) {
        if (pIDL == null || pIDL.getPidl() == 0) {
            return false;
        }
        int n = 0x20000000;
        int n2 = IShellFolder.getAttributes(pIDL);
        return (n2 & n) != 0;
    }

    public static boolean isHidden(PIDL pIDL) {
        if (pIDL == null || pIDL.getPidl() == 0) {
            return false;
        }
        int n = 524288;
        int n2 = IShellFolder.getAttributes(pIDL);
        return (n2 & n) != 0;
    }

    public static boolean isLinkFile(PIDL pIDL) {
        if (pIDL == null || pIDL.getPidl() == 0) {
            return false;
        }
        int n = 65536;
        int n2 = IShellFolder.getAttributes(pIDL);
        return (n2 & n) != 0;
    }

    public static boolean isStorage(PIDL pIDL) {
        if (pIDL == null || pIDL.getPidl() == 0) {
            return false;
        }
        int n = 0x20400000;
        int n2 = IShellFolder.getAttributes(pIDL);
        return (n2 & n) != 0;
    }

    public static boolean isSystemFolder(PIDL pIDL) {
        CanonicalPIDL canonicalPIDL = ShellFolder.getFolderPIDL(ShellFolder.DRIVES);
        String string = IShellFolder.getTypeName(canonicalPIDL);
        canonicalPIDL.dispose();
        return string.equals(IShellFolder.getTypeName(pIDL));
    }

    public static boolean launchPIDL(CanonicalPIDL canonicalPIDL) {
        if (canonicalPIDL == null || canonicalPIDL.getPidl() == 0) {
            return false;
        }
        SHELLEXECUTEINFO sHELLEXECUTEINFO = new SHELLEXECUTEINFO();
        sHELLEXECUTEINFO.cbSize = SHELLEXECUTEINFO.sizeof;
        sHELLEXECUTEINFO.lpIDList = canonicalPIDL.getPidl();
        sHELLEXECUTEINFO.nShow = 5;
        sHELLEXECUTEINFO.fMask = 4;
        boolean bl = OS.ShellExecuteEx((SHELLEXECUTEINFO)sHELLEXECUTEINFO);
        return bl;
    }

    public static void releaseShellMalloc() {
        if (ppMalloc != 0) {
            if (desktop != null && !desktop.isDisposed()) {
                desktop.dispose();
            }
            PIDL[] pIDLArray = PIDLList.toArray(new PIDL[0]);
            for (int i = 0; i < pIDLArray.length; ++i) {
                pIDLArray[i].dispose();
            }
            Extension.ReleaseShellMalloc(ppMalloc);
            ppMalloc = 0;
        }
    }

    IShellFolder(int n, int n2) {
        this.hWnd = n;
        this.handle = n2;
        ShellFolderList.add(this);
    }

    IShellFolder(int n, int n2, CanonicalPIDL canonicalPIDL) {
        this.hWnd = n;
        this.handle = n2;
        this.bindingPIDL = canonicalPIDL;
        ShellFolderList.add(this);
    }

    public void dispose() {
        if (this.handle != 0 && desktop != null && this.handle != IShellFolder.desktop.handle) {
            Extension.ReleaseIShellFolder(this.handle);
            IShellFolder[] iShellFolderArray = ShellFolderList.toArray(new IShellFolder[0]);
            for (int i = 0; i < iShellFolderArray.length; ++i) {
                IShellFolder iShellFolder = iShellFolderArray[i];
                if (iShellFolder.handle != this.handle) continue;
                iShellFolder.handle = 0;
                ShellFolderList.remove(iShellFolder);
            }
            this.handle = 0;
        }
    }

    public int getAttributesOf(RelativePIDL relativePIDL, int n) {
        if (this.handle == 0 || relativePIDL == null || relativePIDL.getPidl() == 0) {
            return 0;
        }
        return Extension.IShellFolder_GetAttributesOf(this.handle, relativePIDL.getPidl(), n);
    }

    public CanonicalPIDL getBindingPIDL() {
        return this.bindingPIDL;
    }

    public CanonicalPIDL getCanonicalPIDL(RelativePIDL relativePIDL) {
        if (this.bindingPIDL != null) {
            int n = Extension.IShellFolder_ConcatPIDLs(this.bindingPIDL.getPidl(), relativePIDL.getPidl());
            return new CanonicalPIDL(n, relativePIDL);
        }
        return null;
    }

    public RelativePIDL getFullyQualPIDL(RelativePIDL relativePIDL) {
        if (this.handle == 0 || relativePIDL == null || relativePIDL.getPidl() == 0) {
            return null;
        }
        String string = this.getPIDLName(relativePIDL);
        if (string != null) {
            return IShellFolder.getDesktopFolder(this.handle).getPIDL(string);
        }
        return null;
    }

    public IExtractIcon getIExtractIcon(RelativePIDL relativePIDL) {
        if (this.handle == 0 || relativePIDL == null || relativePIDL.getPidl() == 0) {
            return null;
        }
        int n = Extension.IShellFolder_GetIExtractIcon(this.handle, this.hWnd, relativePIDL.getPidl());
        if (n != 0) {
            return new IExtractIcon(n);
        }
        return null;
    }

    public RelativePIDL getPIDL(String string) {
        if (this.handle == 0 || string == null) {
            return null;
        }
        TCHAR tCHAR = new TCHAR(0, string, true);
        int n = Extension.IShellFolder_ParseDisplayName(this.handle, this.hWnd, tCHAR.chars);
        if (n == 0) {
            return null;
        }
        return new RelativePIDL(n);
    }

    public String getPIDLDisplayName(RelativePIDL relativePIDL, int n) {
        if (this.handle == 0 || relativePIDL == null || relativePIDL.getPidl() == 0) {
            return null;
        }
        return Extension.IShellFolder_GetDisplayNameOf(this.handle, relativePIDL.getPidl(), n);
    }

    public RelativePIDL[] getPIDLItems(int n) {
        if (this.handle == 0) {
            return new RelativePIDL[0];
        }
        List list = Extension.IShellFolder_EnumObjects(this.handle, this.hWnd, n);
        if (list == null) {
            return new RelativePIDL[0];
        }
        RelativePIDL[] relativePIDLArray = new RelativePIDL[list.size()];
        for (int i = 0; i < relativePIDLArray.length; ++i) {
            relativePIDLArray[i] = new RelativePIDL((int)((Integer)list.get(i)), this);
        }
        return relativePIDLArray;
    }

    public IShellFolder getPIDLItemsHolder(RelativePIDL relativePIDL) {
        if (this.handle == 0 || relativePIDL == null || relativePIDL.getPidl() == 0) {
            return null;
        }
        int n = Extension.IShellFolder_BindToObject(this.handle, relativePIDL.getPidl());
        if (n != 0) {
            IShellFolder iShellFolder = new IShellFolder(this.hWnd, n);
            iShellFolder.bindingPIDL = this.getCanonicalPIDL(relativePIDL);
            return iShellFolder;
        }
        return null;
    }

    public String getPIDLName(RelativePIDL relativePIDL) {
        if (this.handle == 0 || relativePIDL == null || relativePIDL.getPidl() == 0) {
            return null;
        }
        return Extension.IShellFolder_GetDisplayNameOf(this.handle, relativePIDL.getPidl(), 32768);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    static {
        PIDLList = new ArrayList();
        ShellFolderList = new ArrayList();
    }

    public static final class CanonicalPIDL
    extends PIDL {
        private RelativePIDL relativePIDL;

        CanonicalPIDL(int n) {
            super(n, true);
        }

        public CanonicalPIDL(int n, RelativePIDL relativePIDL) {
            super(n, true);
            this.relativePIDL = relativePIDL;
        }

        CanonicalPIDL(PIDL pIDL) {
            super(pIDL.pidl, true);
        }

        public RelativePIDL getRelativePIDL() {
            return this.relativePIDL;
        }
    }

    public static class DesktopFolder
    extends IShellFolder {
        DesktopFolder(int n, int n2, CanonicalPIDL canonicalPIDL) {
            super(n, n2, canonicalPIDL);
        }

        public void dispose() {
            Extension.ReleaseIShellFolder(this.handle);
            IShellFolder[] iShellFolderArray = ShellFolderList.toArray(new IShellFolder[0]);
            for (int i = 0; i < iShellFolderArray.length; ++i) {
                IShellFolder iShellFolder = iShellFolderArray[i];
                if (iShellFolder.handle != this.handle) continue;
                iShellFolder.handle = 0;
                ShellFolderList.remove(iShellFolder);
            }
            this.handle = 0;
        }

        public String getDisplayName() {
            CanonicalPIDL canonicalPIDL = ShellFolder.getFolderPIDL(ShellFolder.DESKTOP);
            String string = IShellFolder.getPIDLDisplayName(this, canonicalPIDL, 0);
            canonicalPIDL.dispose();
            return string;
        }

        public Image getIcon(boolean bl) {
            return ShellIcon.getSysFolderIcon(ShellFolder.DESKTOP, bl ? 32768 : 65536);
        }
    }

    static class PIDL {
        private boolean absolute;
        private int pidl;

        PIDL(int n, boolean bl) {
            this.pidl = n;
            this.absolute = bl;
            PIDLList.add(this);
        }

        public void dispose() {
            if (ppMalloc != 0 && this.pidl != 0) {
                Extension.ReleaseItemIdList(ppMalloc, this.pidl);
                PIDL[] pIDLArray = PIDLList.toArray(new PIDL[0]);
                for (int i = 0; i < pIDLArray.length; ++i) {
                    PIDL pIDL = pIDLArray[i];
                    if (pIDL.pidl != this.pidl) continue;
                    pIDL.pidl = 0;
                    PIDLList.remove(pIDL);
                }
            }
        }

        int getPidl() {
            return this.pidl;
        }

        public boolean isCanonical() {
            return this.absolute;
        }

        public boolean isDisposed() {
            return this.pidl == 0;
        }
    }

    public static final class RelativePIDL
    extends PIDL {
        private IShellFolder parentFolder;

        RelativePIDL(int n) {
            super(n, false);
        }

        public RelativePIDL(int n, IShellFolder iShellFolder) {
            super(n, false);
            this.parentFolder = iShellFolder;
        }

        RelativePIDL(PIDL pIDL) {
            super(pIDL.pidl, false);
        }

        public IShellFolder getParentFolder() {
            return this.parentFolder;
        }
    }

    public static interface SFGAO {
        public static final int BROWSABLE = 0x8000000;
        public static final int CANCOPY = 1;
        public static final int CANDELETE = 32;
        public static final int CANLINK = 4;
        public static final int CANMONIKER = 0x400000;
        public static final int CANMOVE = 2;
        public static final int CANRENAME = 16;
        public static final int CAPABILITYMASK = 375;
        public static final int COMPRESSED = 0x4000000;
        public static final int CONTENTSMASK = Integer.MIN_VALUE;
        public static final int DISPLAYATTRMASK = 1032192;
        public static final int DROPTARGET = 256;
        public static final int ENCRYPTED = 8192;
        public static final int FILESYSANCESTOR = 0x10000000;
        public static final int FILESYSTEM = 0x40000000;
        public static final int FOLDER = 0x20000000;
        public static final int GHOSTED = 32768;
        public static final int HASPROPSHEET = 64;
        public static final int HASSTORAGE = 0x400000;
        public static final int HASSUBFOLDER = Integer.MIN_VALUE;
        public static final int HIDDEN = 524288;
        public static final int ISSLOW = 16384;
        public static final int LINK = 65536;
        public static final int NEWCONTENT = 0x200000;
        public static final int NONENUMERATED = 0x100000;
        public static final int READONLY = 262144;
        public static final int REMOVABLE = 0x2000000;
        public static final int SHARE = 131072;
        public static final int STORAGE = 8;
        public static final int STORAGEANCESTOR = 0x800000;
        public static final int STORAGECAPMASK = 1891958792;
        public static final int STREAM = 0x400000;
        public static final int SYSTEM = 4096;
        public static final int VALIDATE = 0x1000000;
    }

    public static interface SHCONTF {
        public static final int FOLDERS = 32;
        public static final int INCLUDEHIDDEN = 128;
        public static final int INIT_ON_FIRST_NEXT = 256;
        public static final int NETPRINTERSRCH = 512;
        public static final int NONFOLDERS = 64;
        public static final int SHAREABLE = 1024;
        public static final int STORAGE = 2048;
    }

    public static interface SHGDNF {
        public static final int FORADDRESSBAR = 16384;
        public static final int FOREDITING = 4096;
        public static final int FORPARSING = 32768;
        public static final int INFOLDER = 1;
        public static final int NORMAL = 0;
    }
}

