/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.shell;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.sf.feeling.swt.win32.extension.shell.SystemMenuManager;

public class SystemMenuItem {
    private static int MENU_ID = 61440;
    public static final int ITEM_MOVE_ID = 61456;
    public static final int ITEM_MAXIMIZE_ID = 61488;
    public static final int ITEM_MINIMIZE_ID = 61472;
    public static final int ITEM_SIZE_ID = 61440;
    public static final int ITEM_RESTORE_ID = 61728;
    public static final int ITEM_CLOSE_ID = 61536;
    private String text = "";
    private int style = 0;
    private int id;
    private boolean selected = false;
    private boolean enabled = true;
    private Image image = null;
    private SystemMenuManager manager;
    private List listeners = new ArrayList();

    public SystemMenuItem(SystemMenuManager systemMenuManager, int n) {
        this.style = n;
        this.id = --MENU_ID;
        this.manager = systemMenuManager;
    }

    private SystemMenuItem(SystemMenuManager systemMenuManager) {
        this.manager = systemMenuManager;
    }

    public String getText() {
        if (SystemMenuItem.valueOf(this.manager, this.id) != null) {
            return this.manager.getText(this.id);
        }
        return this.text;
    }

    public void setImage(Image image) {
        this.image = image;
        if (SystemMenuItem.valueOf(this.manager, this.id) != null) {
            this.manager.setImage(this.id, image);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setText(String string) {
        this.text = string;
        if (SystemMenuItem.valueOf(this.manager, this.id) != null) {
            this.manager.setText(this.id, string);
        }
    }

    public int getStyle() {
        return this.style;
    }

    public void setSelection(boolean bl) {
        this.selected = bl;
        if (this.manager.getItem(this.id) != null) {
            this.manager.setSelection(this.id, bl);
        }
    }

    public boolean getSelection() {
        if (this.manager.getItem(this.id) != null) {
            return this.manager.getSelection(this.id);
        }
        return this.selected;
    }

    public Integer getId() {
        return new Integer(this.id);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void fireSelectedEvent(Event event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).handleEvent(event);
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.manager.getItem(this.id) != null) {
            this.manager.setEnabled(this.id, bl);
        }
    }

    public boolean isEnabled() {
        if (this.manager.getItem(this.id) != null) {
            return this.manager.getEnabled(this.id);
        }
        return this.enabled;
    }

    public void dispose() {
        if (SystemMenuItem.valueOf(this.manager, this.id) != null) {
            this.manager.removeItem(this.id);
        }
        this.listeners.clear();
    }

    public static SystemMenuItem valueOf(SystemMenuManager systemMenuManager, int n) {
        switch (n) {
            case 61440: 
            case 61456: 
            case 61472: 
            case 61488: 
            case 61536: 
            case 61728: {
                SystemMenuItem systemMenuItem = new SystemMenuItem(systemMenuManager);
                systemMenuItem.id = n;
                return systemMenuItem;
            }
        }
        if (n >= 61440) {
            throw new IllegalArgumentException("The menu id is illegal.");
        }
        return systemMenuManager.getItem(n);
    }
}

