/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.sf.feeling.swt.win32.extension.widgets.CMenuItem;
import org.sf.feeling.swt.win32.extension.widgets.listener.MenuListener;

public class CMenu {
    private List items = new ArrayList();
    private List listeners;

    public CMenuItem addItem(CMenuItem cMenuItem) {
        this.items.add(cMenuItem);
        return cMenuItem;
    }

    public void addItems(CMenuItem[] cMenuItemArray) {
        for (int i = 0; i < cMenuItemArray.length; ++i) {
            this.addItem(cMenuItemArray[i]);
        }
    }

    public void removeItem(CMenuItem cMenuItem) {
        cMenuItem.disposed();
        this.items.remove(cMenuItem);
    }

    public void addItem(int n, CMenuItem cMenuItem) {
        this.items.add(n, cMenuItem);
    }

    public void removeAll() {
        while (this.items.size() > 0) {
            this.removeItem(this.getItem(0));
        }
    }

    public boolean contains(CMenuItem cMenuItem) {
        return this.items.contains(cMenuItem);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public CMenuItem getItem(int n) {
        if (n < 0 || n >= this.items.size()) {
            SWT.error((int)5);
        }
        return (CMenuItem)this.items.get(n);
    }

    public CMenuItem getItem(String string) {
        for (int i = 0; i < this.items.size(); ++i) {
            CMenuItem cMenuItem = this.getItem(i);
            if (!cMenuItem.getText().equals(string)) continue;
            return cMenuItem;
        }
        return null;
    }

    public boolean visibleItems() {
        for (int i = 0; i < this.items.size(); ++i) {
            CMenuItem cMenuItem = this.getItem(i);
            if (!cMenuItem.isVisible() || cMenuItem.getText().equals("-") || cMenuItem.getMenu() != null && cMenuItem.getMenu().getItemCount() > 0 && !cMenuItem.getMenu().visibleItems()) continue;
            return true;
        }
        return false;
    }

    public int indexOf(CMenuItem cMenuItem) {
        return this.items.indexOf(cMenuItem);
    }

    public void addMenuListener(MenuListener menuListener) {
        if (menuListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(menuListener)) {
            this.listeners.add(menuListener);
        }
    }

    public void removeMenuListener(MenuListener menuListener) {
        if (menuListener == null) {
            return;
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(menuListener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    void fireMenuEvent(Event event) {
        if (this.listeners != null) {
            block5: for (int i = 0; i < this.listeners.size(); ++i) {
                MenuListener menuListener = (MenuListener)this.listeners.get(i);
                switch (event.type) {
                    case 4096: {
                        menuListener.menuShown(event);
                        continue block5;
                    }
                    case 64: {
                        menuListener.menuHidden(event);
                        continue block5;
                    }
                    case 2: {
                        menuListener.menuSelected(event);
                    }
                }
            }
        }
    }

    public void dispose() {
        this.listeners.clear();
        this.removeAll();
    }
}

