/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.internal.extension.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class ImageCache {
    private static HashMap mImageMap = new HashMap();
    private static List mExternallyCreatedCache = new ArrayList();

    public static Image getImage(String string) {
        Image image = (Image)mImageMap.get(string);
        if (image == null) {
            image = ImageCache.createImage(string);
            mImageMap.put(string, image);
        }
        return image;
    }

    private static Image createImage(String string) {
        ClassLoader classLoader = ImageCache.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null && (inputStream = classLoader.getResourceAsStream(string.substring(1))) == null && (inputStream = classLoader.getResourceAsStream(string)) == null && (inputStream = classLoader.getResourceAsStream(string.substring(1))) == null) {
            return null;
        }
        Image image = new Image((Device)Display.getDefault(), inputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return image;
    }

    public static void dispose() {
        Iterator iterator = mImageMap.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v == null) continue;
            ((Image)v).dispose();
        }
    }

    public static void dispose(Image image) {
        if (image == null) {
            return;
        }
        Iterator iterator = mImageMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() != image) continue;
            mImageMap.remove(entry.getKey());
            if (entry.getValue() != null) {
                ((Image)entry.getValue()).dispose();
            }
            return;
        }
        if (mExternallyCreatedCache.contains(image)) {
            mExternallyCreatedCache.remove(image);
        }
        if (!image.isDisposed()) {
            image.dispose();
        }
    }

    public static void ensureImageIsCached(Image image) {
        Collection collection = mImageMap.values();
        if (collection.contains(image)) {
            return;
        }
        if (!mExternallyCreatedCache.contains(image)) {
            mExternallyCreatedCache.add(image);
        }
    }

    public static Image createImage(ImageData imageData) {
        String string = ImageCache.getMD5Str(imageData);
        if (string == null) {
            return null;
        }
        if (!mImageMap.containsKey(string)) {
            mImageMap.put(string, new Image((Device)Display.getDefault(), imageData));
        }
        return (Image)mImageMap.get(string);
    }

    private static String getMD5Str(ImageData imageData) {
        try {
            MessageDigest messageDigest = null;
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(imageData.data);
            byte[] byArray = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                if (Integer.toHexString(0xFF & byArray[i]).length() == 1) {
                    stringBuffer.append("0").append(Integer.toHexString(0xFF & byArray[i]));
                    continue;
                }
                stringBuffer.append(Integer.toHexString(0xFF & byArray[i]));
            }
            return stringBuffer.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                ImageCache.dispose();
            }
        });
    }
}

