/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.internal.extension.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.sf.feeling.swt.win32.internal.extension.widgets.ISkinable;

class ClientAreaCanvas
extends Canvas {
    private ISkinable drawable;

    public ClientAreaCanvas(Composite composite) {
        super(composite, 0);
        this.setBackgroundMode(1);
        this.createLayoutData();
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ClientAreaCanvas.this.updateSkin(event);
            }
        });
    }

    public ISkinable getDrawable() {
        return this.drawable;
    }

    public void setDrawable(ISkinable iSkinable) {
        GridData gridData = (GridData)this.getLayoutData();
        gridData.widthHint = iSkinable.getInitWidth();
        gridData.heightHint = iSkinable.getInitHeight();
        this.setLayoutData(gridData);
        this.drawable = iSkinable;
    }

    public void setHeight(int n) {
        GridData gridData = (GridData)this.getLayoutData();
        gridData.heightHint = n;
        this.setLayoutData(gridData);
    }

    public void setWidth(int n) {
        GridData gridData = (GridData)this.getLayoutData();
        gridData.widthHint = n;
        this.setLayoutData(gridData);
    }

    private void createLayoutData() {
        GridData gridData = new GridData(4, 4, true, true);
        this.setLayoutData(gridData);
    }

    public void updateSkin(Event event) {
        if (this.drawable != null) {
            Color color = this.drawable.getForeground(event);
            if (color != null && !color.isDisposed()) {
                this.setForeground(color);
            }
            this.drawable.configue(event);
            this.redraw();
        }
    }
}

