/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.page;

import java.io.IOException;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.sf.feeling.sanguo.patch.model.Unit;
import org.sf.feeling.sanguo.patch.page.RestoreListener;
import org.sf.feeling.sanguo.patch.page.SimpleTabPage;
import org.sf.feeling.sanguo.patch.util.BakUtil;
import org.sf.feeling.sanguo.patch.util.ChangeCode;
import org.sf.feeling.sanguo.patch.util.MapUtil;
import org.sf.feeling.sanguo.patch.util.UnitParser;
import org.sf.feeling.sanguo.patch.util.UnitUtil;
import org.sf.feeling.sanguo.patch.widget.WidgetUtil;
import org.sf.feeling.swt.win32.extension.util.SortMap;

public class UnitPatchPage
extends SimpleTabPage {
    private SortMap soldierUnitMap;
    private SortMap factionMap;

    public void buildUI(Composite composite) {
        super.buildUI(composite);
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.leftMargin = 10;
        tableWrapLayout.rightMargin = 10;
        tableWrapLayout.topMargin = 15;
        tableWrapLayout.verticalSpacing = 20;
        this.container.getBody().setLayout(tableWrapLayout);
        this.createTitle();
        this.createPatchArea();
    }

    private void createPatchArea() {
        Section section = WidgetUtil.getToolkit().createSection(this.container.getBody(), 64);
        TableWrapData tableWrapData = new TableWrapData(128);
        section.setLayoutData(tableWrapData);
        section.setText("\u529f\u80fd\u5217\u8868\uff1a");
        WidgetUtil.getToolkit().createCompositeSeparator(section);
        Composite composite = WidgetUtil.getToolkit().createComposite(section);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        composite.setLayout(gridLayout);
        final Button button = WidgetUtil.getToolkit().createButton(composite, "\u52bf\u529b\u5175\u79cd\u6dfb\u52a0", 32);
        final CCombo cCombo = WidgetUtil.getToolkit().createCCombo(composite, 8);
        this.factionMap = UnitUtil.getFactionMap();
        for (int i = 0; i < this.factionMap.getKeyList().size(); ++i) {
            cCombo.add((String)this.factionMap.get(i));
        }
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        cCombo.setLayoutData(gridData);
        cCombo.setEnabled(false);
        final CCombo cCombo2 = WidgetUtil.getToolkit().createCCombo(composite, 8);
        this.soldierUnitMap = UnitUtil.getAllSoldierUnits();
        if (this.soldierUnitMap != null) {
            for (int i = 0; i < this.soldierUnitMap.getKeyList().size(); ++i) {
                cCombo2.add(ChangeCode.toLong((String)this.soldierUnitMap.get(i)));
            }
        }
        gridData = new GridData();
        gridData.widthHint = 150;
        cCombo2.setLayoutData(gridData);
        cCombo2.setEnabled(false);
        final Button button2 = WidgetUtil.getToolkit().createButton(composite, "\u5e94\u7528", 8);
        button2.setEnabled(false);
        Button button3 = WidgetUtil.getToolkit().createButton(composite, "\u8fd8\u539f", 8);
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (cCombo.getSelectionIndex() != -1 && cCombo2.getSelectionIndex() != -1) {
                    button2.setEnabled(false);
                    BakUtil.bakData("\u52bf\u529b\u5175\u79cd\u6dfb\u52a0\uff1a" + cCombo.getText() + "<--" + cCombo2.getText());
                    String string = (String)UnitPatchPage.this.factionMap.getKeyList().get(cCombo.getSelectionIndex());
                    String string2 = (String)UnitPatchPage.this.soldierUnitMap.getKeyList().get(cCombo2.getSelectionIndex());
                    Unit unit = UnitParser.getUnit(string2);
                    try {
                        if (!unit.getFactions().contains(string)) {
                            String string3;
                            UnitUtil.modifyUnitFile(string, unit.getType());
                            UnitUtil.modifyBattleFile(string, unit.getSoldier()[0]);
                            List list = unit.getOfficers();
                            if (list != null && list.size() > 0) {
                                for (int i = 0; i < list.size(); ++i) {
                                    UnitUtil.modifyBattleFile(string, (String)list.get(i));
                                }
                            }
                            if ((string3 = unit.getMount()) != null) {
                                UnitUtil.modifyBattleFile(string, (String)UnitUtil.getMountTypeToModelMap().get((Object)string3));
                            }
                            String[] stringArray = null;
                            if ("missile".equals(unit.getUnitClass()) || "siege".equals(unit.getCategory())) {
                                stringArray = new String[]{"practice_field", "archery_range", "catapult_range", "siege_engineer"};
                            } else if ("infantry".equals(unit.getCategory()) || "handler".equals(unit.getCategory())) {
                                stringArray = new String[]{"muster_field", "militia_barracks", "city_barracks", "army_barracks", "royal_barracks"};
                            } else if ("cavalry".equals(unit.getCategory())) {
                                stringArray = new String[]{"stables", "cavalry_barracks", "hippodrome", "circus_maximus"};
                            } else if ("ship".equals(unit.getCategory())) {
                                stringArray = new String[]{"port", "shipwright", "dockyard"};
                            } else if ("non_combatant".equals(unit.getCategory())) {
                                stringArray = new String[]{"governors_house", "governors_villa", "governors_palace", "proconsuls_palace", "imperial_palace"};
                            }
                            if (stringArray != null) {
                                UnitUtil.addUnitToBuildings(string2, string, stringArray);
                            }
                            UnitUtil.saveBigBingPai(string, (String)unit.getFactions().get(0), unit.getDictionary());
                            UnitUtil.saveSmallBingPai(string, (String)unit.getFactions().get(0), unit.getDictionary());
                            MapUtil.initMap();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    button2.setEnabled(true);
                }
            }
        });
        button3.addSelectionListener(new RestoreListener());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                button2.setEnabled(button.getSelection());
                cCombo.setEnabled(button.getSelection());
                cCombo2.setEnabled(button.getSelection());
            }
        });
        section.setClient(composite);
    }

    private void createTitle() {
        WidgetUtil.createFormText(this.container.getBody(), "\u672c\u9875\u9762\u7528\u4e8e\u6dfb\u52a0\u5175\u79cd\u5230\u6307\u5b9a\u52bf\u529b\uff0c\u914d\u7f6e\u5b8c\u6bd5\u540e\u91cd\u542f\u6e38\u620f\u5373\u53ef\u751f\u6548\u3002");
    }

    public String getDisplayName() {
        return "\u52bf\u529b\u5175\u79cd\u6dfb\u52a0";
    }
}

