/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.util;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.eclipse.swt.graphics.ImageData;
import org.sf.feeling.sanguo.patch.Patch;
import org.sf.feeling.sanguo.patch.model.Unit;
import org.sf.feeling.sanguo.patch.util.ChangeCode;
import org.sf.feeling.sanguo.patch.util.FileConstants;
import org.sf.feeling.sanguo.patch.util.UnitParser;
import org.sf.feeling.sanguo.patch.util.UnitUtil;
import org.sf.feeling.swt.win32.extension.graphics.TgaLoader;

public class CustomGeneralUnit {
    private String name;
    private String displayName;
    private ImageData soldierImage;
    private Unit soldier;
    private String soldierType;
    private String soldierDictionary;
    private String generalFaction;
    private String description = null;

    public String getFaction() {
        return this.generalFaction;
    }

    public void setFaction(String string) {
        this.generalFaction = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDisplayName(String string) {
        this.displayName = ChangeCode.Change(string, true);
    }

    public void setGeneralSoldierImage(ImageData imageData) {
        this.soldierImage = imageData;
    }

    public void setGeneralSoldier(Unit unit) {
        this.soldier = unit;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void createCustomGeneral() {
        this.generalCustomSoldier();
    }

    private void generalCustomSoldier() {
        this.soldierType = "Custom " + this.name;
        this.soldierDictionary = this.soldierType.replaceAll("(\\s+)", "_");
        String string = this.soldier.getSoldier()[0];
        List list = this.soldier.getOfficers();
        try {
            UnitUtil.modifyBattleFile(this.generalFaction, string);
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    UnitUtil.modifyBattleFile(this.generalFaction, (String)list.get(i));
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String string2 = this.soldier.getMount();
        if (string2 != null && (string2 = (String)UnitUtil.getMountTypeToModelMap().get((Object)string2)) != null) {
            try {
                UnitUtil.modifyBattleFile(this.generalFaction, string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (!this.soldier.getAttributes().contains("general_unit")) {
            this.soldier.getAttributes().add("general_unit");
        }
        if (!this.soldier.getAttributes().contains("no_custom")) {
            this.soldier.getAttributes().add("no_custom");
        }
        UnitParser.createSoldier(this.soldier, this.soldierType, this.soldierDictionary, this.generalFaction);
        this.setSoldierDescription(this.soldierDictionary, this.displayName, this.description);
        this.setSoldierImage();
    }

    private void setSoldierImage() {
        String string = Patch.GAME_ROOT + "\\alexander\\data\\ui\\unit_info\\" + this.generalFaction + "\\" + this.soldierDictionary + "_info.tga";
        String string2 = Patch.GAME_ROOT + "\\alexander\\data\\ui\\units\\" + this.generalFaction + "\\#" + this.soldierDictionary + ".tga";
        if (this.soldierImage != null) {
            try {
                TgaLoader.saveImage((OutputStream)new FileOutputStream(string), (ImageData)this.soldierImage.scaledTo(160, 210));
                TgaLoader.saveImage((OutputStream)new FileOutputStream(string2), (ImageData)this.soldierImage.scaledTo(48, 64));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void setSoldierDescription(String string, String string2, String string3) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileConstants.exportUnitFile, true), "UTF-16LE")), false);
            printWriter.println();
            String string4 = string2 + "\u9ebe\u4e0b\u7684\u7cbe\u92b3\u89aa\u5175\u3002";
            String string5 = string2 + "\u9ebe\u4e0b\u7684\u7cbe\u92b3\u89aa\u5175\u3002\\n\\n";
            string5 = string5 + string2 + "\u7684\u90e8\u4e0b\u96a8" + string2 + "\u5f81\u6230\u56db\u65b9\u3002\\n";
            if (string3 != null && string3.length() > 0) {
                string5 = ChangeCode.toShort(string3);
            }
            printWriter.println("{" + string + "}" + string2);
            printWriter.println("{" + string + "_descr}" + string5);
            printWriter.println("{" + string + "_descr_short}" + string4);
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileConstants.unitEnumsFile, true), "GBK")), false);
            printWriter.println();
            printWriter.println(string);
            printWriter.println(string + "_descr");
            printWriter.println(string + "_descr_short");
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

