/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sf.feeling.sanguo.patch.util.FileConstants;
import org.sf.feeling.sanguo.patch.util.FileUtil;
import org.sf.feeling.sanguo.patch.util.PinyinComparator;
import org.sf.feeling.sanguo.patch.util.SoldierMapUtil;
import org.sf.feeling.sanguo.patch.util.UnitUtil;
import org.sf.feeling.swt.win32.extension.util.SortMap;

public class MapUtil {
    static final Properties factionProperty = FileUtil.loadProperties("faction");
    static SortMap unitMap;
    static SortMap generalNameMap;
    static SortMap availabelGeneralNameMap;
    static SortMap generalUnitMap;
    static SortMap availableGeneralUnitMap;
    static SortMap soldierUnitMap;
    static SortMap generalUnitTypeMap;
    static SortMap unitTypeToDictionaryMap;
    static SortMap unitDictionaryToTypeMap;
    static List soldierUnitList;
    static List guyongUnitList;
    static List generalUnitList;
    static SortMap generalOrderMap;
    static SortMap factionMap;
    static SortMap unitFactionMap;
    static SortMap factionGeneralMap;
    static SortMap horseMap;
    static SortMap officerMap;
    static SortMap soldierQiMap;
    static SortMap mountTypeToModelMap;
    static SortMap mountModelToTypeMap;

    public static void initMap() {
        MapUtil.initUnitTypeToDictionaryMap();
        MapUtil.initMountTypeToModelMap();
        unitMap = MapUtil.initUnitMap();
        generalOrderMap = MapUtil.initGeneralOrderMap();
        generalNameMap = MapUtil.initGeneralNameMap();
        factionMap = MapUtil.initFactionMap();
        availabelGeneralNameMap = MapUtil.initAvailableGeneralNameMap();
        MapUtil.initGeneralUnitMaps();
        MapUtil.initAvailableOfficerAndHorses();
        SoldierMapUtil.initMap();
    }

    private static SortMap initUnitMap() {
        SortMap sortMap = new SortMap();
        List list = unitTypeToDictionaryMap.getKeyList();
        if (FileConstants.exportUnitFile.exists()) {
            try {
                String string = null;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.exportUnitFile), "UTF-16LE"));
                while ((string = bufferedReader.readLine()) != null) {
                    String string2;
                    Pattern pattern = Pattern.compile("^\\s*(\\{\\s*)(.+)(\\s*\\})(\\s*)");
                    Matcher matcher = pattern.matcher(string);
                    if (!matcher.find() || !list.contains(unitDictionaryToTypeMap.get((Object)(string2 = matcher.group().replaceAll("(\\{)", "").replaceAll("(\\})", "").trim())))) continue;
                    sortMap.put(unitDictionaryToTypeMap.get((Object)string2), (Object)string.substring(matcher.end()).split(";")[0].trim());
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return sortMap;
    }

    private static void initUnitTypeToDictionaryMap() {
        unitTypeToDictionaryMap = new SortMap();
        unitDictionaryToTypeMap = new SortMap();
        unitFactionMap = new SortMap();
        soldierUnitList = new ArrayList();
        guyongUnitList = new ArrayList();
        generalUnitList = new ArrayList();
        String[] stringArray = new String[]{"infantry", "cavalry", "siege", "handler"};
        List<String> list = Arrays.asList(stringArray);
        if (FileConstants.unitFile.exists()) {
            try {
                String string = null;
                FileUtil.checkAndSaveFile(FileConstants.unitFile);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.unitFile), "GBK"));
                boolean bl = false;
                String string2 = null;
                String string3 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray2;
                    Matcher matcher;
                    Pattern pattern;
                    if (string.split(";").length == 0) continue;
                    if (!bl) {
                        pattern = Pattern.compile("^\\s*(type)(\\s+)");
                        matcher = pattern.matcher(string);
                        if (!matcher.find()) continue;
                        string2 = string.split(";")[0].replaceAll("type", "").trim();
                        bl = true;
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(dictionary)(\\s+)");
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        string3 = string.split(";")[0].replaceAll("dictionary", "").trim();
                        unitTypeToDictionaryMap.put((Object)string2, (Object)string3);
                        unitDictionaryToTypeMap.put((Object)string3, (Object)string2);
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(category)(\\s+)");
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        stringArray2 = string.split(";")[0].replaceAll("category", "").trim();
                        if (list.contains(stringArray2)) continue;
                        string3 = null;
                        string2 = null;
                        bl = false;
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(ownership)(\\s+)");
                    matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        stringArray2 = string.split(";")[0].replaceAll("ownership", "").trim().split(",");
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (int i = 0; i < stringArray2.length; ++i) {
                            arrayList.add(stringArray2[i].trim().toUpperCase());
                        }
                        unitFactionMap.put((Object)string3, arrayList);
                        string3 = null;
                        string2 = null;
                        bl = false;
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(attributes)(\\s+)");
                    matcher = pattern.matcher(string);
                    if (!matcher.find()) continue;
                    if (string.indexOf("general_unit") == -1) {
                        soldierUnitList.add(string2);
                        if (string.indexOf("mercenary_unit") <= -1) continue;
                        guyongUnitList.add(string2);
                        continue;
                    }
                    generalUnitList.add(string2);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static SortMap initGeneralNameMap() {
        List list = generalOrderMap.getValueList();
        SortMap sortMap = new SortMap();
        if (FileConstants.nameFile.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.nameFile), "UTF-16LE"));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    String string2;
                    Pattern pattern = Pattern.compile("^\\s*(\\{\\s*)(.+)(\\s*\\})(\\s*)");
                    Matcher matcher = pattern.matcher(string);
                    if (!matcher.find() || !list.contains(string2 = matcher.group().replaceAll("(\\{)", "").replaceAll("(\\})", "").trim())) continue;
                    sortMap.put((Object)string2, (Object)string.substring(matcher.end()).split(";")[0]);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return sortMap;
    }

    private static SortMap initGeneralOrderMap() {
        Object object;
        Object object2;
        factionGeneralMap = new SortMap();
        generalUnitTypeMap = new SortMap();
        if (FileConstants.stratFile.exists()) {
            try {
                object2 = null;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.stratFile), "GBK"));
                String string = null;
                object = null;
                while ((object2 = bufferedReader.readLine()) != null) {
                    Pattern pattern;
                    Matcher matcher;
                    Matcher matcher2;
                    Pattern pattern2;
                    if (string == null) {
                        pattern2 = Pattern.compile("^\\s*(faction)(\\s+)(\\S+)(\\s*)(,)");
                        matcher2 = pattern2.matcher((CharSequence)object2);
                        if (!matcher2.find()) continue;
                        string = matcher2.group().replaceAll("faction", "").replaceAll(",", "").trim().toUpperCase();
                        factionGeneralMap.put((Object)string, new ArrayList());
                        continue;
                    }
                    pattern2 = Pattern.compile("^\\s*(relative)(\\s+)(\\S+)(\\s*)(,)");
                    matcher2 = pattern2.matcher((CharSequence)object2);
                    if (matcher2.find()) {
                        string = null;
                        continue;
                    }
                    Pattern pattern3 = Pattern.compile("^\\s*(character)(.+)(named)(\\s+)(character)");
                    Matcher matcher3 = pattern3.matcher((CharSequence)object2);
                    if (matcher3.find() && (matcher = (pattern = Pattern.compile("(named)(\\s+)(character)(\\s*)(,)")).matcher((CharSequence)object2)).find()) {
                        String[] stringArray = matcher3.group().split(",");
                        object = stringArray[stringArray.length - 2].replaceAll("character", "").trim();
                        ((List)factionGeneralMap.get((Object)string)).add(object);
                        continue;
                    }
                    if (object == null || !(matcher2 = (pattern2 = Pattern.compile("^\\s*(unit)(.+)(exp)")).matcher((CharSequence)object2)).find()) continue;
                    generalUnitTypeMap.put(object, (Object)matcher2.group().replaceAll("unit", "").replaceAll("exp", "").trim());
                    object = null;
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        object2 = new SortMap();
        int n = 0;
        for (int i = 0; i < factionGeneralMap.getValueList().size(); ++i) {
            object = (List)factionGeneralMap.getValueList().get(i);
            if (object == null) continue;
            for (int j = 0; j < object.size(); ++j) {
                object2.put((Object)Integer.valueOf("" + ++n), object.get(j));
            }
        }
        return object2;
    }

    private static SortMap initAvailableGeneralNameMap() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(generalNameMap.getKeyList());
        UnitUtil.getAvailableGeneralCodes(arrayList);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)generalNameMap.get(object);
                String string2 = (String)generalNameMap.get(object2);
                return PinyinComparator.compare(string, string2);
            }
        });
        SortMap sortMap = new SortMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            String string = (String)generalNameMap.get(e);
            if (sortMap.containsValue((Object)string)) {
                for (int j = 0; j < sortMap.getKeyList().size(); ++j) {
                    String string2 = (String)sortMap.getKeyList().get(j);
                    if (!sortMap.get(j).equals(string)) continue;
                    String string3 = UnitUtil.getGeneralFaction(string2);
                    sortMap.put((Object)string2, (Object)(string + "\uff08" + factionMap.get((Object)string3.toUpperCase()) + "\uff09"));
                }
                String string4 = UnitUtil.getGeneralFaction((String)e);
                sortMap.put(e, (Object)(string + "\uff08" + factionMap.get((Object)string4.toUpperCase()) + "\uff09"));
                continue;
            }
            sortMap.put(e, generalNameMap.get(e));
        }
        return sortMap;
    }

    private static SortMap initFactionMap() {
        final SortMap sortMap = new SortMap();
        Iterator<Object> iterator = factionProperty.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            sortMap.put(factionProperty.get(object), object);
        }
        Collections.sort(sortMap.getKeyList(), new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)sortMap.get(object);
                String string2 = (String)sortMap.get(object2);
                return PinyinComparator.compare(string, string2);
            }
        });
        return sortMap;
    }

    private static void initGeneralUnitMaps() {
        String string;
        int n;
        generalUnitMap = new SortMap();
        soldierUnitMap = new SortMap();
        availableGeneralUnitMap = new SortMap();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = generalNameMap.getValueList();
        for (n = 0; n < unitMap.size(); ++n) {
            string = (String)unitMap.getKeyList().get(n);
            if (list.contains(unitMap.get((Object)string))) {
                availableGeneralUnitMap.put((Object)string, unitMap.get((Object)string));
            }
            if (generalUnitList.contains(string)) {
                generalUnitMap.put((Object)string, unitMap.get((Object)string));
                continue;
            }
            if (!soldierUnitList.contains(string)) continue;
            if (soldierUnitMap.getValueList().contains(unitMap.get((Object)string))) {
                arrayList.add(unitMap.get((Object)string));
            }
            soldierUnitMap.put((Object)string, unitMap.get((Object)string));
        }
        Collections.sort(generalUnitMap.getKeyList(), new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)generalUnitMap.get(object);
                String string2 = (String)generalUnitMap.get(object2);
                return PinyinComparator.compare(string, string2);
            }
        });
        Collections.sort(availableGeneralUnitMap.getKeyList(), new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)generalUnitMap.get(object);
                String string2 = (String)generalUnitMap.get(object2);
                return PinyinComparator.compare(string, string2);
            }
        });
        for (n = 0; n < arrayList.size(); ++n) {
            string = (String)arrayList.get(n);
            for (int i = 0; i < soldierUnitMap.size(); ++i) {
                if (!soldierUnitMap.get(i).equals(string)) continue;
                String string2 = (String)soldierUnitMap.getKeyList().get(i);
                if (guyongUnitList.contains(string2)) {
                    soldierUnitMap.put((Object)string2, (Object)(string + "\uff08\u96c7\u4f63\u5175\uff09"));
                    continue;
                }
                List list2 = (List)unitFactionMap.get(unitTypeToDictionaryMap.get((Object)string2));
                String string3 = (String)factionMap.get(list2.get(0));
                soldierUnitMap.put((Object)string2, (Object)(string + "\uff08" + string3 + "\uff09"));
            }
        }
        Collections.sort(soldierUnitMap.getKeyList(), new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)soldierUnitMap.get(object);
                String string2 = (String)soldierUnitMap.get(object2);
                return PinyinComparator.compare(string, string2);
            }
        });
    }

    public static void initAvailableOfficerAndHorses() {
        int n;
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (FileConstants.battleFile.exists()) {
            try {
                object2 = null;
                object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.battleFile), "GBK"));
                String string = null;
                while ((object2 = ((BufferedReader)object).readLine()) != null) {
                    Pattern pattern = Pattern.compile("^\\s*(type)(\\s+)");
                    Matcher matcher = pattern.matcher((CharSequence)object2);
                    if (!matcher.find()) continue;
                    string = ((String)object2).split(";")[0].replaceAll("type", "").trim();
                    arrayList.add(string);
                }
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        officerMap = new SortMap();
        object2 = FileUtil.loadProperties("officer");
        object = ((Properties)object2).keySet().toArray(new String[0]);
        for (n = 0; n < ((Object)object).length; ++n) {
            if (!arrayList.contains(object[n])) continue;
            officerMap.put(object[n], (Object)((Properties)object2).getProperty((String)object[n]));
        }
        Collections.sort(officerMap.getKeyList(), new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)officerMap.get(object);
                String string2 = (String)officerMap.get(object2);
                return PinyinComparator.compare(string, string2);
            }
        });
        horseMap = new SortMap();
        object2 = FileUtil.loadProperties("horse");
        object = ((Properties)object2).keySet().toArray(new String[0]);
        for (n = 0; n < ((Object)object).length; ++n) {
            if (!arrayList.contains(object[n])) continue;
            horseMap.put(object[n], (Object)((Properties)object2).getProperty((String)object[n]));
        }
        Collections.sort(horseMap.getKeyList(), new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)horseMap.get(object);
                String string2 = (String)horseMap.get(object2);
                return PinyinComparator.compare(string, string2);
            }
        });
        soldierQiMap = new SortMap();
        object2 = FileUtil.loadProperties("soldier_qi");
        object = ((Properties)object2).keySet().toArray(new String[0]);
        for (n = 0; n < ((Object)object).length; ++n) {
            if (!arrayList.contains(object[n])) continue;
            soldierQiMap.put(object[n], (Object)((Properties)object2).getProperty((String)object[n]));
        }
        Collections.sort(soldierQiMap.getKeyList(), new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)soldierQiMap.get(object);
                String string2 = (String)soldierQiMap.get(object2);
                return PinyinComparator.compare(string, string2);
            }
        });
    }

    private static void initMountTypeToModelMap() {
        mountTypeToModelMap = new SortMap();
        mountModelToTypeMap = new SortMap();
        if (FileConstants.desc_MountFile.exists()) {
            try {
                String string = null;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileConstants.desc_MountFile), "GBK"));
                boolean bl = false;
                String string2 = null;
                String string3 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    Matcher matcher;
                    Pattern pattern;
                    if (string.split(";").length == 0) continue;
                    if (!bl) {
                        pattern = Pattern.compile("^\\s*(type)(\\s+)");
                        matcher = pattern.matcher(string);
                        if (!matcher.find()) continue;
                        string2 = string.split(";")[0].replaceAll("type", "").trim();
                        bl = true;
                        continue;
                    }
                    pattern = Pattern.compile("^\\s*(model)(\\s+)");
                    matcher = pattern.matcher(string);
                    if (!matcher.find()) continue;
                    string3 = string.split(";")[0].replaceAll("model", "").trim();
                    mountTypeToModelMap.put((Object)string2, (Object)string3);
                    mountModelToTypeMap.put((Object)string3, (Object)string2);
                    bl = false;
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

