/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.widget;

import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ImageCanvas
extends Canvas {
    private Image sourceImage;
    private Image screenImage;

    public ImageCanvas(Composite composite) {
        this(composite, 0);
        this.initAccessible();
    }

    public ImageCanvas(Composite composite, int n) {
        super(composite, n);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                ImageCanvas.this.paint(paintEvent.gc);
            }
        });
        this.initAccessible();
    }

    void initAccessible() {
        this.getAccessible().addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = ImageCanvas.this.toControl(accessibleControlEvent.x, accessibleControlEvent.y);
                if (ImageCanvas.this.getBounds().contains(point)) {
                    accessibleControlEvent.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = ImageCanvas.this.getBounds();
                Point point = ImageCanvas.this.toDisplay(rectangle.x, rectangle.y);
                accessibleControlEvent.x = point.x;
                accessibleControlEvent.y = point.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 41;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getValue(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = "Preview Image";
            }
        });
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = "Preview Image";
            }

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = "Preview Image";
            }
        };
        this.getAccessible().addAccessibleListener(accessibleAdapter);
    }

    public void dispose() {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
        }
        if (this.screenImage != null && !this.screenImage.isDisposed()) {
            this.screenImage.dispose();
        }
    }

    private void paint(GC gC) {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            if ((float)this.getSize().x / (float)this.getSize().y >= (float)this.sourceImage.getImageData().width / (float)this.sourceImage.getImageData().height) {
                int n = (int)((float)this.getSize().y * ((float)this.sourceImage.getImageData().width / (float)this.sourceImage.getImageData().height));
                if (n > this.sourceImage.getImageData().width) {
                    n = this.sourceImage.getImageData().width;
                }
                int n2 = (int)((float)n * ((float)this.sourceImage.getImageData().height / (float)this.sourceImage.getImageData().width));
                gC.drawImage(this.sourceImage, 0, 0, this.sourceImage.getImageData().width, this.sourceImage.getImageData().height, (this.getSize().x - n) / 2 - 1, (this.getSize().y - n2) / 2 - 1, n, n2);
            } else {
                int n = (int)((float)this.getSize().x * ((float)this.sourceImage.getImageData().height / (float)this.sourceImage.getImageData().width));
                if (n > this.sourceImage.getImageData().height) {
                    n = this.sourceImage.getImageData().height;
                }
                int n3 = (int)((float)n * ((float)this.sourceImage.getImageData().width / (float)this.sourceImage.getImageData().height));
                gC.drawImage(this.sourceImage, 0, 0, this.sourceImage.getImageData().width, this.sourceImage.getImageData().height, (this.getSize().x - n3) / 2 - 1, (this.getSize().y - n) / 2 - 1, n3, n);
            }
        }
    }

    public Image getSourceImage() {
        return this.sourceImage;
    }

    public void setImageData(ImageData imageData) {
        if (this.sourceImage != null) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        if (imageData != null) {
            this.sourceImage = new Image((Device)this.getDisplay(), imageData);
        }
        this.redraw();
    }

    public void clear() {
        if (this.sourceImage != null) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        GC gC = new GC(this);
        this.paint(gC);
        gC.dispose();
    }
}

