/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.widget;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.sf.feeling.sanguo.patch.widget.FormWidgetFactory;
import org.sf.feeling.sanguo.patch.widget.Tab;

public class TabbedPropertyList
extends Canvas {
    private static final ListElement[] ELEMENTS_EMPTY = new ListElement[0];
    protected static final int NONE = -1;
    protected static final int INDENT = 7;
    private boolean focus = false;
    private ListElement[] elements;
    private int selectedElementIndex = -1;
    private int topVisibleIndex = -1;
    private int bottomVisibleIndex = -1;
    private TopNavigationElement topNavigationElement;
    private BottomNavigationElement bottomNavigationElement;
    private int widestLabelIndex = -1;
    private int tabsThatFitInComposite = -1;
    private Color widgetForeground;
    private Color widgetBackground;
    private Color widgetNormalShadow;
    private Color widgetDarkShadow;
    private Color listBackground;
    private Color hoverGradientStart;
    private Color hoverGradientEnd;
    private Color defaultGradientStart;
    private Color defaultGradientEnd;
    private Color indentedDefaultBackground;
    private Color indentedHoverBackground;
    private Color navigationElementShadowStroke;
    private Color bottomNavigationElementShadowStroke1;
    private Color bottomNavigationElementShadowStroke2;
    private GC textGc;
    private FormToolkit factory = FormWidgetFactory.getInstance();
    private Tab[] elementMap = null;

    public TabbedPropertyList(Composite composite) {
        super(composite, 0);
        this.removeAll();
        this.setLayout(new FormLayout());
        this.initColours();
        this.initAccessible();
        this.topNavigationElement = new TopNavigationElement(this);
        this.bottomNavigationElement = new BottomNavigationElement(this);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                TabbedPropertyList.this.focus = true;
                int n = TabbedPropertyList.this.getSelectionIndex();
                if (n >= 0) {
                    TabbedPropertyList.this.elements[n].redraw();
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                TabbedPropertyList.this.focus = false;
                int n = TabbedPropertyList.this.getSelectionIndex();
                if (n >= 0) {
                    TabbedPropertyList.this.elements[n].redraw();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){});
        this.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                TabbedPropertyList.this.topNavigationElement.redraw();
                TabbedPropertyList.this.bottomNavigationElement.redraw();
                TabbedPropertyList.this.computeTopAndBottomTab();
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 32 || traverseEvent.detail == 64) {
                    int n = TabbedPropertyList.this.elements.length - 1;
                    int n2 = TabbedPropertyList.this.getSelectionIndex();
                    if (traverseEvent.detail == 32) {
                        --n2;
                        n2 = Math.max(0, n2);
                    } else if (traverseEvent.detail == 64) {
                        ++n2;
                        n2 = Math.min(n2, n);
                    }
                    TabbedPropertyList.this.select(n2, true);
                    TabbedPropertyList.this.redraw();
                } else {
                    traverseEvent.doit = true;
                }
            }
        });
    }

    protected void computeTabsThatFitInComposite() {
        this.tabsThatFitInComposite = Math.round((this.getSize().y - 22) / this.getTabHeight());
        if (this.tabsThatFitInComposite <= 0) {
            this.tabsThatFitInComposite = 1;
        }
    }

    public Object getElementAt(int n) {
        if (n >= 0 && n < this.elements.length) {
            return this.elements[n];
        }
        return null;
    }

    public int getSelectionIndex() {
        return this.selectedElementIndex;
    }

    public void removeAll() {
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i].dispose();
            }
        }
        this.elements = ELEMENTS_EMPTY;
        this.selectedElementIndex = -1;
        this.widestLabelIndex = -1;
        this.topVisibleIndex = -1;
        this.bottomVisibleIndex = -1;
    }

    public void setElements(Tab[] tabArray) {
        this.elementMap = tabArray;
        if (this.elements != ELEMENTS_EMPTY) {
            this.removeAll();
        }
        this.elements = new ListElement[this.elementMap.length];
        if (this.elementMap.length == 0) {
            this.widestLabelIndex = -1;
        } else {
            this.widestLabelIndex = 0;
            for (int i = 0; i < this.elementMap.length; ++i) {
                this.elements[i] = new ListElement(this, this.elementMap[i], i);
                this.elements[i].setVisible(false);
                this.elements[i].setLayoutData(null);
                if (i == this.widestLabelIndex) continue;
                String string = this.elementMap[i].getText();
                if (this.getTextDimension((String)string).x <= this.getTextDimension((String)this.elementMap[this.widestLabelIndex].getText()).x) continue;
                this.widestLabelIndex = i;
            }
        }
        this.computeTopAndBottomTab();
    }

    public void select(int n, boolean bl) {
        if (this.getSelectionIndex() == n) {
            return;
        }
        if (n >= 0 && n < this.elements.length) {
            int n2 = this.getSelectionIndex();
            this.elements[n].setSelected(true);
            this.selectedElementIndex = n;
            if (n2 != -1) {
                this.elements[n2].setSelected(false);
                if (this.getSelectionIndex() != this.elements.length - 1) {
                    this.elements[this.getSelectionIndex() + 1].setSelected(false);
                }
            }
            this.topNavigationElement.redraw();
            this.bottomNavigationElement.redraw();
            if (this.selectedElementIndex < this.topVisibleIndex || this.selectedElementIndex > this.bottomVisibleIndex) {
                this.computeTopAndBottomTab();
            }
        }
        this.notifyListeners(13, new Event());
    }

    public void deselectAll() {
        if (this.getSelectionIndex() != -1) {
            this.elements[this.getSelectionIndex()].setSelected(false);
            this.selectedElementIndex = -1;
        }
    }

    private int getIndex(ListElement listElement) {
        return listElement.index;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point = super.computeSize(n2, n, bl);
        if (this.widestLabelIndex == -1) {
            String string = "TabbedPropertyList properties are not available";
            point.x = this.getTextDimension((String)string).x + 7;
        } else {
            int n3 = this.getTextDimension((String)this.elements[this.widestLabelIndex].getText()).x;
            point.x = n3 + 32;
            point.x = point.x >= 125 ? point.x : 125;
        }
        return point;
    }

    private Point getTextDimension(String string) {
        if (this.textGc == null || this.textGc.isDisposed()) {
            this.textGc = new GC(this);
        }
        this.textGc.setFont(this.getFont());
        Point point = this.textGc.textExtent(string);
        ++point.x;
        return point;
    }

    private void initColours() {
        this.listBackground = Display.getCurrent().getSystemColor(25);
        this.widgetBackground = Display.getCurrent().getSystemColor(22);
        this.widgetDarkShadow = Display.getCurrent().getSystemColor(17);
        this.widgetForeground = Display.getCurrent().getSystemColor(21);
        this.widgetNormalShadow = Display.getCurrent().getSystemColor(18);
        RGB rGB = Display.getCurrent().getSystemColor(29).getRGB();
        RGB rGB2 = Display.getCurrent().getSystemColor(1).getRGB();
        RGB rGB3 = Display.getCurrent().getSystemColor(2).getRGB();
        this.defaultGradientStart = this.factory.getColors().createColor("TabbedPropertyList.defaultTabGradientStart", FormColors.blend(rGB, FormColors.blend(rGB2, this.widgetNormalShadow.getRGB(), 20), 60));
        this.defaultGradientEnd = this.factory.getColors().createColor("TabbedPropertyList.defaultTabGradientEnd", FormColors.blend(rGB, this.widgetNormalShadow.getRGB(), 40));
        this.navigationElementShadowStroke = this.factory.getColors().createColor("TabbedPropertyList.shadowStroke", FormColors.blend(rGB2, this.widgetNormalShadow.getRGB(), 55));
        this.bottomNavigationElementShadowStroke1 = this.factory.getColors().createColor("TabbedPropertyList.tabShadowStroke1", FormColors.blend(rGB3, this.widgetBackground.getRGB(), 10));
        this.bottomNavigationElementShadowStroke2 = this.factory.getColors().createColor("TabbedPropertyList.tabShadowStroke2", FormColors.blend(rGB3, this.widgetBackground.getRGB(), 5));
        this.hoverGradientStart = this.factory.getColors().createColor("TabbedPropertyList.hoverBackgroundGradientStart", FormColors.blend(rGB2, this.widgetBackground.getRGB(), 20));
        this.hoverGradientEnd = this.factory.getColors().createColor("TabbedPropertyList.hoverBackgroundGradientEnd", FormColors.blend(this.widgetNormalShadow.getRGB(), this.widgetBackground.getRGB(), 10));
        this.indentedDefaultBackground = this.factory.getColors().createColor("TabbedPropertyList.indentedDefaultBackground", FormColors.blend(rGB2, this.widgetBackground.getRGB(), 10));
        this.indentedHoverBackground = this.factory.getColors().createColor("TabbedPropertyList.indentedHoverBackground", FormColors.blend(rGB2, this.widgetBackground.getRGB(), 75));
    }

    public void dispose() {
        if (this.textGc != null && !this.textGc.isDisposed()) {
            this.textGc.dispose();
            this.textGc = null;
        }
        super.dispose();
    }

    private int getTabHeight() {
        int n = this.getTextDimension((String)"").y + 7;
        if (this.tabsThatFitInComposite == 1) {
            int n2 = this.getBounds().height - 20;
            return n2 > n ? n : (n2 < 5 ? 5 : n2);
        }
        return n;
    }

    private boolean isDownScrollRequired() {
        return this.elements.length > this.tabsThatFitInComposite && this.bottomVisibleIndex != this.elements.length - 1;
    }

    private boolean isUpScrollRequired() {
        return this.elements.length > this.tabsThatFitInComposite && this.topVisibleIndex != 0;
    }

    private void computeTopAndBottomTab() {
        this.computeTabsThatFitInComposite();
        if (this.elements.length == 0) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = 0;
        } else if (this.tabsThatFitInComposite >= this.elements.length) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = this.elements.length - 1;
        } else if (this.getSelectionIndex() == -1) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = this.tabsThatFitInComposite - 1;
        } else if (this.getSelectionIndex() + this.tabsThatFitInComposite > this.elements.length) {
            this.bottomVisibleIndex = this.elements.length - 1;
            this.topVisibleIndex = this.bottomVisibleIndex - this.tabsThatFitInComposite + 1;
        } else {
            this.topVisibleIndex = this.selectedElementIndex;
            this.bottomVisibleIndex = this.selectedElementIndex + this.tabsThatFitInComposite - 1;
        }
        this.layoutTabs();
    }

    private void layoutTabs() {
        Object object;
        if (this.tabsThatFitInComposite == -1 || this.elements.length == 0) {
            object = new FormData();
            ((FormData)object).left = new FormAttachment(0, 0);
            ((FormData)object).right = new FormAttachment(100, 0);
            ((FormData)object).top = new FormAttachment(0, 0);
            ((FormData)object).height = this.getTabHeight();
            this.topNavigationElement.setLayoutData(object);
            object = new FormData();
            ((FormData)object).left = new FormAttachment(0, 0);
            ((FormData)object).right = new FormAttachment(100, 0);
            ((FormData)object).top = new FormAttachment(this.topNavigationElement, 0);
            ((FormData)object).bottom = new FormAttachment(100, 0);
            this.bottomNavigationElement.setLayoutData(object);
        } else {
            object = new FormData();
            ((FormData)object).left = new FormAttachment(0, 0);
            ((FormData)object).right = new FormAttachment(100, 0);
            ((FormData)object).top = new FormAttachment(0, 0);
            ((FormData)object).height = 10;
            this.topNavigationElement.setLayoutData(object);
            Canvas canvas = this.topNavigationElement;
            for (int i = 0; i < this.elements.length; ++i) {
                if (i < this.topVisibleIndex || i > this.bottomVisibleIndex) {
                    this.elements[i].setLayoutData(null);
                    this.elements[i].setVisible(false);
                    continue;
                }
                object = new FormData();
                ((FormData)object).height = this.getTabHeight();
                ((FormData)object).left = new FormAttachment(0, 0);
                ((FormData)object).right = new FormAttachment(100, 0);
                ((FormData)object).top = new FormAttachment(canvas, 0);
                canvas = this.elements[i];
                this.elements[i].setLayoutData(object);
                this.elements[i].setVisible(true);
            }
            object = new FormData();
            ((FormData)object).left = new FormAttachment(0, 0);
            ((FormData)object).right = new FormAttachment(100, 0);
            ((FormData)object).top = new FormAttachment(canvas, 0);
            ((FormData)object).bottom = new FormAttachment(100, 0);
            ((FormData)object).height = 10;
            this.bottomNavigationElement.setLayoutData(object);
        }
        object = this.getParent().getParent();
        ((Composite)object).layout(true);
        this.layout(true);
    }

    private void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                if (TabbedPropertyList.this.getSelectionIndex() != -1) {
                    accessibleEvent.result = TabbedPropertyList.this.elements[TabbedPropertyList.this.getSelectionIndex()].getText();
                }
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                if (TabbedPropertyList.this.getSelectionIndex() != -1) {
                    accessibleEvent.result = TabbedPropertyList.this.elements[TabbedPropertyList.this.getSelectionIndex()].getText();
                }
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = TabbedPropertyList.this.toControl(new Point(accessibleControlEvent.x, accessibleControlEvent.y));
                accessibleControlEvent.childID = TabbedPropertyList.this.getBounds().contains(point) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                if (TabbedPropertyList.this.getSelectionIndex() != -1) {
                    Rectangle rectangle = TabbedPropertyList.this.elements[TabbedPropertyList.this.getSelectionIndex()].getBounds();
                    Point point = TabbedPropertyList.this.toDisplay(new Point(rectangle.x, rectangle.y));
                    accessibleControlEvent.x = point.x;
                    accessibleControlEvent.y = point.y;
                    accessibleControlEvent.width = rectangle.width;
                    accessibleControlEvent.height = rectangle.height;
                }
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 37;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0x300006;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TabbedPropertyList.this.isFocusControl()) {
                    accessible.setFocus(-1);
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                accessible.setFocus(-1);
            }
        });
    }

    public void setSelection(int n) {
        if (this.getSelectionIndex() == n) {
            return;
        }
        if (n >= 0 && n < this.elements.length) {
            int n2 = this.getSelectionIndex();
            this.elements[n].setSelected(true);
            this.selectedElementIndex = n;
            if (n2 != -1) {
                this.elements[n2].setSelected(false);
                if (this.getSelectionIndex() != this.elements.length - 1) {
                    this.elements[this.getSelectionIndex() + 1].setSelected(false);
                }
            }
            this.topNavigationElement.redraw();
            this.bottomNavigationElement.redraw();
            if (this.selectedElementIndex < this.topVisibleIndex || this.selectedElementIndex > this.bottomVisibleIndex) {
                this.computeTopAndBottomTab();
            }
        }
    }

    static /* synthetic */ int access$300(TabbedPropertyList tabbedPropertyList, ListElement listElement) {
        return tabbedPropertyList.getIndex(listElement);
    }

    static /* synthetic */ int access$1810(TabbedPropertyList tabbedPropertyList) {
        return tabbedPropertyList.bottomVisibleIndex--;
    }

    static /* synthetic */ int access$1900(TabbedPropertyList tabbedPropertyList) {
        return tabbedPropertyList.topVisibleIndex;
    }

    static /* synthetic */ int access$1910(TabbedPropertyList tabbedPropertyList) {
        return tabbedPropertyList.topVisibleIndex--;
    }

    static /* synthetic */ void access$2000(TabbedPropertyList tabbedPropertyList) {
        tabbedPropertyList.layoutTabs();
    }

    static /* synthetic */ int access$1908(TabbedPropertyList tabbedPropertyList) {
        return tabbedPropertyList.topVisibleIndex++;
    }

    static /* synthetic */ int access$1800(TabbedPropertyList tabbedPropertyList) {
        return tabbedPropertyList.bottomVisibleIndex;
    }

    static /* synthetic */ int access$1808(TabbedPropertyList tabbedPropertyList) {
        return tabbedPropertyList.bottomVisibleIndex++;
    }

    public class BottomNavigationElement
    extends Canvas {
        public BottomNavigationElement(Composite composite) {
            super(composite, 524288);
            this.addPaintListener(new PaintListener(this){
                private final /* synthetic */ BottomNavigationElement this$1;
                {
                    this.this$1 = bottomNavigationElement;
                }

                public void paintControl(PaintEvent paintEvent) {
                    BottomNavigationElement.access$2700(this.this$1, paintEvent);
                }
            });
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ BottomNavigationElement this$1;
                {
                    this.this$1 = bottomNavigationElement;
                }

                public void mouseUp(MouseEvent mouseEvent) {
                    if (TabbedPropertyList.access$2900(BottomNavigationElement.access$2800(this.this$1))) {
                        TabbedPropertyList.access$1908(BottomNavigationElement.access$2800(this.this$1));
                        if (TabbedPropertyList.access$1800(BottomNavigationElement.access$2800(this.this$1)) != TabbedPropertyList.access$2400(BottomNavigationElement.access$2800(this.this$1)).length - 1) {
                            TabbedPropertyList.access$1808(BottomNavigationElement.access$2800(this.this$1));
                        }
                        TabbedPropertyList.access$2000(BottomNavigationElement.access$2800(this.this$1));
                        TabbedPropertyList.access$2100(BottomNavigationElement.access$2800(this.this$1)).redraw();
                        TabbedPropertyList.access$2200(BottomNavigationElement.access$2800(this.this$1)).redraw();
                    }
                }
            });
        }

        private void paint(PaintEvent paintEvent) {
            paintEvent.gc.setBackground(TabbedPropertyList.this.widgetBackground);
            paintEvent.gc.setForeground(TabbedPropertyList.this.widgetForeground);
            Rectangle rectangle = this.getBounds();
            if (TabbedPropertyList.this.elements.length != 0) {
                paintEvent.gc.fillRectangle(0, 0, rectangle.width, rectangle.height);
                paintEvent.gc.setForeground(TabbedPropertyList.this.widgetNormalShadow);
                paintEvent.gc.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
                paintEvent.gc.drawLine(0, 0, rectangle.width - 1, 0);
                paintEvent.gc.setForeground(TabbedPropertyList.this.bottomNavigationElementShadowStroke1);
                paintEvent.gc.drawLine(0, 1, rectangle.width - 2, 1);
                paintEvent.gc.setForeground(TabbedPropertyList.this.bottomNavigationElementShadowStroke2);
                paintEvent.gc.drawLine(0, 2, rectangle.width - 2, 2);
            } else {
                paintEvent.gc.setBackground(TabbedPropertyList.this.listBackground);
                paintEvent.gc.fillRectangle(0, 0, rectangle.width, rectangle.height);
            }
            if (TabbedPropertyList.this.isDownScrollRequired()) {
                paintEvent.gc.setForeground(TabbedPropertyList.this.widgetDarkShadow);
                int n = rectangle.width / 2;
                int n2 = rectangle.height - 3;
                paintEvent.gc.drawLine(n + 1, n2, n + 5, n2 - 4);
                paintEvent.gc.drawLine(n, n2, n - 4, n2 - 4);
                paintEvent.gc.drawLine(n - 3, n2 - 4, n + 4, n2 - 4);
                paintEvent.gc.setForeground(TabbedPropertyList.this.listBackground);
                paintEvent.gc.drawLine(n, n2 - 1, n + 1, n2 - 1);
                paintEvent.gc.drawLine(n - 1, n2 - 2, n + 2, n2 - 2);
                paintEvent.gc.drawLine(n - 2, n2 - 3, n + 3, n2 - 3);
                paintEvent.gc.setForeground(TabbedPropertyList.this.widgetNormalShadow);
                paintEvent.gc.drawLine(0, n2 - 7, rectangle.width - 2, n2 - 7);
                paintEvent.gc.setForeground(TabbedPropertyList.this.navigationElementShadowStroke);
                paintEvent.gc.drawLine(0, n2 + 2, rectangle.width - 2, n2 + 2);
                paintEvent.gc.drawLine(0, n2 - 6, rectangle.width - 2, n2 - 6);
            }
        }

        static /* synthetic */ void access$2700(BottomNavigationElement bottomNavigationElement, PaintEvent paintEvent) {
            bottomNavigationElement.paint(paintEvent);
        }

        static /* synthetic */ TabbedPropertyList access$2800(BottomNavigationElement bottomNavigationElement) {
            return bottomNavigationElement.TabbedPropertyList.this;
        }
    }

    public class ListElement
    extends Canvas {
        private Tab tab;
        private int index;
        private boolean selected;
        private boolean hover;

        public ListElement(Composite composite, Tab tab, int n) {
            super(composite, 524288);
            this.tab = tab;
            this.hover = false;
            this.selected = false;
            this.index = n;
            this.addPaintListener(new PaintListener(this){
                private final /* synthetic */ ListElement this$1;
                {
                    this.this$1 = listElement;
                }

                public void paintControl(PaintEvent paintEvent) {
                    ListElement.access$000(this.this$1, paintEvent);
                }
            });
            this.addMouseListener(new MouseAdapter(this, TabbedPropertyList.this){
                private final /* synthetic */ TabbedPropertyList val$this$0;
                private final /* synthetic */ ListElement this$1;
                {
                    this.this$1 = listElement;
                    this.val$this$0 = tabbedPropertyList;
                }

                public void mouseDown(MouseEvent mouseEvent) {
                    Composite composite;
                    Control[] controlArray;
                    if (!ListElement.access$100(this.this$1)) {
                        ListElement.access$200(this.this$1).select(TabbedPropertyList.access$300(ListElement.access$200(this.this$1), this.this$1), true);
                    }
                    if ((controlArray = (composite = this.this$1.getParent()).getParent().getTabList()) != null && controlArray.length > 0) {
                        for (int i = 0; i < controlArray.length; ++i) {
                            if (controlArray[i] == ListElement.access$200(this.this$1) || !controlArray[i].setFocus()) continue;
                            TabbedPropertyList.access$402(ListElement.access$200(this.this$1), false);
                            return;
                        }
                    }
                }
            });
            this.addMouseMoveListener(new MouseMoveListener(this){
                private final /* synthetic */ ListElement this$1;
                {
                    this.this$1 = listElement;
                }

                public void mouseMove(MouseEvent mouseEvent) {
                    if (!ListElement.access$500(this.this$1)) {
                        ListElement.access$502(this.this$1, true);
                        this.this$1.redraw();
                    }
                }
            });
            this.addMouseTrackListener(new MouseTrackAdapter(this){
                private final /* synthetic */ ListElement this$1;
                {
                    this.this$1 = listElement;
                }

                public void mouseExit(MouseEvent mouseEvent) {
                    ListElement.access$502(this.this$1, false);
                    this.this$1.redraw();
                }
            });
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            this.redraw();
        }

        private void paint(PaintEvent paintEvent) {
            Rectangle rectangle = this.getBounds();
            paintEvent.gc.setForeground(TabbedPropertyList.this.widgetNormalShadow);
            paintEvent.gc.drawLine(0, 0, rectangle.width - 1, 0);
            paintEvent.gc.setForeground(TabbedPropertyList.this.listBackground);
            paintEvent.gc.drawLine(0, 1, rectangle.width - 1, 1);
            if (this.selected) {
                paintEvent.gc.setBackground(TabbedPropertyList.this.listBackground);
                paintEvent.gc.fillRectangle(0, 2, rectangle.width, rectangle.height - 1);
            } else if (this.hover && this.tab.isIndented()) {
                paintEvent.gc.setBackground(TabbedPropertyList.this.indentedHoverBackground);
                paintEvent.gc.fillRectangle(0, 2, rectangle.width - 1, rectangle.height - 1);
            } else if (this.hover) {
                paintEvent.gc.setForeground(TabbedPropertyList.this.hoverGradientStart);
                paintEvent.gc.setBackground(TabbedPropertyList.this.hoverGradientEnd);
                paintEvent.gc.fillGradientRectangle(0, 2, rectangle.width - 1, rectangle.height - 1, true);
            } else if (this.tab.isIndented()) {
                paintEvent.gc.setBackground(TabbedPropertyList.this.indentedDefaultBackground);
                paintEvent.gc.fillRectangle(0, 2, rectangle.width - 1, rectangle.height - 1);
            } else {
                paintEvent.gc.setForeground(TabbedPropertyList.this.defaultGradientStart);
                paintEvent.gc.setBackground(TabbedPropertyList.this.defaultGradientEnd);
                paintEvent.gc.fillGradientRectangle(0, 2, rectangle.width - 1, rectangle.height - 1, true);
            }
            if (!this.selected) {
                paintEvent.gc.setForeground(TabbedPropertyList.this.widgetNormalShadow);
                paintEvent.gc.drawLine(rectangle.width - 1, 1, rectangle.width - 1, rectangle.height + 1);
            }
            int n = 7;
            FontMetrics fontMetrics = paintEvent.gc.getFontMetrics();
            int n2 = fontMetrics.getHeight();
            int n3 = (rectangle.height - n2) / 2;
            if (this.selected && this.tab.getImage() != null && !this.tab.getImage().isDisposed()) {
                n = this.tab.isIndented() ? (n += 7) : (n -= 3);
                paintEvent.gc.drawImage(this.tab.getImage(), n, n3 - 1);
                n = n + 16 + 5;
            } else if (this.tab.isIndented()) {
                n += 7;
            }
            paintEvent.gc.setForeground(TabbedPropertyList.this.widgetForeground);
            if (this.selected) {
                paintEvent.gc.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
            }
            paintEvent.gc.drawText(this.tab.getText(), n, n3, true);
            if (((TabbedPropertyList)this.getParent()).focus && this.selected && TabbedPropertyList.this.focus) {
                Point point = paintEvent.gc.textExtent(this.tab.getText());
                paintEvent.gc.drawLine(n, rectangle.height - 4, n + point.x, rectangle.height - 4);
            }
            if (!this.hover) {
                paintEvent.gc.setForeground(TabbedPropertyList.this.listBackground);
                paintEvent.gc.drawLine(0, rectangle.height - 1, rectangle.width - 2, rectangle.height - 1);
            }
        }

        public String getText() {
            return this.tab.getText();
        }

        public String toString() {
            return this.tab.getText();
        }

        static /* synthetic */ void access$000(ListElement listElement, PaintEvent paintEvent) {
            listElement.paint(paintEvent);
        }

        static /* synthetic */ boolean access$100(ListElement listElement) {
            return listElement.selected;
        }

        static /* synthetic */ TabbedPropertyList access$200(ListElement listElement) {
            return listElement.TabbedPropertyList.this;
        }

        static /* synthetic */ boolean access$500(ListElement listElement) {
            return listElement.hover;
        }

        static /* synthetic */ boolean access$502(ListElement listElement, boolean bl) {
            listElement.hover = bl;
            return listElement.hover;
        }
    }

    public class TopNavigationElement
    extends Canvas {
        public TopNavigationElement(Composite composite) {
            super(composite, 524288);
            this.addPaintListener(new PaintListener(this){
                private final /* synthetic */ TopNavigationElement this$1;
                {
                    this.this$1 = topNavigationElement;
                }

                public void paintControl(PaintEvent paintEvent) {
                    TopNavigationElement.access$1500(this.this$1, paintEvent);
                }
            });
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ TopNavigationElement this$1;
                {
                    this.this$1 = topNavigationElement;
                }

                public void mouseUp(MouseEvent mouseEvent) {
                    if (TabbedPropertyList.access$1700(TopNavigationElement.access$1600(this.this$1))) {
                        TabbedPropertyList.access$1810(TopNavigationElement.access$1600(this.this$1));
                        if (TabbedPropertyList.access$1900(TopNavigationElement.access$1600(this.this$1)) != 0) {
                            TabbedPropertyList.access$1910(TopNavigationElement.access$1600(this.this$1));
                        }
                        TabbedPropertyList.access$2000(TopNavigationElement.access$1600(this.this$1));
                        TabbedPropertyList.access$2100(TopNavigationElement.access$1600(this.this$1)).redraw();
                        TabbedPropertyList.access$2200(TopNavigationElement.access$1600(this.this$1)).redraw();
                    }
                }
            });
        }

        private void paint(PaintEvent paintEvent) {
            int n;
            paintEvent.gc.setBackground(TabbedPropertyList.this.widgetBackground);
            paintEvent.gc.setForeground(TabbedPropertyList.this.widgetForeground);
            Rectangle rectangle = this.getBounds();
            if (TabbedPropertyList.this.elements.length != 0) {
                paintEvent.gc.fillRectangle(0, 0, rectangle.width, rectangle.height);
                paintEvent.gc.setForeground(TabbedPropertyList.this.widgetNormalShadow);
                paintEvent.gc.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
            } else {
                paintEvent.gc.setBackground(TabbedPropertyList.this.listBackground);
                paintEvent.gc.fillRectangle(0, 0, rectangle.width, rectangle.height);
                n = 7;
                FontMetrics fontMetrics = paintEvent.gc.getFontMetrics();
                int n2 = fontMetrics.getHeight();
                int n3 = (rectangle.height - n2) / 2;
                paintEvent.gc.setForeground(TabbedPropertyList.this.widgetForeground);
                String string = "TabbedPropertyList properties are not available";
                paintEvent.gc.drawText(string, n, n3);
            }
            if (TabbedPropertyList.this.isUpScrollRequired()) {
                paintEvent.gc.setForeground(TabbedPropertyList.this.widgetDarkShadow);
                n = rectangle.width / 2;
                paintEvent.gc.drawLine(n + 1, 3, n + 5, 7);
                paintEvent.gc.drawLine(n, 3, n - 4, 7);
                paintEvent.gc.drawLine(n - 3, 7, n + 4, 7);
                paintEvent.gc.setForeground(TabbedPropertyList.this.listBackground);
                paintEvent.gc.drawLine(n, 4, n + 1, 4);
                paintEvent.gc.drawLine(n - 1, 5, n + 2, 5);
                paintEvent.gc.drawLine(n - 2, 6, n + 3, 6);
                paintEvent.gc.setForeground(TabbedPropertyList.this.widgetNormalShadow);
                paintEvent.gc.drawLine(0, 0, rectangle.width - 2, 0);
                paintEvent.gc.setForeground(TabbedPropertyList.this.navigationElementShadowStroke);
                paintEvent.gc.drawLine(0, 1, rectangle.width - 2, 1);
                paintEvent.gc.drawLine(0, rectangle.height - 1, rectangle.width - 2, rectangle.height - 1);
            }
        }

        static /* synthetic */ void access$1500(TopNavigationElement topNavigationElement, PaintEvent paintEvent) {
            topNavigationElement.paint(paintEvent);
        }

        static /* synthetic */ TabbedPropertyList access$1600(TopNavigationElement topNavigationElement) {
            return topNavigationElement.TabbedPropertyList.this;
        }
    }
}

