/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.runtime.ListenerList;
import org.eclipse.ui.internal.forms.widgets.FormsResources;

public abstract class AbstractHyperlink
extends Canvas {
    private boolean hasFocus;
    private ListenerList listeners;
    protected int marginWidth = 1;
    protected int marginHeight = 1;

    public AbstractHyperlink(Composite parent, int style) {
        super(parent, style);
        this.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    AbstractHyperlink.this.handleActivate(e);
                }
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                AbstractHyperlink.this.paint(e);
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 4: 
                    case 32: 
                    case 64: 
                    case 256: 
                    case 512: {
                        e.doit = false;
                        return;
                    }
                }
                e.doit = true;
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 15: {
                        AbstractHyperlink.this.hasFocus = true;
                        AbstractHyperlink.this.handleEnter(e);
                        break;
                    }
                    case 16: {
                        AbstractHyperlink.this.hasFocus = false;
                        AbstractHyperlink.this.handleExit(e);
                        break;
                    }
                    case 14: {
                        AbstractHyperlink.this.handleActivate(e);
                        break;
                    }
                    case 6: {
                        AbstractHyperlink.this.handleEnter(e);
                        break;
                    }
                    case 7: {
                        AbstractHyperlink.this.handleExit(e);
                        break;
                    }
                    case 4: {
                        AbstractHyperlink.this.handleMouseUp(e);
                    }
                }
            }
        };
        this.addListener(6, listener);
        this.addListener(7, listener);
        this.addListener(4, listener);
        this.addListener(15, listener);
        this.addListener(16, listener);
        this.setCursor(FormsResources.getHandCursor());
    }

    public void addHyperlinkListener(IHyperlinkListener listener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add(listener);
    }

    public void removeHyperlinkListener(IHyperlinkListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public boolean getSelection() {
        return this.hasFocus;
    }

    protected void handleEnter(Event e) {
        this.redraw();
        if (this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        HyperlinkEvent he = new HyperlinkEvent((Widget)this, this.getHref(), this.getText(), e.stateMask);
        Object[] listenerList = this.listeners.getListeners();
        int i = 0;
        while (i < size) {
            IHyperlinkListener listener = (IHyperlinkListener)listenerList[i];
            listener.linkEntered(he);
            ++i;
        }
    }

    protected void handleExit(Event e) {
        this.redraw();
        if (this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        HyperlinkEvent he = new HyperlinkEvent((Widget)this, this.getHref(), this.getText(), e.stateMask);
        Object[] listenerList = this.listeners.getListeners();
        int i = 0;
        while (i < size) {
            IHyperlinkListener listener = (IHyperlinkListener)listenerList[i];
            listener.linkExited(he);
            ++i;
        }
    }

    protected void handleActivate(Event e) {
        this.getAccessible().setFocus(-1);
        if (this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        this.setCursor(FormsResources.getBusyCursor());
        HyperlinkEvent he = new HyperlinkEvent((Widget)this, this.getHref(), this.getText(), e.stateMask);
        Object[] listenerList = this.listeners.getListeners();
        int i = 0;
        while (i < size) {
            IHyperlinkListener listener = (IHyperlinkListener)listenerList[i];
            listener.linkActivated(he);
            ++i;
        }
        if (!this.isDisposed()) {
            this.setCursor(FormsResources.getHandCursor());
        }
    }

    public void setHref(Object href) {
        this.setData("href", href);
    }

    public Object getHref() {
        return this.getData("href");
    }

    public String getText() {
        return this.getToolTipText();
    }

    protected abstract void paintHyperlink(GC var1);

    protected void paint(PaintEvent e) {
        GC gc = e.gc;
        Rectangle clientArea = this.getClientArea();
        if (clientArea.width == 0 || clientArea.height == 0) {
            return;
        }
        this.paintHyperlink(gc);
        if (this.hasFocus) {
            Rectangle carea = this.getClientArea();
            gc.setForeground(this.getForeground());
            gc.drawFocus(0, 0, carea.width, carea.height);
        }
    }

    private void handleMouseUp(Event e) {
        if (e.button != 1) {
            return;
        }
        Point size = this.getSize();
        if (e.x < 0) {
            return;
        }
        if (e.y < 0) {
            return;
        }
        if (e.x >= size.x) {
            return;
        }
        if (e.y >= size.y) {
            return;
        }
        this.handleActivate(e);
    }
}

