/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class BaseDialog
extends Dialog {
    private String title;
    private String okLabel = null;
    protected Object result;

    protected BaseDialog(String string) {
        this(Display.getCurrent().getActiveShell(), string);
    }

    protected BaseDialog(Shell shell, String string) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = string;
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        if (this.initDialog()) {
            return super.open();
        }
        return 1;
    }

    protected boolean initDialog() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.getShell() != null) {
            this.getShell().setText(string);
        }
    }

    public String getTitle() {
        return this.title;
    }

    protected Button getOkButton() {
        return this.getButton(0);
    }

    protected void setOkButtonText(String string) {
        this.okLabel = string;
    }

    public Object getResult() {
        return this.result;
    }

    protected final void setResult(Object object) {
        this.result = object;
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        if (0 == n && this.okLabel != null) {
            return super.createButton(composite, n, this.okLabel, bl);
        }
        return super.createButton(composite, n, string, bl);
    }
}

