/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MessageDialog
extends IconAndMessageDialog {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int INFORMATION = 2;
    public static final int QUESTION = 3;
    public static final int WARNING = 4;
    private String[] buttonLabels;
    private Button[] buttons;
    private int defaultButtonIndex;
    private String title;
    private Image titleImage;
    private Image image = null;
    private Control customArea;

    public MessageDialog(Shell shell, String string, Image image, String string2, int n, String[] stringArray, int n2) {
        super(shell);
        this.title = string;
        this.titleImage = image;
        this.message = string2;
        switch (n) {
            case 1: {
                this.image = this.getErrorImage();
                break;
            }
            case 2: {
                this.image = this.getInfoImage();
                break;
            }
            case 3: {
                this.image = this.getQuestionImage();
                break;
            }
            case 4: {
                this.image = this.getWarningImage();
            }
        }
        this.buttonLabels = stringArray;
        this.defaultButtonIndex = n2;
    }

    protected void buttonPressed(int n) {
        this.setReturnCode(n);
        this.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
        if (this.titleImage != null) {
            shell.setImage(this.titleImage);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.buttons = new Button[this.buttonLabels.length];
        for (int i = 0; i < this.buttonLabels.length; ++i) {
            Button button;
            String string = this.buttonLabels[i];
            this.buttons[i] = button = this.createButton(composite, i, string, this.defaultButtonIndex == i);
        }
    }

    protected Control createCustomArea(Composite composite) {
        return null;
    }

    protected Control createDialogArea(Composite composite) {
        this.createMessageArea(composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        this.customArea = this.createCustomArea(composite2);
        if (this.customArea == null) {
            this.customArea = new Label(composite2, 0);
        }
        return composite2;
    }

    protected Button getButton(int n) {
        return this.buttons[n];
    }

    protected int getMinimumMessageWidth() {
        return this.convertHorizontalDLUsToPixels(300);
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.setReturnCode(-1);
    }

    public static boolean openConfirm(Shell shell, String string, String string2) {
        MessageDialog messageDialog = new MessageDialog(shell, string, null, string2, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        return messageDialog.open() == 0;
    }

    public static void openError(Shell shell, String string, String string2) {
        MessageDialog messageDialog = new MessageDialog(shell, string, null, string2, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        messageDialog.open();
    }

    public static void openInformation(Shell shell, String string, String string2) {
        MessageDialog messageDialog = new MessageDialog(shell, string, null, string2, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        messageDialog.open();
    }

    public static boolean openQuestion(Shell shell, String string, String string2) {
        MessageDialog messageDialog = new MessageDialog(shell, string, null, string2, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        return messageDialog.open() == 0;
    }

    public static void openWarning(Shell shell, String string, String string2) {
        MessageDialog messageDialog = new MessageDialog(shell, string, null, string2, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
        messageDialog.open();
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        Button button = super.createButton(composite, n, string, bl);
        if (bl && !this.customShouldTakeFocus()) {
            button.setFocus();
        }
        return button;
    }

    protected boolean customShouldTakeFocus() {
        if (this.customArea instanceof Label) {
            return false;
        }
        if (this.customArea instanceof CLabel) {
            return (this.customArea.getStyle() & 0x80000) > 0;
        }
        return true;
    }

    public Image getImage() {
        return this.image;
    }

    protected String[] getButtonLabels() {
        return this.buttonLabels;
    }

    protected int getDefaultButtonIndex() {
        return this.defaultButtonIndex;
    }

    protected void setButtons(Button[] buttonArray) {
        if (buttonArray == null) {
            throw new NullPointerException("The array of buttons cannot be null.");
        }
        this.buttons = buttonArray;
    }

    protected void setButtonLabels(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("The array of button labels cannot be null.");
        }
        this.buttonLabels = stringArray;
    }
}

