/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.ArrayFontDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public abstract class FontDescriptor
extends DeviceResourceDescriptor {
    public static FontDescriptor createFrom(Font font, Device device) {
        return new ArrayFontDescriptor(font);
    }

    public static FontDescriptor createFrom(Font font) {
        return new ArrayFontDescriptor(font);
    }

    public static FontDescriptor createFrom(FontData[] fontDataArray) {
        return new ArrayFontDescriptor(fontDataArray);
    }

    public static FontDescriptor createFrom(FontData fontData) {
        return new ArrayFontDescriptor(new FontData[]{fontData});
    }

    public static FontDescriptor createFrom(String string, int n, int n2) {
        return FontDescriptor.createFrom(new FontData(string, n, n2));
    }

    public FontData[] getFontData() {
        Font font = this.createFont((Device)Display.getCurrent());
        FontData[] fontDataArray = font.getFontData();
        this.destroyFont(font);
        return fontDataArray;
    }

    public static FontData[] copy(FontData[] fontDataArray) {
        FontData[] fontDataArray2 = new FontData[fontDataArray.length];
        for (int i = 0; i < fontDataArray.length; ++i) {
            FontData fontData = fontDataArray[i];
            fontDataArray2[i] = FontDescriptor.copy(fontData);
        }
        return fontDataArray2;
    }

    public static FontData copy(FontData fontData) {
        FontData fontData2 = new FontData(fontData.getName(), fontData.getHeight(), fontData.getStyle());
        fontData2.setLocale(fontData.getLocale());
        return fontData2;
    }

    public final FontDescriptor setStyle(int n) {
        FontData[] fontDataArray = this.getFontData();
        for (int i = 0; i < fontDataArray.length; ++i) {
            FontData fontData = fontDataArray[i];
            fontData.setStyle(n);
        }
        ArrayFontDescriptor arrayFontDescriptor = new ArrayFontDescriptor(fontDataArray);
        if (((Object)arrayFontDescriptor).equals(this)) {
            return this;
        }
        return arrayFontDescriptor;
    }

    public final FontDescriptor withStyle(int n) {
        FontData[] fontDataArray = this.getFontData();
        for (int i = 0; i < fontDataArray.length; ++i) {
            FontData fontData = fontDataArray[i];
            fontData.setStyle(fontData.getStyle() | n);
        }
        ArrayFontDescriptor arrayFontDescriptor = new ArrayFontDescriptor(fontDataArray);
        if (((Object)arrayFontDescriptor).equals(this)) {
            return this;
        }
        return arrayFontDescriptor;
    }

    public final FontDescriptor setHeight(int n) {
        FontData[] fontDataArray = this.getFontData();
        for (int i = 0; i < fontDataArray.length; ++i) {
            FontData fontData = fontDataArray[i];
            fontData.setHeight(n);
        }
        ArrayFontDescriptor arrayFontDescriptor = new ArrayFontDescriptor(fontDataArray);
        if (((Object)arrayFontDescriptor).equals(this)) {
            return this;
        }
        return arrayFontDescriptor;
    }

    public final FontDescriptor increaseHeight(int n) {
        if (n == 0) {
            return this;
        }
        FontData[] fontDataArray = this.getFontData();
        for (int i = 0; i < fontDataArray.length; ++i) {
            FontData fontData = fontDataArray[i];
            fontData.setHeight(fontData.getHeight() + n);
        }
        return new ArrayFontDescriptor(fontDataArray);
    }

    public abstract Font createFont(Device var1) throws DeviceResourceException;

    public abstract void destroyFont(Font var1);

    public final Object createResource(Device device) throws DeviceResourceException {
        return this.createFont(device);
    }

    public final void destroyResource(Object object) {
        this.destroyFont((Font)object);
    }
}

