/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.internal.InternalPolicy;
import org.eclipse.jface.runtime.Status;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public abstract class ColumnViewer
extends StructuredViewer {
    private CellEditor[] cellEditors;
    private ICellModifier cellModifier;
    private String[] columnProperties;
    private ViewerCell cell = new ViewerCell(null, 0, null);
    private ColumnViewerEditor viewerEditor;
    boolean busy;
    boolean logWhenBusy = true;

    boolean isBusy() {
        if (this.busy) {
            if (this.logWhenBusy) {
                String string = "Ignored reentrant call while viewer is busy.";
                if (!InternalPolicy.DEBUG_LOG_REENTRANT_VIEWER_CALLS) {
                    this.logWhenBusy = false;
                    string = string + " This is only logged once per viewer instance, but similar calls will still be ignored.";
                }
                Policy.getLog().log(new Status(2, "org.eclipse.jface", string, new RuntimeException()));
            }
            return true;
        }
        return false;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.viewerEditor = this.createViewerEditor();
        this.hookEditingSupport(control);
    }

    protected void hookEditingSupport(Control control) {
        if (this.viewerEditor != null) {
            control.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    if (mouseEvent.count != 2) {
                        ColumnViewer.this.handleMouseDown(mouseEvent);
                    }
                }

                public void mouseDoubleClick(MouseEvent mouseEvent) {
                    ColumnViewer.this.handleMouseDown(mouseEvent);
                }
            });
        }
    }

    protected abstract ColumnViewerEditor createViewerEditor();

    ViewerCell getCell(Point point) {
        ViewerRow viewerRow = this.getViewerRow(point);
        if (viewerRow != null) {
            return viewerRow.getCell(point);
        }
        return null;
    }

    protected ViewerRow getViewerRow(Point point) {
        Item item = this.getItemAt(point);
        if (item != null) {
            return this.getViewerRowFromItem((Widget)item);
        }
        return null;
    }

    protected abstract ViewerRow getViewerRowFromItem(Widget var1);

    protected abstract Widget getColumnViewerOwner(int var1);

    ViewerColumn getViewerColumn(int n) {
        Widget widget = this.getColumnViewerOwner(n);
        if (widget == null) {
            return null;
        }
        ViewerColumn viewerColumn = (ViewerColumn)widget.getData(ViewerColumn.COLUMN_VIEWER_KEY);
        if (viewerColumn == null) {
            viewerColumn = this.createViewerColumn(widget, CellLabelProvider.createViewerLabelProvider(this.getLabelProvider()));
            this.setupEditingSupport(n, viewerColumn);
        }
        if (viewerColumn.getEditingSupport() == null && this.getCellModifier() != null) {
            this.setupEditingSupport(n, viewerColumn);
        }
        return viewerColumn;
    }

    private void setupEditingSupport(final int n, ViewerColumn viewerColumn) {
        if (this.getCellModifier() != null) {
            viewerColumn.setEditingSupport(new EditingSupport(this){

                public boolean canEdit(Object object) {
                    return ColumnViewer.this.getCellModifier().canModify(object, (String)ColumnViewer.this.getColumnProperties()[n]);
                }

                public CellEditor getCellEditor(Object object) {
                    return ColumnViewer.this.getCellEditors()[n];
                }

                public Object getValue(Object object) {
                    return ColumnViewer.this.getCellModifier().getValue(object, (String)ColumnViewer.this.getColumnProperties()[n]);
                }

                public void setValue(Object object, Object object2) {
                    ColumnViewer.this.getCellModifier().modify(ColumnViewer.this.findItem(object), (String)ColumnViewer.this.getColumnProperties()[n], object2);
                }
            });
        }
    }

    private ViewerColumn createViewerColumn(Widget widget, CellLabelProvider cellLabelProvider) {
        ViewerColumn viewerColumn = new ViewerColumn(this, widget){};
        viewerColumn.setLabelProvider(cellLabelProvider, false);
        return viewerColumn;
    }

    ViewerCell updateCell(ViewerRow viewerRow, int n, Object object) {
        this.cell.update(viewerRow, n, object);
        return this.cell;
    }

    protected abstract Item getItemAt(Point var1);

    protected Item getItem(int n, int n2) {
        return this.getItemAt(this.getControl().toControl(n, n2));
    }

    public void setLabelProvider(IBaseLabelProvider iBaseLabelProvider) {
        Assert.isTrue(iBaseLabelProvider instanceof ITableLabelProvider || iBaseLabelProvider instanceof ILabelProvider || iBaseLabelProvider instanceof CellLabelProvider);
        this.updateColumnParts(iBaseLabelProvider);
        super.setLabelProvider(iBaseLabelProvider);
    }

    private void updateColumnParts(IBaseLabelProvider iBaseLabelProvider) {
        ViewerColumn viewerColumn;
        int n = 0;
        while ((viewerColumn = this.getViewerColumn(n++)) != null) {
            viewerColumn.setLabelProvider(CellLabelProvider.createViewerLabelProvider(iBaseLabelProvider), false);
        }
    }

    public void cancelEditing() {
        if (this.viewerEditor != null) {
            this.viewerEditor.cancelEditing();
        }
    }

    protected void applyEditorValue() {
        if (this.viewerEditor != null) {
            this.viewerEditor.applyEditorValue();
        }
    }

    public void editElement(Object object, int n) {
        ViewerCell viewerCell;
        ViewerRow viewerRow;
        Widget widget;
        if (this.viewerEditor != null && (widget = this.findItem(object)) != null && (viewerRow = this.getViewerRowFromItem(widget)) != null && (viewerCell = viewerRow.getCell(n)) != null) {
            this.getControl().setRedraw(false);
            this.setSelection(new StructuredSelection(viewerCell.getElement()));
            this.triggerEditorActivationEvent(new ColumnViewerEditorActivationEvent(viewerCell));
            this.getControl().setRedraw(true);
        }
    }

    public CellEditor[] getCellEditors() {
        return this.cellEditors;
    }

    public ICellModifier getCellModifier() {
        return this.cellModifier;
    }

    public Object[] getColumnProperties() {
        return this.columnProperties;
    }

    public boolean isCellEditorActive() {
        if (this.viewerEditor != null) {
            return this.viewerEditor.isCellEditorActive();
        }
        return false;
    }

    public void refresh(Object object) {
        if (this.isBusy()) {
            return;
        }
        if (this.isCellEditorActive()) {
            this.cancelEditing();
        }
        super.refresh(object);
    }

    public void refresh(Object object, boolean bl) {
        if (this.isBusy()) {
            return;
        }
        if (this.isCellEditorActive()) {
            this.cancelEditing();
        }
        super.refresh(object, bl);
    }

    public void update(Object object, String[] stringArray) {
        if (this.isBusy()) {
            return;
        }
        super.update(object, stringArray);
    }

    public void setCellEditors(CellEditor[] cellEditorArray) {
        this.cellEditors = cellEditorArray;
    }

    public void setCellModifier(ICellModifier iCellModifier) {
        this.cellModifier = iCellModifier;
    }

    public void setColumnProperties(String[] stringArray) {
        this.columnProperties = stringArray;
    }

    protected abstract int doGetColumnCount();

    public CellLabelProvider getLabelProvider(int n) {
        ViewerColumn viewerColumn = this.getViewerColumn(n);
        if (viewerColumn != null) {
            return viewerColumn.getLabelProvider();
        }
        return null;
    }

    private void handleMouseDown(MouseEvent mouseEvent) {
        ViewerCell viewerCell = this.getCell(new Point(mouseEvent.x, mouseEvent.y));
        if (viewerCell != null) {
            this.triggerEditorActivationEvent(new ColumnViewerEditorActivationEvent(viewerCell, mouseEvent));
        }
    }

    protected void triggerEditorActivationEvent(ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
        this.viewerEditor.handleEditorActivationEvent(columnViewerEditorActivationEvent);
    }

    public void setColumnViewerEditor(ColumnViewerEditor columnViewerEditor) {
        Assert.isNotNull(this.viewerEditor);
        this.viewerEditor = columnViewerEditor;
    }

    public ColumnViewerEditor getColumnViewerEditor() {
        return this.viewerEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getRawChildren(Object object) {
        boolean bl = this.busy;
        this.busy = true;
        try {
            Object[] objectArray = super.getRawChildren(object);
            return objectArray;
        }
        finally {
            this.busy = bl;
        }
    }
}

