/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;

public abstract class ColumnViewerEditor {
    private CellEditor cellEditor;
    private ICellEditorListener cellEditorListener;
    private FocusListener focusListener;
    private MouseListener mouseListener;
    private ColumnViewer viewer;
    private TraverseListener tabeditingListener;
    private int activationTime;
    private ViewerCell cell;
    private ColumnViewerEditorActivationEvent activationEvent;
    private ListenerList editorActivationListener;
    private ColumnViewerEditorActivationStrategy editorActivationStrategy;
    public static final int DEFAULT = 1;
    public static final int TABBING_MOVE_TO_ROW_NEIGHBOR = 2;
    public static final int TABBING_CYCLE_IN_ROW = 4;
    public static final int TABBING_VERTICAL = 8;
    public static final int TABBING_HORIZONTAL = 16;
    public static final int KEYBOARD_ACTIVATION = 32;
    private int feature;

    protected ColumnViewerEditor(ColumnViewer columnViewer, ColumnViewerEditorActivationStrategy columnViewerEditorActivationStrategy, int n) {
        this.viewer = columnViewer;
        this.editorActivationStrategy = columnViewerEditorActivationStrategy;
        if ((n & 0x20) == 32) {
            this.editorActivationStrategy.setEnableEditorActivationWithKeyboard(true);
        }
        this.feature = n;
        this.initCellEditorListener();
    }

    private void initCellEditorListener() {
        this.cellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean bl, boolean bl2) {
            }

            public void cancelEditor() {
                ColumnViewerEditor.this.cancelEditing();
            }

            public void applyEditorValue() {
                ColumnViewerEditor.this.applyEditorValue();
            }
        };
    }

    void activateCellEditor() {
        ViewerColumn viewerColumn = this.viewer.getViewerColumn(this.cell.getColumnIndex());
        Object object = this.cell.getElement();
        if (viewerColumn != null && viewerColumn.getEditingSupport() != null && viewerColumn.getEditingSupport().canEdit(object)) {
            this.cellEditor = viewerColumn.getEditingSupport().getCellEditor(object);
            if (this.cellEditor != null) {
                Control control;
                if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                    control = this.editorActivationListener.getListeners();
                    for (int i = 0; i < ((Object[])control).length; ++i) {
                        if (this.activationEvent.cancel) {
                            return;
                        }
                        ((ColumnViewerEditorActivationListener)control[i]).beforeEditorActivated(this.activationEvent);
                    }
                }
                this.updateFocusCell(this.cell, this.activationEvent);
                this.cellEditor.addListener(this.cellEditorListener);
                viewerColumn.getEditingSupport().initializeCellEditorValue(this.cellEditor, this.cell);
                control = this.cellEditor.getControl();
                this.cellEditor.activate(this.activationEvent);
                if (control == null) {
                    return;
                }
                this.setLayoutData(this.cellEditor.getLayoutData());
                this.setEditor(control, (Item)this.cell.getItem(), this.cell.getColumnIndex());
                this.cellEditor.setFocus();
                if (this.cellEditor.dependsOnExternalFocusListener()) {
                    if (this.focusListener == null) {
                        this.focusListener = new FocusAdapter(){

                            public void focusLost(FocusEvent focusEvent) {
                                ColumnViewerEditor.this.applyEditorValue();
                            }
                        };
                    }
                    control.addFocusListener(this.focusListener);
                }
                this.mouseListener = new MouseAdapter(){

                    public void mouseDown(MouseEvent mouseEvent) {
                        if (mouseEvent.time <= ColumnViewerEditor.this.activationTime) {
                            control.removeMouseListener(ColumnViewerEditor.this.mouseListener);
                            ColumnViewerEditor.this.cancelEditing();
                            ColumnViewerEditor.this.handleDoubleClickEvent();
                        } else if (ColumnViewerEditor.this.mouseListener != null) {
                            control.removeMouseListener(ColumnViewerEditor.this.mouseListener);
                        }
                    }
                };
                control.addMouseListener(this.mouseListener);
                if (this.tabeditingListener == null) {
                    this.tabeditingListener = new TraverseListener(){

                        public void keyTraversed(TraverseEvent traverseEvent) {
                            if ((ColumnViewerEditor.this.feature & 1) != 1) {
                                ColumnViewerEditor.this.processTraverseEvent(ColumnViewerEditor.this.cell.getColumnIndex(), ColumnViewerEditor.this.viewer.getViewerRowFromItem(ColumnViewerEditor.this.cell.getItem()), traverseEvent);
                            }
                        }
                    };
                }
                control.addTraverseListener(this.tabeditingListener);
                if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                    Object[] objectArray = this.editorActivationListener.getListeners();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((ColumnViewerEditorActivationListener)objectArray[i]).afterEditorActivated(this.activationEvent);
                    }
                }
            }
        }
    }

    void applyEditorValue() {
        CellEditor cellEditor = this.cellEditor;
        if (cellEditor != null) {
            Item item;
            ColumnViewerEditorDeactivationEvent columnViewerEditorDeactivationEvent = new ColumnViewerEditorDeactivationEvent(this.cell);
            if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                item = this.editorActivationListener.getListeners();
                for (int i = 0; i < ((Item)item).length; ++i) {
                    ((ColumnViewerEditorActivationListener)item[i]).beforeEditorDeactivated(columnViewerEditorDeactivationEvent);
                }
            }
            this.cellEditor = null;
            this.activationEvent = null;
            item = (Item)this.cell.getItem();
            if (item != null && !item.isDisposed()) {
                this.saveEditorValue(cellEditor);
            }
            this.setEditor(null, null, 0);
            cellEditor.removeListener(this.cellEditorListener);
            Control control = cellEditor.getControl();
            if (control != null) {
                if (this.mouseListener != null) {
                    control.removeMouseListener(this.mouseListener);
                    this.mouseListener = null;
                }
                if (this.focusListener != null) {
                    control.removeFocusListener(this.focusListener);
                }
                if (this.tabeditingListener != null) {
                    control.removeTraverseListener(this.tabeditingListener);
                }
            }
            cellEditor.deactivate();
            if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                Object[] objectArray = this.editorActivationListener.getListeners();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((ColumnViewerEditorActivationListener)objectArray[i]).afterEditorDeactivated(columnViewerEditorDeactivationEvent);
                }
            }
        }
    }

    void cancelEditing() {
        if (this.cellEditor != null) {
            Control control;
            ColumnViewerEditorDeactivationEvent columnViewerEditorDeactivationEvent = new ColumnViewerEditorDeactivationEvent(this.cell);
            if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                control = this.editorActivationListener.getListeners();
                for (int i = 0; i < ((Object[])control).length; ++i) {
                    ((ColumnViewerEditorActivationListener)control[i]).beforeEditorDeactivated(columnViewerEditorDeactivationEvent);
                }
            }
            this.setEditor(null, null, 0);
            this.cellEditor.removeListener(this.cellEditorListener);
            control = this.cellEditor.getControl();
            if (control != null) {
                if (this.mouseListener != null) {
                    control.removeMouseListener(this.mouseListener);
                    this.mouseListener = null;
                }
                if (this.focusListener != null) {
                    control.removeFocusListener(this.focusListener);
                }
                if (this.tabeditingListener != null) {
                    control.removeTraverseListener(this.tabeditingListener);
                }
            }
            CellEditor cellEditor = this.cellEditor;
            this.cellEditor = null;
            this.activationEvent = null;
            cellEditor.deactivate();
            if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                Object[] objectArray = this.editorActivationListener.getListeners();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((ColumnViewerEditorActivationListener)objectArray[i]).afterEditorDeactivated(columnViewerEditorDeactivationEvent);
                }
            }
        }
    }

    void handleEditorActivationEvent(ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
        if (this.editorActivationStrategy.isEditorActivationEvent(columnViewerEditorActivationEvent)) {
            if (this.cellEditor != null) {
                this.applyEditorValue();
            }
            this.cell = (ViewerCell)columnViewerEditorActivationEvent.getSource();
            this.activationEvent = columnViewerEditorActivationEvent;
            this.activationTime = columnViewerEditorActivationEvent.time + Display.getCurrent().getDoubleClickTime();
            this.activateCellEditor();
        }
    }

    private void saveEditorValue(CellEditor cellEditor) {
        ViewerColumn viewerColumn = this.viewer.getViewerColumn(this.cell.getColumnIndex());
        if (viewerColumn != null && viewerColumn.getEditingSupport() != null) {
            viewerColumn.getEditingSupport().saveCellEditorValue(cellEditor, this.cell);
        }
    }

    boolean isCellEditorActive() {
        return this.cellEditor != null;
    }

    void handleDoubleClickEvent() {
        this.viewer.fireDoubleClick(new DoubleClickEvent(this.viewer, this.viewer.getSelection()));
        this.viewer.fireOpen(new OpenEvent(this.viewer, this.viewer.getSelection()));
    }

    public void addEditorActivationListener(ColumnViewerEditorActivationListener columnViewerEditorActivationListener) {
        if (this.editorActivationListener == null) {
            this.editorActivationListener = new ListenerList();
        }
        this.editorActivationListener.add(columnViewerEditorActivationListener);
    }

    public void removeEditorActivationListener(ColumnViewerEditorActivationListener columnViewerEditorActivationListener) {
        if (this.editorActivationListener != null) {
            this.editorActivationListener.remove(columnViewerEditorActivationListener);
        }
    }

    protected void processTraverseEvent(int n, ViewerRow viewerRow, TraverseEvent traverseEvent) {
        ViewerCell viewerCell = null;
        if (traverseEvent.detail == 8) {
            traverseEvent.doit = false;
            if ((traverseEvent.stateMask & 0x40000) == 262144 && (this.feature & 8) == 8) {
                viewerCell = this.searchCellAboveBelow(viewerRow, this.viewer, n, true);
            } else if ((this.feature & 0x10) == 16) {
                viewerCell = this.searchPreviousCell(viewerRow, this.viewer, n, n);
            }
        } else if (traverseEvent.detail == 16) {
            traverseEvent.doit = false;
            if ((traverseEvent.stateMask & 0x40000) == 262144 && (this.feature & 8) == 8) {
                viewerCell = this.searchCellAboveBelow(viewerRow, this.viewer, n, false);
            } else if ((this.feature & 0x10) == 16) {
                viewerCell = this.searchNextCell(viewerRow, this.viewer, n, n);
            }
        }
        if (viewerCell != null) {
            this.viewer.getControl().setRedraw(false);
            ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent = new ColumnViewerEditorActivationEvent(viewerCell, traverseEvent);
            this.viewer.triggerEditorActivationEvent(columnViewerEditorActivationEvent);
            this.viewer.getControl().setRedraw(true);
        }
    }

    private ViewerCell searchCellAboveBelow(ViewerRow viewerRow, ColumnViewer columnViewer, int n, boolean bl) {
        ViewerCell viewerCell = null;
        ViewerRow viewerRow2 = null;
        viewerRow2 = bl ? viewerRow.getNeighbor(1, false) : viewerRow.getNeighbor(2, false);
        if (viewerRow2 != null) {
            ViewerColumn viewerColumn = columnViewer.getViewerColumn(n);
            viewerCell = viewerColumn != null && viewerColumn.getEditingSupport() != null && viewerColumn.getEditingSupport().canEdit(viewerRow2.getItem().getData()) ? viewerRow2.getCell(n) : this.searchCellAboveBelow(viewerRow2, columnViewer, n, bl);
        }
        return viewerCell;
    }

    private ViewerCell searchPreviousCell(ViewerRow viewerRow, ColumnViewer columnViewer, int n, int n2) {
        ViewerRow viewerRow2;
        ViewerCell viewerCell = null;
        if (n - 1 >= 0) {
            ViewerColumn viewerColumn = columnViewer.getViewerColumn(n - 1);
            viewerCell = viewerColumn != null && viewerColumn.getEditingSupport() != null && viewerColumn.getEditingSupport().canEdit(viewerRow.getItem().getData()) ? viewerRow.getCell(n - 1) : this.searchPreviousCell(viewerRow, columnViewer, n - 1, n2);
        } else if ((this.feature & 4) == 4) {
            if (n - 1 != n2) {
                viewerCell = this.searchPreviousCell(viewerRow, columnViewer, viewerRow.getColumnCount(), n2);
            }
        } else if ((this.feature & 2) == 2 && (viewerRow2 = viewerRow.getNeighbor(1, false)) != null) {
            viewerCell = this.searchPreviousCell(viewerRow2, columnViewer, viewerRow2.getColumnCount(), n2);
        }
        return viewerCell;
    }

    private ViewerCell searchNextCell(ViewerRow viewerRow, ColumnViewer columnViewer, int n, int n2) {
        ViewerRow viewerRow2;
        ViewerCell viewerCell = null;
        if (n + 1 < viewerRow.getColumnCount()) {
            ViewerColumn viewerColumn = columnViewer.getViewerColumn(n + 1);
            viewerCell = viewerColumn != null && viewerColumn.getEditingSupport() != null && viewerColumn.getEditingSupport().canEdit(viewerRow.getItem().getData()) ? viewerRow.getCell(n + 1) : this.searchNextCell(viewerRow, columnViewer, n + 1, n2);
        } else if ((this.feature & 4) == 4) {
            if (n + 1 != n2) {
                viewerCell = this.searchNextCell(viewerRow, columnViewer, -1, n2);
            }
        } else if ((this.feature & 2) == 2 && (viewerRow2 = viewerRow.getNeighbor(2, false)) != null) {
            viewerCell = this.searchNextCell(viewerRow2, columnViewer, -1, n2);
        }
        return viewerCell;
    }

    protected abstract void setEditor(Control var1, Item var2, int var3);

    protected abstract void setLayoutData(CellEditor.LayoutData var1);

    protected abstract void updateFocusCell(ViewerCell var1, ColumnViewerEditorActivationEvent var2);

    public ViewerCell getFocusCell() {
        return null;
    }

    protected ColumnViewer getViewer() {
        return this.viewer;
    }
}

