/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

abstract class SWTFocusCellManager {
    private CellNavigationStrategy navigationStrategy;
    private ColumnViewer viewer;
    private ViewerCell focusCell;
    private FocusCellHighlighter cellHighlighter;
    private DisposeListener itemDeletionListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            SWTFocusCellManager.this.setFocusCell(null);
        }
    };

    public SWTFocusCellManager(ColumnViewer columnViewer, FocusCellHighlighter focusCellHighlighter, CellNavigationStrategy cellNavigationStrategy) {
        this.viewer = columnViewer;
        this.cellHighlighter = focusCellHighlighter;
        this.navigationStrategy = cellNavigationStrategy;
        this.hookListener(columnViewer);
    }

    void init() {
        this.cellHighlighter.init();
        this.navigationStrategy.init();
    }

    private void handleMouseDown(Event event) {
        ViewerCell viewerCell = this.viewer.getCell(new Point(event.x, event.y));
        if (viewerCell != null && !viewerCell.equals(this.focusCell)) {
            this.setFocusCell(viewerCell);
        }
    }

    private void handleKeyDown(Event event) {
        ViewerCell viewerCell = null;
        if (this.navigationStrategy.isCollapseEvent(this.viewer, this.focusCell, event)) {
            this.navigationStrategy.collapse(this.viewer, this.focusCell, event);
        } else if (this.navigationStrategy.isExpandEvent(this.viewer, this.focusCell, event)) {
            this.navigationStrategy.expand(this.viewer, this.focusCell, event);
        } else if (this.navigationStrategy.isNavigationEvent(this.viewer, event) && (viewerCell = this.navigationStrategy.findSelectedCell(this.viewer, this.focusCell, event)) != null && !viewerCell.equals(this.focusCell)) {
            this.setFocusCell(viewerCell);
        }
        if (this.navigationStrategy.shouldCancelEvent(this.viewer, event)) {
            event.doit = false;
        }
    }

    private void handleSelection(Event event) {
        if (this.focusCell != null && this.focusCell.getItem() != event.item && event.item != null) {
            ViewerRow viewerRow = this.viewer.getViewerRowFromItem(event.item);
            Assert.isNotNull(viewerRow, "Internal Structure invalid. Row item has no row ViewerRow assigned");
            ViewerCell viewerCell = viewerRow.getCell(this.focusCell.getColumnIndex());
            if (!this.focusCell.equals(viewerCell)) {
                this.setFocusCell(viewerCell);
            }
        }
    }

    private void handleFocusIn(Event event) {
        if (this.focusCell == null) {
            this.setFocusCell(this.getInitialFocusCell());
        }
    }

    abstract ViewerCell getInitialFocusCell();

    private void hookListener(ColumnViewer columnViewer) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        SWTFocusCellManager.this.handleMouseDown(event);
                        break;
                    }
                    case 1: {
                        SWTFocusCellManager.this.handleKeyDown(event);
                        break;
                    }
                    case 13: {
                        SWTFocusCellManager.this.handleSelection(event);
                        break;
                    }
                    case 15: {
                        SWTFocusCellManager.this.handleFocusIn(event);
                    }
                }
            }
        };
        columnViewer.getControl().addListener(3, listener);
        columnViewer.getControl().addListener(1, listener);
        columnViewer.getControl().addListener(13, listener);
        columnViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (selectionChangedEvent.selection.isEmpty()) {
                    SWTFocusCellManager.this.setFocusCell(null);
                }
            }
        });
        columnViewer.getControl().addListener(15, listener);
    }

    public ViewerCell getFocusCell() {
        return this.focusCell;
    }

    void setFocusCell(ViewerCell viewerCell) {
        if (this.focusCell != null && !this.focusCell.getItem().isDisposed()) {
            this.focusCell.getItem().removeDisposeListener(this.itemDeletionListener);
        }
        this.focusCell = viewerCell;
        if (this.focusCell != null && !this.focusCell.getItem().isDisposed()) {
            this.focusCell.getItem().addDisposeListener(this.itemDeletionListener);
        }
        this.cellHighlighter.focusCellChanged(viewerCell);
    }

    ColumnViewer getViewer() {
        return this.viewer;
    }
}

