/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class StructuredViewer
extends ContentViewer
implements IPostSelectionProvider {
    private CustomHashtable elementMap;
    private IElementComparer comparer;
    private ViewerComparator sorter;
    private List filters;
    private boolean inChange;
    private boolean restoreSelection;
    private ListenerList doubleClickListeners = new ListenerList();
    private ListenerList openListeners = new ListenerList();
    private ListenerList postSelectionChangedListeners = new ListenerList();
    private ColorAndFontCollector colorAndFontCollector = new ColorAndFontCollector();
    private static Widget[] NO_WIDGETS = new Widget[0];

    protected StructuredViewer() {
    }

    public void addDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        this.doubleClickListeners.add(iDoubleClickListener);
    }

    public void addOpenListener(IOpenListener iOpenListener) {
        this.openListeners.add(iOpenListener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.postSelectionChangedListeners.add(iSelectionChangedListener);
    }

    public void addDragSupport(int n, Transfer[] transferArray, DragSourceListener dragSourceListener) {
        Control control = this.getControl();
        DragSource dragSource = new DragSource(control, n);
        dragSource.setTransfer(transferArray);
        dragSource.addDragListener(dragSourceListener);
    }

    public void addDropSupport(int n, Transfer[] transferArray, DropTargetListener dropTargetListener) {
        Control control = this.getControl();
        DropTarget dropTarget = new DropTarget(control, n);
        dropTarget.setTransfer(transferArray);
        dropTarget.addDropListener(dropTargetListener);
    }

    public void addFilter(ViewerFilter viewerFilter) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        this.filters.add(viewerFilter);
        this.refresh();
    }

    protected void assertElementsNotNull(Object[] objectArray) {
        Assert.isNotNull(objectArray);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Assert.isNotNull(objectArray[i]);
        }
    }

    protected void associate(Object object, Item item) {
        Object object2 = item.getData();
        if (object2 != object) {
            if (object2 != null) {
                this.disassociate(item);
            }
            item.setData(object);
        }
        this.mapElement(object, (Widget)item);
    }

    protected void disassociate(Item item) {
        Object object = item.getData();
        Assert.isNotNull(object);
        this.unmapElement(object, (Widget)item);
        item.setData(null);
    }

    protected abstract Widget doFindInputItem(Object var1);

    protected abstract Widget doFindItem(Object var1);

    protected abstract void doUpdateItem(Widget var1, Object var2, boolean var3);

    protected boolean equals(Object object, Object object2) {
        if (this.comparer == null) {
            return object == null ? object2 == null : object.equals(object2);
        }
        return object == null ? object2 == null : this.comparer.equals(object, object2);
    }

    protected Object[] filter(Object[] objectArray) {
        if (this.filters != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            Object object = this.getRoot();
            for (int i = 0; i < objectArray.length; ++i) {
                boolean bl = true;
                for (int j = 0; j < this.filters.size() && (bl = ((ViewerFilter)this.filters.get(j)).select(this, object, objectArray[i])); ++j) {
                }
                if (!bl) continue;
                arrayList.add(objectArray[i]);
            }
            return arrayList.toArray();
        }
        return objectArray;
    }

    protected final Widget findItem(Object object) {
        Widget[] widgetArray = this.findItems(object);
        return widgetArray.length == 0 ? null : widgetArray[0];
    }

    protected final Widget[] findItems(Object object) {
        Widget[] widgetArray;
        Widget widget = this.doFindInputItem(object);
        if (widget != null) {
            return new Widget[]{widget};
        }
        if (this.usingElementMap()) {
            Object object2 = this.elementMap.get(object);
            if (object2 == null) {
                return NO_WIDGETS;
            }
            if (object2 instanceof Widget) {
                return new Widget[]{(Widget)object2};
            }
            return (Widget[])object2;
        }
        widget = this.doFindItem(object);
        if (widget == null) {
            widgetArray = NO_WIDGETS;
        } else {
            Widget[] widgetArray2 = new Widget[1];
            widgetArray = widgetArray2;
            widgetArray2[0] = widget;
        }
        return widgetArray;
    }

    protected void fireDoubleClick(final DoubleClickEvent doubleClickEvent) {
        Object[] objectArray = this.doubleClickListeners.getListeners();
        for (int i = 0; i < objectArray.length; ++i) {
            final IDoubleClickListener iDoubleClickListener = (IDoubleClickListener)objectArray[i];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    iDoubleClickListener.doubleClick(doubleClickEvent);
                }
            });
        }
    }

    protected void fireOpen(final OpenEvent openEvent) {
        Object[] objectArray = this.openListeners.getListeners();
        for (int i = 0; i < objectArray.length; ++i) {
            final IOpenListener iOpenListener = (IOpenListener)objectArray[i];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    iOpenListener.open(openEvent);
                }
            });
        }
    }

    protected void firePostSelectionChanged(final SelectionChangedEvent selectionChangedEvent) {
        Object[] objectArray = this.postSelectionChangedListeners.getListeners();
        for (int i = 0; i < objectArray.length; ++i) {
            final ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[i];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    iSelectionChangedListener.selectionChanged(selectionChangedEvent);
                }
            });
        }
    }

    public IElementComparer getComparer() {
        return this.comparer;
    }

    protected Object[] getFilteredChildren(Object object) {
        Object[] objectArray = this.getRawChildren(object);
        if (this.filters != null) {
            Iterator iterator = this.filters.iterator();
            while (iterator.hasNext()) {
                ViewerFilter viewerFilter = (ViewerFilter)iterator.next();
                objectArray = viewerFilter.filter((Viewer)this, object, objectArray);
            }
        }
        return objectArray;
    }

    public ViewerFilter[] getFilters() {
        if (this.filters == null) {
            return new ViewerFilter[0];
        }
        ViewerFilter[] viewerFilterArray = new ViewerFilter[this.filters.size()];
        this.filters.toArray(viewerFilterArray);
        return viewerFilterArray;
    }

    protected Item getItem(int n, int n2) {
        return null;
    }

    protected Object[] getRawChildren(Object object) {
        IStructuredContentProvider iStructuredContentProvider;
        Object[] objectArray = null;
        if (object != null && (iStructuredContentProvider = (IStructuredContentProvider)this.getContentProvider()) != null) {
            objectArray = iStructuredContentProvider.getElements(object);
            this.assertElementsNotNull(objectArray);
        }
        return objectArray != null ? objectArray : new Object[]{};
    }

    protected Object getRoot() {
        return this.getInput();
    }

    public ISelection getSelection() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return StructuredSelection.EMPTY;
        }
        List list = this.getSelectionFromWidget();
        return new StructuredSelection(list);
    }

    protected abstract List getSelectionFromWidget();

    protected Object[] getSortedChildren(Object object) {
        Object[] objectArray = this.getFilteredChildren(object);
        if (this.sorter != null) {
            objectArray = (Object[])objectArray.clone();
            this.sorter.sort(this, objectArray);
        }
        return objectArray;
    }

    public ViewerSorter getSorter() {
        if (this.sorter instanceof ViewerSorter) {
            return (ViewerSorter)this.sorter;
        }
        return null;
    }

    public ViewerComparator getComparator() {
        return this.sorter;
    }

    protected void handleDoubleSelect(SelectionEvent selectionEvent) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            ISelection iSelection;
            if (selectionEvent.item != null && selectionEvent.item.getData() != null) {
                iSelection = new StructuredSelection(selectionEvent.item.getData());
            } else {
                iSelection = this.getSelection();
                this.updateSelection(iSelection);
            }
            this.fireDoubleClick(new DoubleClickEvent(this, iSelection));
        }
    }

    protected void handleOpen(SelectionEvent selectionEvent) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            ISelection iSelection = this.getSelection();
            this.fireOpen(new OpenEvent(this, iSelection));
        }
    }

    protected void handleInvalidSelection(ISelection iSelection, ISelection iSelection2) {
        this.updateSelection(iSelection2);
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent(this, iSelection2);
        this.firePostSelectionChanged(selectionChangedEvent);
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
        Object[] objectArray = labelProviderChangedEvent.getElements();
        if (objectArray != null) {
            this.update(objectArray, (String[])null);
        } else {
            super.handleLabelProviderChanged(labelProviderChangedEvent);
        }
    }

    protected void handleSelect(SelectionEvent selectionEvent) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            this.updateSelection(this.getSelection());
        }
    }

    protected void handlePostSelect(SelectionEvent selectionEvent) {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent(this, this.getSelection());
        this.firePostSelectionChanged(selectionChangedEvent);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        OpenStrategy openStrategy = new OpenStrategy(control);
        openStrategy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!StructuredViewer.this.inChange) {
                    StructuredViewer.this.handleSelect(selectionEvent);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                StructuredViewer.this.handleDoubleSelect(selectionEvent);
            }
        });
        openStrategy.addPostSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StructuredViewer.this.handlePostSelect(selectionEvent);
            }
        });
        openStrategy.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent selectionEvent) {
                StructuredViewer.this.handleOpen(selectionEvent);
            }
        });
    }

    protected boolean hasFilters() {
        return this.filters != null && this.filters.size() > 0;
    }

    protected abstract void internalRefresh(Object var1);

    protected void internalRefresh(Object object, boolean bl) {
        this.internalRefresh(object);
    }

    protected void mapElement(Object object, Widget widget) {
        if (this.elementMap != null) {
            Object object2 = this.elementMap.get(object);
            if (object2 == null) {
                this.elementMap.put(object, widget);
            } else if (object2 instanceof Widget) {
                if (object2 != widget) {
                    this.elementMap.put(object, new Widget[]{(Widget)object2, widget});
                }
            } else {
                Widget[] widgetArray = (Widget[])object2;
                int n = Arrays.asList(widgetArray).indexOf(widget);
                if (n == -1) {
                    int n2 = widgetArray.length;
                    Widget[] widgetArray2 = widgetArray;
                    widgetArray = new Widget[n2 + 1];
                    System.arraycopy(widgetArray2, 0, widgetArray, 0, n2);
                    widgetArray[n2] = widget;
                    this.elementMap.put(object, widgetArray);
                }
            }
        }
    }

    protected boolean needsRefilter(Object object, String string) {
        if (this.sorter != null && this.sorter.isSorterProperty(object, string)) {
            return true;
        }
        if (this.filters != null) {
            int n = this.filters.size();
            for (int i = 0; i < n; ++i) {
                ViewerFilter viewerFilter = (ViewerFilter)this.filters.get(i);
                if (!viewerFilter.isFilterProperty(object, string)) continue;
                return true;
            }
        }
        return false;
    }

    CustomHashtable newHashtable(int n) {
        return new CustomHashtable(n, this.getComparer());
    }

    protected void preservingSelection(Runnable runnable) {
        this.preservingSelection(runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preservingSelection(Runnable runnable, boolean bl) {
        ISelection iSelection = null;
        try {
            ISelection iSelection2;
            iSelection = this.getSelection();
            this.restoreSelection = true;
            this.inChange = true;
            runnable.run();
            Object var5_4 = null;
            this.inChange = false;
            if (this.restoreSelection) {
                this.setSelectionToWidget(iSelection, bl);
            }
            if (!(iSelection2 = this.getSelection()).equals(iSelection)) {
                this.handleInvalidSelection(iSelection, iSelection2);
            }
        }
        catch (Throwable throwable) {
            ISelection iSelection3;
            Object var5_5 = null;
            this.inChange = false;
            if (this.restoreSelection) {
                this.setSelectionToWidget(iSelection, bl);
            }
            if (!(iSelection3 = this.getSelection()).equals(iSelection)) {
                this.handleInvalidSelection(iSelection, iSelection3);
            }
            throw throwable;
        }
    }

    public void refresh() {
        this.refresh(this.getRoot());
    }

    public void refresh(boolean bl) {
        this.refresh(this.getRoot(), bl);
    }

    public void refresh(final Object object) {
        this.preservingSelection(new Runnable(){

            public void run() {
                StructuredViewer.this.internalRefresh(object);
            }
        });
    }

    public void refresh(final Object object, final boolean bl) {
        this.preservingSelection(new Runnable(){

            public void run() {
                StructuredViewer.this.internalRefresh(object, bl);
            }
        });
    }

    protected final void refreshItem(Widget widget, Object object) {
        SafeRunnable.run(new UpdateItemSafeRunnable(widget, object, true));
    }

    public void removeOpenListener(IOpenListener iOpenListener) {
        this.openListeners.remove(iOpenListener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.postSelectionChangedListeners.remove(iSelectionChangedListener);
    }

    public void removeDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        this.doubleClickListeners.remove(iDoubleClickListener);
    }

    public void removeFilter(ViewerFilter viewerFilter) {
        Assert.isNotNull(viewerFilter);
        if (this.filters != null) {
            Iterator iterator = this.filters.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e != viewerFilter) continue;
                iterator.remove();
                this.refresh();
                if (this.filters.size() == 0) {
                    this.filters = null;
                }
                return;
            }
        }
    }

    public void setFilters(ViewerFilter[] viewerFilterArray) {
        if (viewerFilterArray.length == 0) {
            this.resetFilters();
        } else {
            this.filters = new ArrayList<ViewerFilter>(Arrays.asList(viewerFilterArray));
            this.refresh();
        }
    }

    public void resetFilters() {
        if (this.filters != null) {
            this.filters = null;
            this.refresh();
        }
    }

    public abstract void reveal(Object var1);

    public void setContentProvider(IContentProvider iContentProvider) {
        this.assertContentProviderType(iContentProvider);
        super.setContentProvider(iContentProvider);
    }

    protected void assertContentProviderType(IContentProvider iContentProvider) {
        Assert.isTrue(iContentProvider instanceof IStructuredContentProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInput(Object object) {
        this.unmapAllElements();
        super.setInput(object);
    }

    public void setSelection(ISelection iSelection, boolean bl) {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        if (!this.inChange) {
            this.setSelectionToWidget(iSelection, bl);
            ISelection iSelection2 = this.getSelection();
            this.updateSelection(iSelection2);
            this.firePostSelectionChanged(new SelectionChangedEvent(this, iSelection2));
        } else {
            this.restoreSelection = false;
            this.setSelectionToWidget(iSelection, bl);
        }
    }

    protected abstract void setSelectionToWidget(List var1, boolean var2);

    protected void setSelectionToWidget(ISelection iSelection, boolean bl) {
        if (iSelection instanceof IStructuredSelection) {
            this.setSelectionToWidget(((IStructuredSelection)iSelection).toList(), bl);
        } else {
            this.setSelectionToWidget((List)null, bl);
        }
    }

    public void setSorter(ViewerSorter viewerSorter) {
        if (this.sorter != viewerSorter) {
            this.sorter = viewerSorter;
            this.refresh();
        }
    }

    public void setComparator(ViewerComparator viewerComparator) {
        if (this.sorter != viewerComparator) {
            this.sorter = viewerComparator;
            this.refresh();
        }
    }

    public void setUseHashlookup(boolean bl) {
        Assert.isTrue(this.getInput() == null, "Can only enable the hash look up before input has been set");
        this.elementMap = bl ? this.newHashtable(13) : null;
    }

    public void setComparer(IElementComparer iElementComparer) {
        this.comparer = iElementComparer;
        if (this.elementMap != null) {
            this.elementMap = new CustomHashtable(this.elementMap, iElementComparer);
        }
    }

    public Widget testFindItem(Object object) {
        return this.findItem(object);
    }

    public Widget[] testFindItems(Object object) {
        return this.findItems(object);
    }

    protected void unmapAllElements() {
        if (this.elementMap != null) {
            this.elementMap = this.newHashtable(13);
        }
    }

    protected void unmapElement(Object object) {
        if (this.elementMap != null) {
            this.elementMap.remove(object);
        }
    }

    protected void unmapElement(Object object, Widget widget) {
        if (this.elementMap != null) {
            Object object2 = this.elementMap.get(object);
            if (object2 == null) {
                return;
            }
            if (object2 instanceof Widget) {
                if (widget == object2) {
                    this.elementMap.remove(object);
                }
            } else {
                Widget[] widgetArray = (Widget[])object2;
                int n = Arrays.asList(widgetArray).indexOf(widget);
                if (n == -1) {
                    return;
                }
                int n2 = widgetArray.length;
                if (n == 0) {
                    if (n2 == 1) {
                        this.elementMap.remove(object);
                    } else {
                        Widget[] widgetArray2 = new Widget[n2 - 1];
                        System.arraycopy(widgetArray, 1, widgetArray2, 0, n2 - 1);
                        this.elementMap.put(object, widgetArray2);
                    }
                } else {
                    Widget[] widgetArray3 = new Widget[n2 - 1];
                    System.arraycopy(widgetArray, 0, widgetArray3, 0, n);
                    System.arraycopy(widgetArray, n + 1, widgetArray3, n, n2 - n - 1);
                    this.elementMap.put(object, widgetArray3);
                }
            }
        }
    }

    public void update(Object[] objectArray, String[] stringArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.update(objectArray[i], stringArray);
        }
    }

    public void update(Object object, String[] stringArray) {
        Assert.isNotNull(object);
        Widget[] widgetArray = this.findItems(object);
        for (int i = 0; i < widgetArray.length; ++i) {
            this.internalUpdate(widgetArray[i], object, stringArray);
        }
    }

    protected void internalUpdate(Widget widget, Object object, String[] stringArray) {
        int n;
        boolean bl = false;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length && !(bl = this.needsRefilter(object, stringArray[n])); ++n) {
            }
        }
        if (bl) {
            this.preservingSelection(new Runnable(){

                public void run() {
                    StructuredViewer.this.internalRefresh(StructuredViewer.this.getRoot());
                }
            });
            return;
        }
        if (stringArray == null) {
            n = 1;
        } else {
            n = 0;
            IBaseLabelProvider iBaseLabelProvider = this.getLabelProvider();
            for (int i = 0; i < stringArray.length && (n = (int)(iBaseLabelProvider.isLabelProperty(object, stringArray[i]) ? 1 : 0)) == 0; ++i) {
            }
        }
        if (n != 0) {
            this.updateItem(widget, object);
        }
    }

    protected final void updateItem(Widget widget, Object object) {
        SafeRunnable.run(new UpdateItemSafeRunnable(widget, object, true));
    }

    protected void updateSelection(ISelection iSelection) {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent(this, iSelection);
        this.fireSelectionChanged(selectionChangedEvent);
    }

    protected boolean usingElementMap() {
        return this.elementMap != null;
    }

    public void setLabelProvider(IBaseLabelProvider iBaseLabelProvider) {
        this.colorAndFontCollector = iBaseLabelProvider instanceof IColorProvider || iBaseLabelProvider instanceof IFontProvider ? new ColorAndFontCollectorWithProviders(iBaseLabelProvider) : new ColorAndFontCollector();
        super.setLabelProvider(iBaseLabelProvider);
    }

    protected void buildLabel(ViewerLabel viewerLabel, Object object) {
        if (this.getLabelProvider() instanceof IViewerLabelProvider) {
            IViewerLabelProvider iViewerLabelProvider = (IViewerLabelProvider)this.getLabelProvider();
            iViewerLabelProvider.updateLabel(viewerLabel, object);
            this.colorAndFontCollector.setUsedDecorators();
            if (viewerLabel.hasNewBackground()) {
                this.colorAndFontCollector.setBackground(viewerLabel.getBackground());
            }
            if (viewerLabel.hasNewForeground()) {
                this.colorAndFontCollector.setForeground(viewerLabel.getForeground());
            }
            if (viewerLabel.hasNewFont()) {
                this.colorAndFontCollector.setFont(viewerLabel.getFont());
            }
            return;
        }
        if (this.getLabelProvider() instanceof ILabelProvider) {
            ILabelProvider iLabelProvider = (ILabelProvider)this.getLabelProvider();
            viewerLabel.setText(iLabelProvider.getText(object));
            viewerLabel.setImage(iLabelProvider.getImage(object));
        }
    }

    void buildLabel(ViewerLabel viewerLabel, Object object, IViewerLabelProvider iViewerLabelProvider) {
        iViewerLabelProvider.updateLabel(viewerLabel, object);
        this.colorAndFontCollector.setUsedDecorators();
        if (viewerLabel.hasNewBackground()) {
            this.colorAndFontCollector.setBackground(viewerLabel.getBackground());
        }
        if (viewerLabel.hasNewForeground()) {
            this.colorAndFontCollector.setForeground(viewerLabel.getForeground());
        }
        if (viewerLabel.hasNewFont()) {
            this.colorAndFontCollector.setFont(viewerLabel.getFont());
        }
    }

    void buildLabel(ViewerLabel viewerLabel, TreePath treePath, ITreePathLabelProvider iTreePathLabelProvider) {
        iTreePathLabelProvider.updateLabel(viewerLabel, treePath);
        this.colorAndFontCollector.setUsedDecorators();
        if (viewerLabel.hasNewBackground()) {
            this.colorAndFontCollector.setBackground(viewerLabel.getBackground());
        }
        if (viewerLabel.hasNewForeground()) {
            this.colorAndFontCollector.setForeground(viewerLabel.getForeground());
        }
        if (viewerLabel.hasNewFont()) {
            this.colorAndFontCollector.setFont(viewerLabel.getFont());
        }
    }

    void buildLabel(ViewerLabel viewerLabel, Object object, ILabelProvider iLabelProvider) {
        viewerLabel.setText(iLabelProvider.getText(object));
        viewerLabel.setImage(iLabelProvider.getImage(object));
    }

    protected ColorAndFontCollector getColorAndFontCollector() {
        return this.colorAndFontCollector;
    }

    protected void handleDispose(DisposeEvent disposeEvent) {
        super.handleDispose(disposeEvent);
        this.sorter = null;
        this.comparer = null;
        if (this.filters != null) {
            this.filters.clear();
        }
        this.elementMap = this.newHashtable(1);
        this.openListeners.clear();
        this.doubleClickListeners.clear();
        this.colorAndFontCollector.clear();
        this.postSelectionChangedListeners.clear();
    }

    protected class ColorAndFontCollector {
        Color foreground = null;
        Color background = null;
        Font font = null;
        boolean usedDecorators = false;

        public void clear() {
            this.foreground = null;
            this.background = null;
            this.font = null;
            this.usedDecorators = false;
        }

        public void setFontsAndColors(Object object) {
        }

        public void setUsedDecorators() {
            this.usedDecorators = true;
        }

        public void applyFontsAndColors(TableItem tableItem) {
            if (this.usedDecorators) {
                if (this.background != null) {
                    tableItem.setBackground(this.background);
                }
                if (this.foreground != null) {
                    tableItem.setForeground(this.foreground);
                }
                if (this.font != null) {
                    tableItem.setFont(this.font);
                }
            }
            this.clear();
        }

        public void applyFontsAndColors(TreeItem treeItem) {
            if (this.usedDecorators) {
                if (this.background != null) {
                    treeItem.setBackground(this.background);
                }
                if (this.foreground != null) {
                    treeItem.setForeground(this.foreground);
                }
                if (this.font != null) {
                    treeItem.setFont(this.font);
                }
            }
            this.clear();
        }

        public void applyFontsAndColors(TableTreeItem tableTreeItem) {
            if (this.usedDecorators) {
                if (this.background != null) {
                    tableTreeItem.setBackground(this.background);
                }
                if (this.foreground != null) {
                    tableTreeItem.setForeground(this.foreground);
                }
                if (this.font != null) {
                    tableTreeItem.setFont(this.font);
                }
            }
            this.clear();
        }

        public void setBackground(Color color) {
            this.background = color;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public void setForeground(Color color) {
            this.foreground = color;
        }
    }

    protected class ColorAndFontCollectorWithProviders
    extends ColorAndFontCollector {
        IColorProvider colorProvider;
        IFontProvider fontProvider;

        public ColorAndFontCollectorWithProviders(IBaseLabelProvider iBaseLabelProvider) {
            if (iBaseLabelProvider instanceof IColorProvider) {
                this.colorProvider = (IColorProvider)((Object)iBaseLabelProvider);
            }
            if (iBaseLabelProvider instanceof IFontProvider) {
                this.fontProvider = (IFontProvider)((Object)iBaseLabelProvider);
            }
        }

        public void setFontsAndColors(Object object) {
            if (this.fontProvider != null && this.font == null) {
                this.font = this.fontProvider.getFont(object);
            }
            if (this.colorProvider == null) {
                return;
            }
            if (this.background == null) {
                this.background = this.colorProvider.getBackground(object);
            }
            if (this.foreground == null) {
                this.foreground = this.colorProvider.getForeground(object);
            }
        }

        public void applyFontsAndColors(TableItem tableItem) {
            if (this.colorProvider == null) {
                if (this.usedDecorators) {
                    if (this.background != null) {
                        tableItem.setBackground(this.background);
                    }
                    if (this.foreground != null) {
                        tableItem.setForeground(this.foreground);
                    }
                }
            } else {
                tableItem.setBackground(this.background);
                tableItem.setForeground(this.foreground);
            }
            if (this.fontProvider == null) {
                if (this.usedDecorators && this.font != null) {
                    tableItem.setFont(this.font);
                }
            } else {
                tableItem.setFont(this.font);
            }
            this.clear();
        }

        public void applyFontsAndColors(TreeItem treeItem) {
            if (this.colorProvider == null) {
                if (this.usedDecorators) {
                    if (this.background != null) {
                        treeItem.setBackground(this.background);
                    }
                    if (this.foreground != null) {
                        treeItem.setForeground(this.foreground);
                    }
                }
            } else {
                treeItem.setBackground(this.background);
                treeItem.setForeground(this.foreground);
            }
            if (this.fontProvider == null) {
                if (this.usedDecorators && this.font != null) {
                    treeItem.setFont(this.font);
                }
            } else {
                treeItem.setFont(this.font);
            }
            this.clear();
        }

        public void applyFontsAndColors(TableTreeItem tableTreeItem) {
            if (this.colorProvider == null) {
                if (this.usedDecorators) {
                    if (this.background != null) {
                        tableTreeItem.setBackground(this.background);
                    }
                    if (this.foreground != null) {
                        tableTreeItem.setForeground(this.foreground);
                    }
                }
            } else {
                tableTreeItem.setBackground(this.background);
                tableTreeItem.setForeground(this.foreground);
            }
            if (this.fontProvider == null) {
                if (this.usedDecorators && this.font != null) {
                    tableTreeItem.setFont(this.font);
                }
            } else {
                tableTreeItem.setFont(this.font);
            }
            this.clear();
        }
    }

    class UpdateItemSafeRunnable
    extends SafeRunnable {
        private Widget widget;
        private Object element;
        private boolean fullMap;

        UpdateItemSafeRunnable(Widget widget, Object object, boolean bl) {
            this.widget = widget;
            this.element = object;
            this.fullMap = bl;
        }

        public void run() {
            StructuredViewer.this.doUpdateItem(this.widget, this.element, this.fullMap);
        }
    }
}

