/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableViewerRow
extends ViewerRow {
    private TableItem item;

    TableViewerRow(TableItem tableItem) {
        this.item = tableItem;
    }

    public Rectangle getBounds(int n) {
        return this.item.getBounds(n);
    }

    public Rectangle getBounds() {
        return this.item.getBounds();
    }

    public Widget getItem() {
        return this.item;
    }

    void setItem(TableItem tableItem) {
        this.item = tableItem;
    }

    public int getColumnCount() {
        return this.item.getParent().getColumnCount();
    }

    public Color getBackground(int n) {
        return this.item.getBackground(n);
    }

    public Font getFont(int n) {
        return this.item.getFont(n);
    }

    public Color getForeground(int n) {
        return this.item.getForeground(n);
    }

    public Image getImage(int n) {
        return this.item.getImage(n);
    }

    public String getText(int n) {
        return this.item.getText(n);
    }

    public void setBackground(int n, Color color) {
        this.item.setBackground(n, color);
    }

    public void setFont(int n, Font font) {
        this.item.setFont(n, font);
    }

    public void setForeground(int n, Color color) {
        this.item.setForeground(n, color);
    }

    public void setImage(int n, Image image) {
        Image image2 = this.item.getImage(n);
        if (image2 != image) {
            this.item.setImage(n, image);
        }
    }

    public void setText(int n, String string) {
        this.item.setText(n, string == null ? "" : string);
    }

    public Control getControl() {
        return this.item.getParent();
    }

    public ViewerRow getNeighbor(int n, boolean bl) {
        if (n == 1) {
            return this.getRowAbove();
        }
        if (n == 2) {
            return this.getRowBelow();
        }
        throw new IllegalArgumentException("Illegal value of direction argument.");
    }

    private ViewerRow getRowAbove() {
        int n = this.item.getParent().indexOf(this.item) - 1;
        if (n >= 0) {
            return new TableViewerRow(this.item.getParent().getItem(n));
        }
        return null;
    }

    private ViewerRow getRowBelow() {
        TableItem tableItem;
        int n = this.item.getParent().indexOf(this.item) + 1;
        if (n < this.item.getParent().getItemCount() && (tableItem = this.item.getParent().getItem(n)) != null) {
            return new TableViewerRow(tableItem);
        }
        return null;
    }

    public TreePath getTreePath() {
        return new TreePath(new Object[]{this.item.getData()});
    }

    public Object clone() {
        return new TableViewerRow(this.item);
    }

    public Object getElement() {
        return this.item.getData();
    }
}

