/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class ViewerCell {
    private int columnIndex;
    private ViewerRow row;
    private Object element;
    public static int ABOVE = 1;
    public static int BELOW = 2;
    public static int LEFT = 4;
    public static int RIGHT = 8;

    ViewerCell(ViewerRow viewerRow, int n, Object object) {
        this.row = viewerRow;
        this.columnIndex = n;
        this.element = object;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Rectangle getBounds() {
        return this.row.getBounds(this.columnIndex);
    }

    public Object getElement() {
        if (this.element != null) {
            return this.element;
        }
        return this.row.getElement();
    }

    public String getText() {
        return this.row.getText(this.columnIndex);
    }

    public Image getImage() {
        return this.row.getImage(this.columnIndex);
    }

    public void setBackground(Color color) {
        this.row.setBackground(this.columnIndex, color);
    }

    public void setForeground(Color color) {
        this.row.setForeground(this.columnIndex, color);
    }

    public void setFont(Font font) {
        this.row.setFont(this.columnIndex, font);
    }

    public void setText(String string) {
        this.row.setText(this.columnIndex, string);
    }

    public void setImage(Image image) {
        this.row.setImage(this.columnIndex, image);
    }

    void setColumn(int n) {
        this.columnIndex = n;
    }

    void update(ViewerRow viewerRow, int n, Object object) {
        this.row = viewerRow;
        this.columnIndex = n;
        this.element = object;
    }

    public Widget getItem() {
        return this.row.getItem();
    }

    public Control getControl() {
        return this.row.getControl();
    }

    public ViewerCell getNeighbor(int n, boolean bl) {
        int n2;
        ViewerRow viewerRow = (n & ABOVE) == ABOVE ? this.row.getNeighbor(1, bl) : ((n & BELOW) == BELOW ? this.row.getNeighbor(2, bl) : this.row);
        if (viewerRow != null && (n2 = (n & LEFT) == LEFT ? this.getColumnIndex() - 1 : ((n & RIGHT) == RIGHT ? this.getColumnIndex() + 1 : this.getColumnIndex())) >= 0 && n2 < viewerRow.getColumnCount()) {
            return viewerRow.getCell(n2);
        }
        return null;
    }

    public ViewerRow getViewerRow() {
        return this.row;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.columnIndex;
        n = 31 * n + (this.row == null ? 0 : this.row.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ViewerCell viewerCell = (ViewerCell)object;
        if (this.columnIndex != viewerCell.columnIndex) {
            return false;
        }
        return !(this.row == null ? viewerCell.row != null : !this.row.equals(viewerCell.row));
    }
}

