/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

class WrappedViewerLabelProvider
extends ColumnLabelProvider {
    private static ILabelProvider defaultLabelProvider = new LabelProvider();
    private ILabelProvider labelProvider = defaultLabelProvider;
    private IColorProvider colorProvider;
    private IFontProvider fontProvider;
    private IViewerLabelProvider viewerLabelProvider;
    private ITreePathLabelProvider treePathLabelProvider;

    public WrappedViewerLabelProvider(IBaseLabelProvider iBaseLabelProvider) {
        this.setProviders(iBaseLabelProvider);
    }

    public void setProviders(Object object) {
        if (object instanceof ITreePathLabelProvider) {
            this.treePathLabelProvider = (ITreePathLabelProvider)object;
        }
        if (object instanceof IViewerLabelProvider) {
            this.viewerLabelProvider = (IViewerLabelProvider)object;
        }
        if (object instanceof ILabelProvider) {
            this.labelProvider = (ILabelProvider)object;
        }
        if (object instanceof IColorProvider) {
            this.colorProvider = (IColorProvider)object;
        }
        if (object instanceof IFontProvider) {
            this.fontProvider = (IFontProvider)object;
        }
    }

    public Font getFont(Object object) {
        if (this.fontProvider == null) {
            return null;
        }
        return this.fontProvider.getFont(object);
    }

    public Color getBackground(Object object) {
        if (this.colorProvider == null) {
            return null;
        }
        return this.colorProvider.getBackground(object);
    }

    public String getText(Object object) {
        return this.getLabelProvider().getText(object);
    }

    public Image getImage(Object object) {
        return this.getLabelProvider().getImage(object);
    }

    public Color getForeground(Object object) {
        if (this.colorProvider == null) {
            return null;
        }
        return this.colorProvider.getForeground(object);
    }

    ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    IColorProvider getColorProvider() {
        return this.colorProvider;
    }

    IFontProvider getFontProvider() {
        return this.fontProvider;
    }

    public void update(ViewerCell viewerCell) {
        Object object = viewerCell.getElement();
        if (this.viewerLabelProvider == null && this.treePathLabelProvider == null) {
            viewerCell.setText(this.getText(object));
            Image image = this.getImage(object);
            viewerCell.setImage(image);
            if (this.colorProvider != null) {
                viewerCell.setBackground(this.getBackground(object));
                viewerCell.setForeground(this.getForeground(object));
            }
            if (this.fontProvider != null) {
                viewerCell.setFont(this.getFont(object));
            }
            return;
        }
        ViewerLabel viewerLabel = new ViewerLabel(viewerCell.getText(), viewerCell.getImage());
        if (this.treePathLabelProvider != null) {
            TreePath treePath = viewerCell.getViewerRow().getTreePath();
            Assert.isNotNull(treePath);
            this.treePathLabelProvider.updateLabel(viewerLabel, treePath);
        } else if (this.viewerLabelProvider != null) {
            this.viewerLabelProvider.updateLabel(viewerLabel, object);
        }
        if (!viewerLabel.hasNewForeground() && this.colorProvider != null) {
            viewerLabel.setForeground(this.getForeground(object));
        }
        if (!viewerLabel.hasNewBackground() && this.colorProvider != null) {
            viewerLabel.setBackground(this.getBackground(object));
        }
        if (!viewerLabel.hasNewFont() && this.fontProvider != null) {
            viewerLabel.setFont(this.getFont(object));
        }
        this.applyViewerLabel(viewerCell, viewerLabel);
    }

    private void applyViewerLabel(ViewerCell viewerCell, ViewerLabel viewerLabel) {
        if (viewerLabel.hasNewText()) {
            viewerCell.setText(viewerLabel.getText());
        }
        if (viewerLabel.hasNewImage()) {
            viewerCell.setImage(viewerLabel.getImage());
        }
        if (this.colorProvider != null || viewerLabel.hasNewBackground()) {
            viewerCell.setBackground(viewerLabel.getBackground());
        }
        if (this.colorProvider != null || viewerLabel.hasNewForeground()) {
            viewerCell.setForeground(viewerLabel.getForeground());
        }
        if (this.fontProvider != null || viewerLabel.hasNewFont()) {
            viewerCell.setFont(viewerLabel.getFont());
        }
    }
}

