/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;
    private byte[] writeBuffer = new byte[8];

    public final int size() {
        return this.written;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    private void incCount(int n) {
        int n2 = this.written + n;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        this.written = n2;
    }

    public synchronized void write(int n) throws IOException {
        this.out.write(n);
        this.incCount(1);
    }

    public final void writeByte(int n) throws IOException {
        this.out.write(n);
        this.incCount(1);
    }

    public final void writeChar(int n) throws IOException {
        this.out.write(n >>> 8 & 0xFF);
        this.out.write(n >>> 0 & 0xFF);
        this.incCount(2);
    }

    public final void writeInt(int n) throws IOException {
        this.out.write(n >>> 24 & 0xFF);
        this.out.write(n >>> 16 & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.out.write(n >>> 0 & 0xFF);
        this.incCount(4);
    }

    public final void writeShort(int n) throws IOException {
        this.out.write(n >>> 8 & 0xFF);
        this.out.write(n >>> 0 & 0xFF);
        this.incCount(2);
    }

    public final void writeLong(long l) throws IOException {
        this.writeBuffer[0] = (byte)(l >>> 56);
        this.writeBuffer[1] = (byte)(l >>> 48);
        this.writeBuffer[2] = (byte)(l >>> 40);
        this.writeBuffer[3] = (byte)(l >>> 32);
        this.writeBuffer[4] = (byte)(l >>> 24);
        this.writeBuffer[5] = (byte)(l >>> 16);
        this.writeBuffer[6] = (byte)(l >>> 8);
        this.writeBuffer[7] = (byte)(l >>> 0);
        this.out.write(this.writeBuffer, 0, 8);
        this.incCount(8);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.out.write(bl ? 1 : 0);
        this.incCount(1);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.incCount(n2);
    }

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.out.write((byte)string.charAt(i));
        }
        this.incCount(n);
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.out.write(c >>> 8 & 0xFF);
            this.out.write(c >>> 0 & 0xFF);
        }
        this.incCount(n * 2);
    }

    public final void writeUTF(String string) throws IOException {
        DataOutputStream.writeUTF(string, this);
    }

    static int writeUTF(String string, DataOutput dataOutput) throws IOException {
        char c;
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        int n3 = 0;
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] byArray = new byte[n2 + 2];
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 0 & 0xFF);
        for (int i = 0; i < n; ++i) {
            c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
            byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        dataOutput.write(byArray);
        return n2 + 2;
    }
}

