/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import sun.nio.ch.FileChannelImpl;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;
    private FileChannel channel = null;
    private boolean append = false;

    static {
        FileOutputStream.initIDs();
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
        this.close0();
    }

    private native void close0() throws IOException;

    /*
     * Enabled aggressive block sorting
     */
    protected void finalize() throws IOException {
        if (this.fd == null) return;
        if (this.fd != FileDescriptor.out) {
            if (this.fd != FileDescriptor.err) {
                this.close();
                return;
            }
        }
        this.flush();
    }

    private static native void initIDs();

    public native void write(int var1) throws IOException;

    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2);
    }

    private native void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean bl) throws FileNotFoundException {
        String string = file != null ? file.getPath() : null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.fd = new FileDescriptor();
        this.append = bl;
        if (bl) {
            this.openAppend(string);
        } else {
            this.open(string);
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    public FileOutputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkWrite(fileDescriptor);
        }
        this.fd = fileDescriptor;
    }

    public FileOutputStream(String string) throws FileNotFoundException {
        this(string != null ? new File(string) : null, false);
    }

    private native void open(String var1) throws FileNotFoundException;

    private native void openAppend(String var1) throws FileNotFoundException;

    public FileOutputStream(String string, boolean bl) throws FileNotFoundException {
        this(string != null ? new File(string) : null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.fd, false, true, this, this.append);
            }
            return this.channel;
        }
    }
}

