/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Reader {
    protected Object lock;
    private static final int maxSkipBufferSize = 8192;
    private char[] skipBuffer = null;

    public int read() throws IOException {
        char[] cArray = new char[1];
        if (this.read(cArray, 0, 1) == -1) {
            return -1;
        }
        return cArray[0];
    }

    protected Reader() {
        this.lock = this;
    }

    public abstract void close() throws IOException;

    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public boolean ready() throws IOException {
        return false;
    }

    public void mark(int n) throws IOException {
        throw new IOException("mark() not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        int n = (int)Math.min(l, 8192L);
        Object object = this.lock;
        synchronized (object) {
            long l2;
            int n2;
            if (this.skipBuffer == null || this.skipBuffer.length < n) {
                this.skipBuffer = new char[n];
            }
            for (l2 = l; l2 > 0L && (n2 = this.read(this.skipBuffer, 0, (int)Math.min(l2, (long)n))) != -1; l2 -= (long)n2) {
            }
            return l - l2;
        }
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    protected Reader(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.lock = object;
    }
}

