/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.net.Inet4Address;
import java.net.InetAddress;

public final class Inet6Address
extends InetAddress {
    static final int INADDRSZ = 16;
    private transient int cached_scope_id = 0;
    byte[] ipaddress;
    private static final long serialVersionUID = 6880410070516793377L;
    private static final int INT16SZ = 2;

    public int hashCode() {
        if (this.ipaddress != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < 16) {
                int n3 = 0;
                for (int i = 0; i < 4 && n2 < 16; ++i, ++n2) {
                    n3 = (n3 << 8) + this.ipaddress[n2];
                }
                n += n3;
            }
            return n;
        }
        return 0;
    }

    static {
        Inet6Address.init();
    }

    Inet6Address() {
        this.hostName = null;
        this.ipaddress = new byte[16];
        this.family = 2;
    }

    private static native void init();

    public boolean isAnyLocalAddress() {
        byte by = 0;
        for (int i = 0; i < 16; ++i) {
            by = (byte)(by | this.ipaddress[i]);
        }
        return by == 0;
    }

    public boolean isIPv4CompatibleAddress() {
        return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0 && this.ipaddress[4] == 0 && this.ipaddress[5] == 0 && this.ipaddress[6] == 0 && this.ipaddress[7] == 0 && this.ipaddress[8] == 0 && this.ipaddress[9] == 0 && this.ipaddress[10] == 0 && this.ipaddress[11] == 0;
    }

    public boolean isLinkLocalAddress() {
        return (this.ipaddress[0] & 0xFF) == 254 && (this.ipaddress[1] & 0xC0) == 128;
    }

    public boolean isLoopbackAddress() {
        byte by = 0;
        for (int i = 0; i < 15; ++i) {
            by = (byte)(by | this.ipaddress[i]);
        }
        return by == 0 && this.ipaddress[15] == 1;
    }

    public boolean isMCGlobal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 14;
    }

    public boolean isMCLinkLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 2;
    }

    public boolean isMCNodeLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 1;
    }

    public boolean isMCOrgLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 8;
    }

    public boolean isMCSiteLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 5;
    }

    public boolean isMulticastAddress() {
        return (this.ipaddress[0] & 0xFF) == 255;
    }

    public boolean isSiteLocalAddress() {
        return (this.ipaddress[0] & 0xFF) == 254 && (this.ipaddress[1] & 0xC0) == 192;
    }

    public byte[] getAddress() {
        return (byte[])this.ipaddress.clone();
    }

    static boolean isIPv4MappedAddress(byte[] byArray) {
        if (byArray.length < 16) {
            return false;
        }
        return byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0 && byArray[7] == 0 && byArray[8] == 0 && byArray[9] == 0 && byArray[10] == -1 && byArray[11] == -1;
    }

    static byte[] convertFromIPv4MappedAddress(byte[] byArray) {
        if (Inet6Address.isIPv4MappedAddress(byArray)) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 12, byArray2, 0, 4);
            return byArray2;
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.ipaddress = (byte[])this.ipaddress.clone();
        if (this.ipaddress.length != 16) {
            throw new InvalidObjectException("invalid address length: " + this.ipaddress.length);
        }
        if (this.family != 2) {
            throw new InvalidObjectException("invalid address family type");
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Inet6Address)) {
            return false;
        }
        Inet6Address inet6Address = (Inet6Address)object;
        for (int i = 0; i < 16; ++i) {
            if (this.ipaddress[i] == inet6Address.ipaddress[i]) continue;
            return false;
        }
        return true;
    }

    public String getHostAddress() {
        return Inet6Address.numericToTextFormat(this.ipaddress);
    }

    static byte[] textToNumericFormat(String string) {
        int n;
        if (string.length() == 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[16];
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        if (cArray[n3] == ':' && cArray[++n3] != ':') {
            return null;
        }
        int n5 = n3;
        boolean bl = false;
        int n6 = 0;
        while (n3 < cArray.length) {
            char c;
            if ((n = Character.digit(c = cArray[n3++], 16)) != -1) {
                n6 <<= 4;
                if ((n6 |= n) > 65535) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (c == ':') {
                n5 = n3;
                if (!bl) {
                    if (n2 != -1) {
                        return null;
                    }
                    n2 = n4;
                    continue;
                }
                if (n3 == cArray.length) {
                    return null;
                }
                if (n4 + 2 > 16) {
                    return null;
                }
                byArray[n4++] = (byte)(n6 >> 8 & 0xFF);
                byArray[n4++] = (byte)(n6 & 0xFF);
                bl = false;
                n6 = 0;
                continue;
            }
            if (c == '.' && n4 + 4 <= 16) {
                byte[] byArray2 = Inet4Address.textToNumericFormat(string.substring(n5));
                if (byArray2 == null) {
                    return null;
                }
                for (int i = 0; i < 4; ++i) {
                    byArray[n4++] = byArray2[i];
                }
                bl = false;
                break;
            }
            return null;
        }
        if (bl) {
            if (n4 + 2 > 16) {
                return null;
            }
            byArray[n4++] = (byte)(n6 >> 8 & 0xFF);
            byArray[n4++] = (byte)(n6 & 0xFF);
        }
        if (n2 != -1) {
            n = n4 - n2;
            if (n4 == 16) {
                return null;
            }
            for (n3 = 1; n3 <= n; ++n3) {
                byArray[16 - n3] = byArray[n2 + n - n3];
                byArray[n2 + n - n3] = 0;
            }
            n4 = 16;
        }
        if (n4 != 16) {
            return null;
        }
        byte[] byArray3 = Inet6Address.convertFromIPv4MappedAddress(byArray);
        if (byArray3 != null) {
            return byArray3;
        }
        return byArray;
    }

    Inet6Address(String string, byte[] byArray) {
        this.hostName = string;
        if (byArray.length == 16) {
            this.family = 2;
            this.ipaddress = (byte[])byArray.clone();
        }
    }

    static String numericToTextFormat(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(39);
        for (int i = 0; i < 8; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i << 1] << 8 & 0xFF00 | byArray[(i << 1) + 1] & 0xFF));
            if (i >= 7) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }
}

