/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocketTimeoutException;
import java.net.SocksConsts;
import java.net.SocksSocketImpl;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.security.action.GetPropertyAction;

class SocksSocketImplFactory
implements SocketImplFactory,
SocksConsts {
    private String server;
    private int port = -1;
    private boolean useV4 = false;

    private synchronized void checkProps() {
        boolean bl = false;
        int n = 1080;
        String string = null;
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("socksProxyHost"));
        string = (String)AccessController.doPrivileged(new GetPropertyAction("socksProxyPort"));
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = 1080;
            }
        }
        if (string2 != null && !string2.equals(this.server)) {
            this.server = string2;
            bl = true;
        }
        if (n != this.port) {
            this.port = n;
            bl = true;
        }
        if (bl) {
            this.guessVersion();
        }
    }

    private void guessVersion() {
        Socket socket;
        try {
            socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Socket socket = new Socket(new PlainSocketImpl());
                    socket.connect(new InetSocketAddress(SocksSocketImplFactory.this.server, SocksSocketImplFactory.this.port));
                    return socket;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            socket.setSoTimeout(1000);
            outputStream = socket.getOutputStream();
            inputStream = socket.getInputStream();
            outputStream.write(5);
            outputStream.write(2);
            outputStream.write(0);
            outputStream.write(2);
            outputStream.flush();
            int n = inputStream.read();
            if (n == 5) {
                this.useV4 = false;
                n = inputStream.read();
            } else {
                this.useV4 = true;
            }
            inputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.useV4 = true;
            try {
                inputStream.close();
                outputStream.close();
                socket.close();
            }
            catch (Exception exception) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    SocksSocketImplFactory(String string, int n) {
        this.server = string;
        this.port = n == -1 ? 1080 : n;
        this.guessVersion();
    }

    SocksSocketImplFactory(String string, int n, boolean bl) {
        this.server = string;
        this.port = n == -1 ? 1080 : n;
        this.useV4 = bl;
    }

    public SocketImpl createSocketImpl() {
        this.checkProps();
        SocksSocketImpl socksSocketImpl = new SocksSocketImpl(this.server, this.port);
        if (this.useV4) {
            socksSocketImpl.setV4();
        }
        return socksSocketImpl;
    }
}

