/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.HeapByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;

public abstract class ByteBuffer
extends Buffer
implements Comparable {
    final byte[] hb;
    final int offset;
    boolean isReadOnly;
    boolean bigEndian = true;
    boolean nativeByteOrder = Bits.byteOrder() == ByteOrder.BIG_ENDIAN;

    public abstract byte get();

    public abstract char getChar();

    public abstract double getDouble();

    public abstract float getFloat();

    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public abstract int getInt();

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + this.get(i);
        }
        return n;
    }

    public abstract long getLong();

    public abstract short getShort();

    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public abstract boolean isDirect();

    public final byte[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    abstract byte _get(int var1);

    public abstract byte get(int var1);

    public abstract char getChar(int var1);

    public abstract double getDouble(int var1);

    public abstract float getFloat(int var1);

    public abstract int getInt(int var1);

    public abstract long getLong(int var1);

    public abstract short getShort(int var1);

    abstract void _put(int var1, byte var2);

    ByteBuffer(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null, 0);
    }

    ByteBuffer(int n, int n2, int n3, int n4, byte[] byArray, int n5) {
        super(n, n2, n3, n4);
        this.hb = byArray;
        this.offset = n5;
    }

    public int compareTo(Object object) {
        ByteBuffer byteBuffer = (ByteBuffer)object;
        int n = this.position() + Math.min(this.remaining(), byteBuffer.remaining());
        int n2 = this.position();
        int n3 = byteBuffer.position();
        while (n2 < n) {
            byte by;
            byte by2 = this.get(n2);
            if (by2 != (by = byteBuffer.get(n3)) && (by2 == by2 || by == by)) {
                if (by2 < by) {
                    return -1;
                }
                return 1;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - byteBuffer.remaining();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer byteBuffer = (ByteBuffer)object;
        if (this.remaining() != byteBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = byteBuffer.limit() - 1;
        while (n2 >= n) {
            byte by;
            byte by2 = this.get(n2);
            if (by2 != (by = byteBuffer.get(n3)) && (by2 == by2 || by == by)) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public abstract ByteBuffer asReadOnlyBuffer();

    public abstract ByteBuffer compact();

    public abstract ByteBuffer duplicate();

    public abstract ByteBuffer slice();

    public abstract ByteBuffer put(byte var1);

    public abstract ByteBuffer putChar(char var1);

    public abstract ByteBuffer putDouble(double var1);

    public abstract ByteBuffer putFloat(float var1);

    public static ByteBuffer allocate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapByteBuffer(n, n);
    }

    public static ByteBuffer allocateDirect(int n) {
        return new DirectByteBuffer(n);
    }

    public abstract ByteBuffer putInt(int var1);

    public abstract ByteBuffer put(int var1, byte var2);

    public abstract ByteBuffer putChar(int var1, char var2);

    public abstract ByteBuffer putDouble(int var1, double var2);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract ByteBuffer putLong(int var1, long var2);

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract ByteBuffer putLong(long var1);

    public abstract ByteBuffer putShort(short var1);

    public ByteBuffer get(byte[] byArray) {
        return this.get(byArray, 0, byArray.length);
    }

    public final ByteBuffer put(byte[] byArray) {
        return this.put(byArray, 0, byArray.length);
    }

    public static ByteBuffer wrap(byte[] byArray) {
        return ByteBuffer.wrap(byArray, 0, byArray.length);
    }

    public ByteBuffer get(byte[] byArray, int n, int n2) {
        ByteBuffer.checkBounds(n, n2, byArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            byArray[i] = this.get();
        }
        return this;
    }

    public ByteBuffer put(byte[] byArray, int n, int n2) {
        ByteBuffer.checkBounds(n, n2, byArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.put(byArray[i]);
        }
        return this;
    }

    public static ByteBuffer wrap(byte[] byArray, int n, int n2) {
        try {
            return new HeapByteBuffer(byArray, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public final ByteOrder order() {
        return this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public abstract CharBuffer asCharBuffer();

    public abstract DoubleBuffer asDoubleBuffer();

    public abstract FloatBuffer asFloatBuffer();

    public abstract IntBuffer asIntBuffer();

    public abstract LongBuffer asLongBuffer();

    public abstract ShortBuffer asShortBuffer();

    public ByteBuffer put(ByteBuffer byteBuffer) {
        if (byteBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n = byteBuffer.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(byteBuffer.get());
        }
        return this;
    }

    public final ByteBuffer order(ByteOrder byteOrder) {
        this.bigEndian = byteOrder == ByteOrder.BIG_ENDIAN;
        this.nativeByteOrder = this.bigEndian == (Bits.byteOrder() == ByteOrder.BIG_ENDIAN);
        return this;
    }
}

