/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectLongBufferRS;
import java.nio.LongBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectLongBufferS
extends LongBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe;
    protected static final boolean unaligned;
    protected Object viewedBuffer = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public long address() {
        return this.address;
    }

    public long get() {
        return Bits.swap(unsafe.getLong(this.ix(this.nextGetIndex())));
    }

    static {
        $assertionsDisabled = !DirectLongBufferS.class.desiredAssertionStatus();
        unsafe = Bits.unsafe();
        unaligned = Bits.unaligned();
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public long get(int n) {
        return Bits.swap(unsafe.getLong(this.ix(this.checkIndex(n))));
    }

    private long ix(int n) {
        return this.address + (long)(n << 3);
    }

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public LongBuffer asReadOnlyBuffer() {
        return new DirectLongBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public LongBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        if (!$assertionsDisabled && n > n2) {
            throw new AssertionError();
        }
        int n3 = n <= n2 ? n2 - n : 0;
        unsafe.copyMemory(this.ix(n), this.ix(0), n3 << 3);
        this.position(n3);
        this.limit(this.capacity());
        return this;
    }

    public LongBuffer duplicate() {
        return new DirectLongBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public LongBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        if (!$assertionsDisabled && n > n2) {
            throw new AssertionError();
        }
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 3;
        return new DirectLongBufferS(this, -1, 0, n3, n3, n4);
    }

    public LongBuffer put(int n, long l) {
        unsafe.putLong(this.ix(this.checkIndex(n)), Bits.swap(l));
        return this;
    }

    public LongBuffer put(long l) {
        unsafe.putLong(this.ix(this.nextPutIndex()), Bits.swap(l));
        return this;
    }

    public LongBuffer get(long[] lArray, int n, int n2) {
        if (n2 << 3 > 6) {
            int n3;
            DirectLongBufferS.checkBounds(n, n2, lArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            if (!$assertionsDisabled && n4 > n5) {
                throw new AssertionError();
            }
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToLongArray(this.ix(n4), lArray, n << 3, n2 << 3);
            } else {
                Bits.copyToByteArray(this.ix(n4), lArray, n << 3, n2 << 3);
            }
            this.position(n4 + n2);
        } else {
            super.get(lArray, n, n2);
        }
        return this;
    }

    public LongBuffer put(long[] lArray, int n, int n2) {
        if (n2 << 3 > 6) {
            int n3;
            DirectLongBufferS.checkBounds(n, n2, lArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            if (!$assertionsDisabled && n4 > n5) {
                throw new AssertionError();
            }
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromLongArray(lArray, n << 3, this.ix(n4), n2 << 3);
            } else {
                Bits.copyFromByteArray(lArray, n << 3, this.ix(n4), n2 << 3);
            }
            this.position(n4 + n2);
        } else {
            super.put(lArray, n, n2);
        }
        return this;
    }

    public Cleaner cleaner() {
        return null;
    }

    DirectLongBufferS(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + (long)n5;
        this.viewedBuffer = directBuffer;
    }

    public LongBuffer put(LongBuffer longBuffer) {
        if (longBuffer instanceof DirectLongBufferS) {
            int n;
            if (longBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectLongBufferS directLongBufferS = (DirectLongBufferS)longBuffer;
            int n2 = directLongBufferS.position();
            int n3 = directLongBufferS.limit();
            if (!$assertionsDisabled && n2 > n3) {
                throw new AssertionError();
            }
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw new AssertionError();
            }
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directLongBufferS.ix(n2), this.ix(n5), n4 << 3);
            directLongBufferS.position(n2 + n4);
            this.position(n5 + n4);
        } else if (!longBuffer.isDirect()) {
            int n = longBuffer.position();
            int n8 = longBuffer.limit();
            if (!$assertionsDisabled && n > n8) {
                throw new AssertionError();
            }
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(longBuffer.hb, longBuffer.offset + n, n9);
            longBuffer.position(n + n9);
        } else {
            super.put(longBuffer);
        }
        return this;
    }
}

