/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.IOException;
import java.nio.channels.FileChannel;

public abstract class FileLock {
    private final FileChannel channel;
    private final long position;
    private final long size;
    private final boolean shared;

    public final long position() {
        return this.position;
    }

    public final long size() {
        return this.size;
    }

    public abstract void release() throws IOException;

    public final boolean isShared() {
        return this.shared;
    }

    public abstract boolean isValid();

    public final boolean overlaps(long l, long l2) {
        if (l + l2 <= this.position) {
            return false;
        }
        return this.position + this.size > l;
    }

    public final String toString() {
        return this.getClass().getName() + "[" + this.position + ":" + this.size + " " + (this.shared ? "shared" : "exclusive") + " " + (this.isValid() ? "valid" : "invalid") + "]";
    }

    public final FileChannel channel() {
        return this.channel;
    }

    protected FileLock(FileChannel fileChannel, long l, long l2, boolean bl) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (l + l2 < 0L) {
            throw new IllegalArgumentException("Negative position + size");
        }
        this.channel = fileChannel;
        this.position = l;
        this.size = l2;
        this.shared = bl;
    }
}

