/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Enumeration;
import java.util.Random;
import sun.security.provider.Sun;

public class SecureRandom
extends Random {
    private Provider provider = null;
    private SecureRandomSpi secureRandomSpi = null;
    private static SecureRandom seedGenerator = null;
    static final long serialVersionUID = 4940670005562187L;
    private byte[] state;
    private MessageDigest digest = null;
    private byte[] randomBytes;
    private int randomBytesUsed;
    private long counter;

    public SecureRandom() {
        super(0L);
        String string = SecureRandom.getPrngAlgorithm();
        if (string == null) {
            this.secureRandomSpi = new sun.security.provider.SecureRandom();
            this.provider = new Sun();
        } else {
            try {
                SecureRandom secureRandom = SecureRandom.getInstance(string);
                this.secureRandomSpi = secureRandom.getSecureRandomSpi();
                this.provider = secureRandom.getProvider();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
    }

    protected final int next(int n) {
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        this.nextBytes(byArray);
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (byArray[i] & 0xFF);
        }
        return n3 >>> n2 * 8 - n;
    }

    public byte[] generateSeed(int n) {
        return this.secureRandomSpi.engineGenerateSeed(n);
    }

    public static byte[] getSeed(int n) {
        if (seedGenerator == null) {
            seedGenerator = new SecureRandom();
        }
        return seedGenerator.generateSeed(n);
    }

    public void setSeed(long l) {
        if (l != 0L) {
            this.secureRandomSpi.engineSetSeed(SecureRandom.longToByteArray(l));
        }
    }

    private static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
        return byArray;
    }

    public SecureRandom(byte[] byArray) {
        super(0L);
        String string = SecureRandom.getPrngAlgorithm();
        if (string == null) {
            this.secureRandomSpi = new sun.security.provider.SecureRandom();
            this.provider = new Sun();
            this.secureRandomSpi.engineSetSeed(byArray);
        } else {
            try {
                SecureRandom secureRandom = SecureRandom.getInstance(string);
                this.secureRandomSpi = secureRandom.getSecureRandomSpi();
                this.provider = secureRandom.getProvider();
                this.secureRandomSpi.engineSetSeed(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
    }

    public synchronized void nextBytes(byte[] byArray) {
        this.secureRandomSpi.engineNextBytes(byArray);
    }

    public synchronized void setSeed(byte[] byArray) {
        this.secureRandomSpi.engineSetSeed(byArray);
    }

    private static String getPrngAlgorithm() {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            Enumeration enumeration = providerArray[i].propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith("SecureRandom.") || string.indexOf(32) >= 0) continue;
                int n = string.indexOf(".", 0);
                return string.substring(n + 1);
            }
        }
        return null;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    SecureRandomSpi getSecureRandomSpi() {
        return this.secureRandomSpi;
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        super(0L);
        this.secureRandomSpi = secureRandomSpi;
        this.provider = provider;
    }

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = Security.getImpl(string, "SecureRandom", (String)null);
            return new SecureRandom((SecureRandomSpi)objectArray[0], (Provider)objectArray[1]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "SecureRandom", string2);
        return new SecureRandom((SecureRandomSpi)objectArray[0], (Provider)objectArray[1]);
    }

    public static SecureRandom getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "SecureRandom", provider);
        return new SecureRandom((SecureRandomSpi)objectArray[0], (Provider)objectArray[1]);
    }
}

