/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Extension;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.x509.X509CRLImpl;

public abstract class X509CRL
extends CRL
implements X509Extension {
    private transient X500Principal issuerPrincipal;

    public abstract int getVersion();

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = X509CRLImpl.getEncodedInternal(this);
            for (int i = 1; i < byArray.length; ++i) {
                n += byArray[i] * i;
            }
            return n;
        }
        catch (CRLException cRLException) {
            return n;
        }
    }

    protected X509CRL() {
        super("X.509");
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract byte[] getSigAlgParams();

    public abstract byte[] getSignature();

    public abstract byte[] getTBSCertList() throws CRLException;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRL)) {
            return false;
        }
        try {
            byte[] byArray = X509CRLImpl.getEncodedInternal(this);
            byte[] byArray2 = X509CRLImpl.getEncodedInternal((X509CRL)object);
            return Arrays.equals(byArray, byArray2);
        }
        catch (CRLException cRLException) {
            return false;
        }
    }

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract Principal getIssuerDN();

    public abstract void verify(PublicKey var1) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract Date getNextUpdate();

    public abstract Date getThisUpdate();

    public abstract Set getRevokedCertificates();

    public X500Principal getIssuerX500Principal() {
        if (this.issuerPrincipal == null) {
            this.issuerPrincipal = X509CRLImpl.getIssuerX500Principal(this);
        }
        return this.issuerPrincipal;
    }

    public abstract void verify(PublicKey var1, String var2) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract X509CRLEntry getRevokedCertificate(BigInteger var1);
}

