/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class DigitList
implements Cloneable {
    public static final int MAX_COUNT = 19;
    public static final int DBL_DIG = 17;
    public int decimalAt = 0;
    public int count = 0;
    public char[] digits = new char[19];
    private static final char[] LONG_MIN_REP = "9223372036854775808".toCharArray();
    private StringBuffer tempBuffer;

    public final double getDouble() {
        if (this.count == 0) {
            return 0.0;
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append('.').append(this.digits, 0, this.count);
        stringBuffer.append('E');
        stringBuffer.append(this.decimalAt);
        return Double.parseDouble(stringBuffer.toString());
    }

    public int hashCode() {
        int n = this.decimalAt;
        for (int i = 0; i < this.count; ++i) {
            n = n * 37 + this.digits[i];
        }
        return n;
    }

    public final long getLong() {
        if (this.count == 0) {
            return 0L;
        }
        if (this.isLongMIN_VALUE()) {
            return Long.MIN_VALUE;
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append(this.digits, 0, this.count);
        for (int i = this.count; i < this.decimalAt; ++i) {
            stringBuffer.append('0');
        }
        return Long.parseLong(stringBuffer.toString());
    }

    DigitList() {
    }

    public void clear() {
        this.decimalAt = 0;
        this.count = 0;
    }

    private boolean isLongMIN_VALUE() {
        if (this.decimalAt != this.count || this.count != 19) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == LONG_MIN_REP[i]) continue;
            return false;
        }
        return true;
    }

    boolean isZero() {
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == '0') continue;
            return false;
        }
        return true;
    }

    public void append(char c) {
        if (this.count < 19) {
            this.digits[this.count++] = c;
        }
    }

    public final void set(double d, int n) {
        this.set(d, n, true);
    }

    final void set(double d, int n, boolean bl) {
        if (d == 0.0) {
            d = 0.0;
        }
        char[] cArray = Double.toString(d).toCharArray();
        this.decimalAt = -1;
        this.count = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < cArray.length) {
            char c;
            if ((c = cArray[n4++]) == '.') {
                this.decimalAt = this.count;
                continue;
            }
            if (c == 'e' || c == 'E') {
                n2 = DigitList.parseInt(cArray, n4);
                break;
            }
            if (this.count >= 19) continue;
            if (!bl2) {
                boolean bl3 = bl2 = c != '0';
                if (!bl2 && this.decimalAt != -1) {
                    ++n3;
                }
            }
            if (!bl2) continue;
            this.digits[this.count++] = c;
        }
        if (this.decimalAt == -1) {
            this.decimalAt = this.count;
        }
        if (bl2) {
            this.decimalAt += n2 - n3;
        }
        if (bl) {
            if (-this.decimalAt > n) {
                this.count = 0;
                return;
            }
            if (-this.decimalAt == n) {
                if (this.shouldRoundUp(0)) {
                    this.count = 1;
                    ++this.decimalAt;
                    this.digits[0] = 49;
                } else {
                    this.count = 0;
                }
                return;
            }
        }
        while (this.count > 1 && this.digits[this.count - 1] == '0') {
            --this.count;
        }
        this.round(bl ? n + this.decimalAt : n);
    }

    private final void round(int n) {
        if (n >= 0 && n < this.count) {
            if (this.shouldRoundUp(n)) {
                do {
                    if (--n < 0) {
                        this.digits[0] = 49;
                        ++this.decimalAt;
                        n = 0;
                        break;
                    }
                    int n2 = n;
                    this.digits[n2] = (char)(this.digits[n2] + '\u0001');
                } while (this.digits[n] > '9');
                ++n;
            }
            this.count = n;
            while (this.count > 1 && this.digits[this.count - 1] == '0') {
                --this.count;
            }
        }
    }

    private boolean shouldRoundUp(int n) {
        boolean bl = false;
        if (n < this.count) {
            if (this.digits[n] > '5') {
                return true;
            }
            if (this.digits[n] == '5') {
                for (int i = n + 1; i < this.count; ++i) {
                    if (this.digits[i] == '0') continue;
                    return true;
                }
                return n > 0 && this.digits[n - 1] % 2 != 0;
            }
        }
        return false;
    }

    public final void set(long l) {
        this.set(l, 0);
    }

    public final void set(long l, int n) {
        if (l <= 0L) {
            if (l == Long.MIN_VALUE) {
                this.count = 19;
                this.decimalAt = 19;
                System.arraycopy(LONG_MIN_REP, 0, this.digits, 0, this.count);
            } else {
                this.count = 0;
                this.decimalAt = 0;
            }
        } else {
            int n2 = 19;
            while (l > 0L) {
                this.digits[--n2] = (char)(48L + l % 10L);
                l /= 10L;
            }
            this.decimalAt = 19 - n2;
            int n3 = 18;
            while (this.digits[n3] == '0') {
                --n3;
            }
            this.count = n3 - n2 + 1;
            System.arraycopy(this.digits, n2, this.digits, 0, this.count);
        }
        if (n > 0) {
            this.round(n);
        }
    }

    boolean fitsIntoLong(boolean bl, boolean bl2) {
        while (this.count > 0 && this.digits[this.count - 1] == '0') {
            --this.count;
        }
        if (this.count == 0) {
            return bl || bl2;
        }
        if (this.decimalAt < this.count || this.decimalAt > 19) {
            return false;
        }
        if (this.decimalAt < 19) {
            return true;
        }
        for (int i = 0; i < this.count; ++i) {
            char c = this.digits[i];
            char c2 = LONG_MIN_REP[i];
            if (c > c2) {
                return false;
            }
            if (c >= c2) continue;
            return true;
        }
        if (this.count < this.decimalAt) {
            return true;
        }
        return !bl;
    }

    private static final int parseInt(char[] cArray, int n) {
        boolean bl = true;
        char c = cArray[n];
        if (c == '-') {
            bl = false;
            ++n;
        } else if (c == '+') {
            ++n;
        }
        int n2 = 0;
        while (n < cArray.length && (c = cArray[n++]) >= '0' && c <= '9') {
            n2 = n2 * 10 + (c - 48);
        }
        return bl ? n2 : -n2;
    }

    public Object clone() {
        try {
            DigitList digitList = (DigitList)super.clone();
            char[] cArray = new char[this.digits.length];
            System.arraycopy(this.digits, 0, cArray, 0, this.digits.length);
            digitList.digits = cArray;
            return digitList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitList)) {
            return false;
        }
        DigitList digitList = (DigitList)object;
        if (this.count != digitList.count || this.decimalAt != digitList.decimalAt) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == digitList.digits[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append("0.").append(this.digits, 0, this.count);
        stringBuffer.append("x10^");
        stringBuffer.append(this.decimalAt);
        return stringBuffer.toString();
    }

    private StringBuffer getStringBuffer() {
        if (this.tempBuffer == null) {
            this.tempBuffer = new StringBuffer(19);
        } else {
            this.tempBuffer.setLength(0);
        }
        return this.tempBuffer;
    }
}

