/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.EntryPair;
import java.text.ParseException;
import java.text.RBTableBuilder;
import java.util.Vector;
import sun.text.CompactIntArray;
import sun.text.IntHashtable;

final class RBCollationTables {
    static final int EXPANDCHARINDEX = 0x7E000000;
    static final int CONTRACTCHARINDEX = 0x7F000000;
    static final int UNMAPPED = -1;
    static final int PRIMARYORDERMASK = -65536;
    static final int SECONDARYORDERMASK = 65280;
    static final int TERTIARYORDERMASK = 255;
    static final int PRIMARYDIFFERENCEONLY = -65536;
    static final int SECONDARYDIFFERENCEONLY = -256;
    static final int PRIMARYORDERSHIFT = 16;
    static final int SECONDARYORDERSHIFT = 8;
    private String rules = null;
    private boolean frenchSec = false;
    private boolean seAsianSwapping = false;
    private CompactIntArray mapping = null;
    private Vector contractTable = null;
    private Vector expandTable = null;
    private IntHashtable contractFlags = null;
    private short maxSecOrder = 0;
    private short maxTerOrder = 0;

    short getMaxSecOrder() {
        return this.maxSecOrder;
    }

    short getMaxTerOrder() {
        return this.maxTerOrder;
    }

    public boolean isFrenchSec() {
        return this.frenchSec;
    }

    public boolean isSEAsianSwapping() {
        return this.seAsianSwapping;
    }

    int getUnicodeOrder(char c) {
        return this.mapping.elementAt(c);
    }

    boolean usedInContractSeq(char c) {
        return this.contractFlags.get(c) == 1;
    }

    int getMaxExpansion(int n) {
        int n2 = 1;
        if (this.expandTable != null) {
            for (int i = 0; i < this.expandTable.size(); ++i) {
                int[] nArray = (int[])this.expandTable.elementAt(i);
                int n3 = nArray.length;
                if (n3 <= n2 || nArray[n3 - 1] != n) continue;
                n2 = n3;
            }
        }
        return n2;
    }

    final int[] getExpandValueList(int n) {
        return (int[])this.expandTable.elementAt(n - 0x7E000000);
    }

    public String getRules() {
        return this.rules;
    }

    public RBCollationTables(String string, int n) throws ParseException {
        this.rules = string;
        RBTableBuilder rBTableBuilder = new RBTableBuilder(new BuildAPI());
        rBTableBuilder.build(string, n);
    }

    static void reverse(StringBuffer stringBuffer, int n, int n2) {
        int n3 = n;
        for (int i = n2 - 1; n3 < i; ++n3, --i) {
            char c = stringBuffer.charAt(n3);
            stringBuffer.setCharAt(n3, stringBuffer.charAt(i));
            stringBuffer.setCharAt(i, c);
        }
    }

    Vector getContractValues(char c) {
        int n = this.mapping.elementAt(c);
        return this.getContractValues(n - 0x7F000000);
    }

    Vector getContractValues(int n) {
        if (n >= 0) {
            return (Vector)this.contractTable.elementAt(n);
        }
        return null;
    }

    static final int getEntry(Vector vector, String string, boolean bl) {
        for (int i = 0; i < vector.size(); ++i) {
            EntryPair entryPair = (EntryPair)vector.elementAt(i);
            if (entryPair.fwd != bl || !entryPair.entryName.equals(string)) continue;
            return i;
        }
        return -1;
    }

    final class BuildAPI {
        private BuildAPI() {
        }

        void fillInTables(boolean bl, boolean bl2, CompactIntArray compactIntArray, Vector vector, Vector vector2, IntHashtable intHashtable, short s, short s2) {
            RBCollationTables.this.frenchSec = bl;
            RBCollationTables.this.seAsianSwapping = bl2;
            RBCollationTables.this.mapping = compactIntArray;
            RBCollationTables.this.contractTable = vector;
            RBCollationTables.this.expandTable = vector2;
            RBCollationTables.this.contractFlags = intHashtable;
            RBCollationTables.this.maxSecOrder = s;
            RBCollationTables.this.maxTerOrder = s2;
        }
    }
}

