/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.EntryPair;
import java.text.MergeCollation;
import java.text.ParseException;
import java.text.PatternEntry;
import java.text.RBCollationTables;
import java.util.Vector;
import sun.text.CompactIntArray;
import sun.text.ComposedCharIter;
import sun.text.IntHashtable;
import sun.text.Normalizer;
import sun.text.NormalizerUtilities;

final class RBTableBuilder {
    static final int CHARINDEX = 0x70000000;
    private static final int IGNORABLEMASK = 65535;
    private static final int PRIMARYORDERINCREMENT = 65536;
    private static final int SECONDARYORDERINCREMENT = 256;
    private static final int TERTIARYORDERINCREMENT = 1;
    private static final int INITIALTABLESIZE = 20;
    private static final int MAXKEYSIZE = 5;
    private RBCollationTables.BuildAPI tables = null;
    private MergeCollation mPattern = null;
    private boolean isOverIgnore = false;
    private StringBuffer key = new StringBuffer(5);
    private IntHashtable contractFlags = new IntHashtable(100);
    private boolean frenchSec = false;
    private boolean seAsianSwapping = false;
    private CompactIntArray mapping = null;
    private Vector contractTable = null;
    private Vector expandTable = null;
    private short maxSecOrder = 0;
    private short maxTerOrder = 0;

    private void addComposedChars() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer(1);
        ComposedCharIter composedCharIter = new ComposedCharIter(false, 1);
        while (composedCharIter.hasNext()) {
            char c = composedCharIter.next();
            if (this.getCharOrder(c) != -1) continue;
            String string = composedCharIter.decomposition();
            int n = this.getContractOrder(string);
            if (n != -1) {
                this.addOrder(c, n);
                continue;
            }
            boolean bl = true;
            for (int i = 0; i < string.length(); ++i) {
                if (this.getCharOrder(string.charAt(i)) != -1) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            stringBuffer.setLength(0);
            stringBuffer.append(c);
            this.addExpandOrder(stringBuffer.toString(), string, -1);
        }
    }

    private final void commit() {
        if (this.expandTable != null) {
            for (int i = 0; i < this.expandTable.size(); ++i) {
                int[] nArray = (int[])this.expandTable.elementAt(i);
                for (int j = 0; j < nArray.length; ++j) {
                    int n = nArray[j];
                    if (n >= 0x7E000000 || n <= 0x70000000) continue;
                    char c = (char)(n - 0x70000000);
                    int n2 = this.getCharOrder(c);
                    nArray[j] = n2 == -1 ? 0xFFFF & c : n2;
                }
            }
        }
    }

    private final int getCharOrder(char c) {
        int n = this.mapping.elementAt(c);
        if (n >= 0x7F000000) {
            Vector vector = this.getContractValues(n - 0x7F000000);
            EntryPair entryPair = (EntryPair)vector.firstElement();
            n = entryPair.value;
        }
        return n;
    }

    private final void addOrder(char c, int n) {
        int n2 = this.mapping.elementAt(c);
        if (n2 >= 0x7F000000) {
            this.key.setLength(0);
            this.key.append(c);
            this.addContractOrder(this.key.toString(), n);
        } else {
            this.mapping.setElementAt(c, n);
        }
    }

    private final int increment(int n, int n2) {
        switch (n) {
            case 0: {
                n2 += 65536;
                n2 &= 0xFFFF0000;
                this.isOverIgnore = true;
                break;
            }
            case 1: {
                n2 += 256;
                n2 &= 0xFFFFFF00;
                if (this.isOverIgnore) break;
                this.maxSecOrder = (short)(this.maxSecOrder + 1);
                break;
            }
            case 2: {
                ++n2;
                if (this.isOverIgnore) break;
                this.maxTerOrder = (short)(this.maxTerOrder + 1);
            }
        }
        return n2;
    }

    private int addExpansion(int n, String string) {
        int n2;
        if (this.expandTable == null) {
            this.expandTable = new Vector(20);
        }
        int n3 = n == -1 ? 0 : 1;
        int[] nArray = new int[string.length() + n3];
        if (n3 == 1) {
            nArray[0] = n;
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            int n4 = this.getCharOrder(c);
            nArray[n2 + n3] = n4 != -1 ? n4 : 0x70000000 + c;
        }
        n2 = 0x7E000000 + this.expandTable.size();
        this.expandTable.addElement(nArray);
        return n2;
    }

    private int getContractOrder(String string) {
        int n;
        Vector vector;
        int n2 = -1;
        if (this.contractTable != null && (vector = this.getContractValues(string.charAt(0))) != null && (n = RBCollationTables.getEntry(vector, string, true)) != -1) {
            EntryPair entryPair = (EntryPair)vector.elementAt(n);
            n2 = entryPair.value;
        }
        return n2;
    }

    private void addContractFlags(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.contractFlags.put(c, 1);
        }
    }

    private final void addContractOrder(String string, int n) {
        this.addContractOrder(string, n, true);
    }

    public void build(String string, int n) throws ParseException {
        boolean bl = true;
        int n2 = 0;
        if (string.length() == 0) {
            throw new ParseException("Build rules empty.", 0);
        }
        this.mapping = new CompactIntArray(-1);
        Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(n);
        string = Normalizer.normalize(string, mode, 0, true);
        this.mPattern = new MergeCollation(string);
        int n3 = 0;
        for (n2 = 0; n2 < this.mPattern.getCount(); ++n2) {
            PatternEntry patternEntry = this.mPattern.getItemAt(n2);
            if (patternEntry == null) continue;
            String string2 = patternEntry.getChars();
            if (string2.length() > 1) {
                switch (string2.charAt(string2.length() - 1)) {
                    case '@': {
                        this.frenchSec = true;
                        string2 = string2.substring(0, string2.length() - 1);
                        break;
                    }
                    case '!': {
                        this.seAsianSwapping = true;
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                }
            }
            n3 = this.increment(patternEntry.getStrength(), n3);
            String string3 = patternEntry.getExtension();
            if (string3.length() != 0) {
                this.addExpandOrder(string2, string3, n3);
                continue;
            }
            if (string2.length() > 1) {
                this.addContractOrder(string2, n3);
                continue;
            }
            char c = string2.charAt(0);
            this.addOrder(c, n3);
        }
        this.addComposedChars();
        this.commit();
        this.mapping.compact();
        this.tables.fillInTables(this.frenchSec, this.seAsianSwapping, this.mapping, this.contractTable, this.expandTable, this.contractFlags, this.maxSecOrder, this.maxTerOrder);
    }

    private final void addContractOrder(String string, int n, boolean bl) {
        int n2;
        int n3;
        Vector vector;
        if (this.contractTable == null) {
            this.contractTable = new Vector(20);
        }
        if ((vector = this.getContractValues((n3 = this.mapping.elementAt(string.charAt(0))) - 0x7F000000)) == null) {
            n2 = 0x7F000000 + this.contractTable.size();
            vector = new Vector(20);
            this.contractTable.addElement(vector);
            vector.addElement(new EntryPair(string.substring(0, 1), n3));
            this.mapping.setElementAt(string.charAt(0), n2);
        }
        if ((n2 = RBCollationTables.getEntry(vector, string, bl)) != -1) {
            EntryPair entryPair = (EntryPair)vector.elementAt(n2);
            entryPair.value = n;
        } else {
            EntryPair entryPair = (EntryPair)vector.lastElement();
            if (string.length() > entryPair.entryName.length()) {
                vector.addElement(new EntryPair(string, n, bl));
            } else {
                vector.insertElementAt(new EntryPair(string, n, bl), vector.size() - 1);
            }
        }
        if (bl && string.length() > 1) {
            this.addContractFlags(string);
            this.addContractOrder(new StringBuffer(string).reverse().toString(), n, false);
        }
    }

    public RBTableBuilder(RBCollationTables.BuildAPI buildAPI) {
        this.tables = buildAPI;
    }

    Vector getContractValues(char c) {
        int n = this.mapping.elementAt(c);
        return this.getContractValues(n - 0x7F000000);
    }

    Vector getContractValues(int n) {
        if (n >= 0) {
            return (Vector)this.contractTable.elementAt(n);
        }
        return null;
    }

    private final void addExpandOrder(String string, String string2, int n) throws ParseException {
        int n2 = this.addExpansion(n, string2);
        if (string.length() > 1) {
            this.addContractOrder(string, n2);
        } else {
            this.addOrder(string.charAt(0), n2);
        }
    }
}

