/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.BreakIterator;
import java.text.CharSet;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import sun.text.CompactByteArray;

class RuleBasedBreakIterator
extends BreakIterator {
    protected static final byte IGNORE = -1;
    private static final short START_STATE = 1;
    private static final short STOP_STATE = 0;
    private String description;
    private CompactByteArray charCategoryTable = null;
    private short[] stateTable = null;
    private short[] backwardsStateTable = null;
    private boolean[] endStates = null;
    private boolean[] lookaheadStates = null;
    private int numCategories;
    private CharacterIterator text = null;

    public int current() {
        return this.getText().getIndex();
    }

    public int first() {
        CharacterIterator characterIterator = this.getText();
        characterIterator.first();
        return characterIterator.getIndex();
    }

    protected int handleNext() {
        CharacterIterator characterIterator = this.getText();
        if (characterIterator.getIndex() == characterIterator.getEndIndex()) {
            return -1;
        }
        int n = characterIterator.getIndex() + 1;
        int n2 = 0;
        int n3 = 1;
        char c = characterIterator.current();
        while (c != '\uffff' && n3 != 0) {
            int n4 = this.lookupCategory(c);
            if (n4 != -1) {
                n3 = this.lookupState(n3, n4);
            }
            if (this.lookaheadStates[n3]) {
                if (this.endStates[n3]) {
                    n = n2;
                } else {
                    n2 = characterIterator.getIndex() + 1;
                }
            } else if (this.endStates[n3]) {
                n = characterIterator.getIndex() + 1;
            }
            c = characterIterator.next();
        }
        if (c == '\uffff' && n2 == characterIterator.getEndIndex()) {
            n = n2;
        }
        characterIterator.setIndex(n);
        return n;
    }

    protected int handlePrevious() {
        CharacterIterator characterIterator = this.getText();
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        char c = characterIterator.current();
        while (c != '\uffff' && n != 0) {
            n3 = n2;
            n2 = this.lookupCategory(c);
            if (n2 != -1) {
                n = this.lookupBackwardState(n, n2);
            }
            c = characterIterator.previous();
        }
        if (c != '\uffff') {
            if (n3 != -1) {
                characterIterator.setIndex(characterIterator.getIndex() + 2);
            } else {
                characterIterator.next();
            }
        }
        return characterIterator.getIndex();
    }

    public int hashCode() {
        return this.description.hashCode();
    }

    public int last() {
        CharacterIterator characterIterator = this.getText();
        characterIterator.setIndex(characterIterator.getEndIndex());
        return characterIterator.getIndex();
    }

    public int next() {
        return this.handleNext();
    }

    public int previous() {
        int n;
        CharacterIterator characterIterator = this.getText();
        if (this.current() == characterIterator.getBeginIndex()) {
            return -1;
        }
        int n2 = this.current();
        characterIterator.previous();
        int n3 = n = this.handlePrevious();
        while (n3 != -1 && n3 < n2) {
            n = n3;
            n3 = this.handleNext();
        }
        characterIterator.setIndex(n);
        return n;
    }

    protected int lookupCategory(char c) {
        return this.charCategoryTable.elementAt(c);
    }

    public int following(int n) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n, characterIterator);
        characterIterator.setIndex(n);
        if (n == characterIterator.getBeginIndex()) {
            return this.handleNext();
        }
        int n2 = this.handlePrevious();
        while (n2 != -1 && n2 <= n) {
            n2 = this.handleNext();
        }
        return n2;
    }

    public int next(int n) {
        int n2 = this.current();
        while (n > 0) {
            n2 = this.handleNext();
            --n;
        }
        while (n < 0) {
            n2 = this.previous();
            ++n;
        }
        return n2;
    }

    public int preceding(int n) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n, characterIterator);
        characterIterator.setIndex(n);
        return this.previous();
    }

    public boolean isBoundary(int n) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n, characterIterator);
        if (n == characterIterator.getBeginIndex()) {
            return true;
        }
        return this.following(n - 1) == n;
    }

    protected int lookupBackwardState(int n, int n2) {
        return this.backwardsStateTable[n * this.numCategories + n2];
    }

    protected int lookupState(int n, int n2) {
        return this.stateTable[n * this.numCategories + n2];
    }

    public Object clone() {
        RuleBasedBreakIterator ruleBasedBreakIterator = (RuleBasedBreakIterator)super.clone();
        if (this.text != null) {
            ruleBasedBreakIterator.text = (CharacterIterator)this.text.clone();
        }
        return ruleBasedBreakIterator;
    }

    public boolean equals(Object object) {
        try {
            RuleBasedBreakIterator ruleBasedBreakIterator = (RuleBasedBreakIterator)object;
            if (!this.description.equals(ruleBasedBreakIterator.description)) {
                return false;
            }
            if (this.text == null) {
                return ruleBasedBreakIterator.text == null;
            }
            return this.text.equals(ruleBasedBreakIterator.text);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return this.description;
    }

    public RuleBasedBreakIterator(String string) {
        this.description = string;
        Builder builder = this.makeBuilder();
        builder.buildBreakIterator();
    }

    public CharacterIterator getText() {
        if (this.text == null) {
            this.text = new StringCharacterIterator("");
        }
        return this.text;
    }

    protected static final void checkOffset(int n, CharacterIterator characterIterator) {
        if (n < characterIterator.getBeginIndex() || n >= characterIterator.getEndIndex()) {
            throw new IllegalArgumentException("offset out of bounds");
        }
    }

    public void setText(CharacterIterator characterIterator) {
        boolean bl;
        int n = characterIterator.getEndIndex();
        try {
            characterIterator.setIndex(n);
            bl = characterIterator.getIndex() == n;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        this.text = bl ? characterIterator : new SafeCharIterator(characterIterator);
        this.text.first();
    }

    static /* synthetic */ short[] access$502(RuleBasedBreakIterator ruleBasedBreakIterator, short[] sArray) {
        ruleBasedBreakIterator.stateTable = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$602(RuleBasedBreakIterator ruleBasedBreakIterator, short[] sArray) {
        ruleBasedBreakIterator.backwardsStateTable = sArray;
        return sArray;
    }

    static /* synthetic */ boolean[] access$302(RuleBasedBreakIterator ruleBasedBreakIterator, boolean[] blArray) {
        ruleBasedBreakIterator.endStates = blArray;
        return blArray;
    }

    static /* synthetic */ boolean[] access$402(RuleBasedBreakIterator ruleBasedBreakIterator, boolean[] blArray) {
        ruleBasedBreakIterator.lookaheadStates = blArray;
        return blArray;
    }

    protected Builder makeBuilder() {
        return new Builder();
    }

    protected class Builder {
        protected Vector categories = null;
        protected Hashtable expressions = null;
        protected CharSet ignoreChars = null;
        protected Vector tempStateTable = null;
        protected Vector decisionPointList = null;
        protected Stack decisionPointStack = null;
        protected Vector loopingStates = null;
        protected Vector statesToBackfill = null;
        protected Vector mergeList = null;
        protected boolean clearLoopingStates = false;
        protected static final int END_STATE_FLAG = 32768;
        protected static final int DONT_LOOP_FLAG = 16384;
        protected static final int LOOKAHEAD_STATE_FLAG = 8192;
        protected static final int ALL_FLAGS = 57344;

        private void backfillLoopingStates() {
            short[] sArray = null;
            int n = 0;
            for (int i = 0; i < this.tempStateTable.size(); ++i) {
                short[] sArray2 = (short[])this.tempStateTable.elementAt(i);
                int n2 = sArray2[RuleBasedBreakIterator.this.numCategories] & 0xFFFF1FFF;
                if (n2 <= 0) continue;
                if (n2 != n) {
                    n = n2;
                    sArray = (short[])this.tempStateTable.elementAt(n);
                }
                int n3 = RuleBasedBreakIterator.this.numCategories;
                sArray2[n3] = (short)(sArray2[n3] & 0xE000);
                for (int j = 0; j < sArray2.length; ++j) {
                    if (sArray2[j] == 0) {
                        sArray2[j] = sArray[j];
                        continue;
                    }
                    if (sArray2[j] != 16384) continue;
                    sArray2[j] = 0;
                }
            }
        }

        public void buildBreakIterator() {
            Vector vector = this.buildRuleList(RuleBasedBreakIterator.this.description);
            this.buildCharCategories(vector);
            this.buildStateTable(vector);
            this.buildBackwardsStateTable(vector);
        }

        private void eliminateBackfillStates(int n) {
            if (this.statesToBackfill.contains(new Integer(n))) {
                this.statesToBackfill.removeElement(new Integer(n));
                short[] sArray = (short[])this.tempStateTable.elementAt(n);
                for (int i = 0; i < RuleBasedBreakIterator.this.numCategories; ++i) {
                    if (sArray[i] == 0) continue;
                    this.eliminateBackfillStates(sArray[i]);
                }
            }
        }

        private int searchMergeList(int n, int n2) {
            if (this.mergeList == null) {
                return 0;
            }
            for (int i = 0; i < this.mergeList.size(); ++i) {
                int[] nArray = (int[])this.mergeList.elementAt(i);
                if (nArray[0] == n && nArray[1] == n2 || nArray[0] == n2 && nArray[1] == n) {
                    return nArray[2];
                }
                if (nArray[2] == n && (nArray[0] == n2 || nArray[1] == n2)) {
                    return nArray[2];
                }
                if (nArray[2] != n2 || nArray[0] != n && nArray[1] != n) continue;
                return nArray[2];
            }
            return 0;
        }

        private void finishBuildingStateTable(boolean bl) {
            int n;
            int n2;
            short[] sArray;
            int n3;
            this.backfillLoopingStates();
            int[] nArray = new int[this.tempStateTable.size()];
            Stack stack = new Stack();
            stack.push(new Integer(1));
            nArray[1] = 1;
            while (stack.size() != 0) {
                int n4 = (Integer)stack.pop();
                short[] sArray2 = (short[])this.tempStateTable.elementAt(n4);
                for (int i = 0; i < RuleBasedBreakIterator.this.numCategories; ++i) {
                    if (sArray2[i] == 0 || nArray[sArray2[i]] != 0) continue;
                    nArray[sArray2[i]] = sArray2[i];
                    stack.push(new Integer(sArray2[i]));
                }
            }
            int[] nArray2 = new int[this.tempStateTable.size()];
            int n5 = RuleBasedBreakIterator.this.numCategories + 1;
            for (n3 = 1; n3 < nArray2.length; ++n3) {
                if (nArray[n3] == 0) continue;
                sArray = (short[])this.tempStateTable.elementAt(n3);
                for (n2 = 0; n2 < RuleBasedBreakIterator.this.numCategories; ++n2) {
                    if (sArray[n2] == 0) continue;
                    int n6 = n3;
                    nArray2[n6] = nArray2[n6] + 1;
                }
                if (nArray2[n3] != 0) continue;
                nArray2[n3] = n5;
            }
            ++n5;
            do {
                n2 = n5;
                for (n3 = 1; n3 < n5; ++n3) {
                    boolean bl2 = false;
                    short[] sArray3 = null;
                    sArray = null;
                    block6: for (int i = 0; i < nArray2.length; ++i) {
                        if (nArray2[i] != n3) continue;
                        if (sArray == null) {
                            sArray = (short[])this.tempStateTable.elementAt(i);
                            continue;
                        }
                        sArray3 = (short[])this.tempStateTable.elementAt(i);
                        for (n = 0; n < sArray3.length; ++n) {
                            if ((n != RuleBasedBreakIterator.this.numCategories || sArray[n] == sArray3[n] || !bl) && (n == RuleBasedBreakIterator.this.numCategories || nArray2[sArray[n]] == nArray2[sArray3[n]])) continue;
                            nArray2[i] = n5;
                            bl2 = true;
                            continue block6;
                        }
                    }
                    if (!bl2) continue;
                    ++n5;
                }
            } while (n2 != n5);
            int[] nArray3 = new int[n5];
            for (n = 1; n < nArray2.length; ++n) {
                if (nArray3[nArray2[n]] == 0) {
                    nArray3[nArray2[n]] = n;
                    continue;
                }
                nArray[n] = nArray3[nArray2[n]];
            }
            for (n = 1; n < nArray.length; ++n) {
                if (nArray[n] == n) continue;
                this.tempStateTable.setElementAt(null, n);
            }
            int n7 = 1;
            for (n = 1; n < nArray.length; ++n) {
                if (this.tempStateTable.elementAt(n) == null) continue;
                nArray[n] = n7++;
            }
            for (n = 1; n < nArray.length; ++n) {
                if (this.tempStateTable.elementAt(n) != null) continue;
                nArray[n] = nArray[nArray[n]];
            }
            if (bl) {
                RuleBasedBreakIterator.access$302(RuleBasedBreakIterator.this, new boolean[n7]);
                RuleBasedBreakIterator.access$402(RuleBasedBreakIterator.this, new boolean[n7]);
                RuleBasedBreakIterator.access$502(RuleBasedBreakIterator.this, new short[n7 * RuleBasedBreakIterator.this.numCategories]);
                n = 0;
                int n8 = 0;
                for (int i = 0; i < this.tempStateTable.size(); ++i) {
                    short[] sArray4 = (short[])this.tempStateTable.elementAt(i);
                    if (sArray4 == null) continue;
                    for (int j = 0; j < RuleBasedBreakIterator.this.numCategories; ++j) {
                        ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).stateTable[n] = (short)nArray[sArray4[j]];
                        ++n;
                    }
                    ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).endStates[n8] = (sArray4[RuleBasedBreakIterator.this.numCategories] & 0x8000) != 0;
                    ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).lookaheadStates[n8] = (sArray4[RuleBasedBreakIterator.this.numCategories] & 0x2000) != 0;
                    ++n8;
                }
            } else {
                RuleBasedBreakIterator.access$602(RuleBasedBreakIterator.this, new short[n7 * RuleBasedBreakIterator.this.numCategories]);
                n = 0;
                for (int i = 0; i < this.tempStateTable.size(); ++i) {
                    short[] sArray5 = (short[])this.tempStateTable.elementAt(i);
                    if (sArray5 == null) continue;
                    for (int j = 0; j < RuleBasedBreakIterator.this.numCategories; ++j) {
                        ((RuleBasedBreakIterator)RuleBasedBreakIterator.this).backwardsStateTable[n] = (short)nArray[sArray5[j]];
                        ++n;
                    }
                }
            }
        }

        private void parseRule(String string, boolean bl) {
            short[] sArray;
            int n;
            int n2;
            int n3 = 0;
            int n4 = n2 = 1;
            String string2 = "";
            this.decisionPointStack = new Stack();
            this.decisionPointList = new Vector();
            this.loopingStates = new Vector();
            this.statesToBackfill = new Vector();
            boolean bl2 = false;
            if (!bl) {
                this.loopingStates.addElement(new Integer(1));
            }
            this.decisionPointList.addElement(new Integer(n2));
            n2 = this.tempStateTable.size() - 1;
            while (n3 < string.length()) {
                int n5;
                n = string.charAt(n3);
                this.clearLoopingStates = false;
                if (n == 91 || n == 92 || Character.isLetter((char)n) || Character.isDigit((char)n) || n < 32 || n == 46 || n >= 127) {
                    int n6;
                    if (n != 46) {
                        n6 = n3;
                        if (n == 92) {
                            n6 = n3 + 2;
                            ++n3;
                        } else if (n == 91) {
                            int n7 = 1;
                            while (n7 > 0) {
                                if ((n = string.charAt(++n6)) == 91) {
                                    ++n7;
                                    continue;
                                }
                                if (n == 93) {
                                    --n7;
                                    continue;
                                }
                                if (n != 92) continue;
                                ++n6;
                            }
                            ++n6;
                        } else {
                            n6 = n3 + 1;
                        }
                        string2 = (String)this.expressions.get(string.substring(n3, n6));
                        n3 = n6 - 1;
                    } else {
                        n6 = (Integer)this.decisionPointList.lastElement();
                        sArray = (short[])this.tempStateTable.elementAt(n6);
                        if (n3 + 1 < string.length() && string.charAt(n3 + 1) == '*' && sArray[0] != 0) {
                            this.decisionPointList.addElement(new Integer(sArray[0]));
                            string2 = "";
                            ++n3;
                        } else {
                            StringBuffer stringBuffer = new StringBuffer();
                            for (n5 = 0; n5 < RuleBasedBreakIterator.this.numCategories; ++n5) {
                                stringBuffer.append((char)(n5 + 256));
                            }
                            string2 = stringBuffer.toString();
                        }
                    }
                    if (string2.length() != 0) {
                        if (n3 + 1 < string.length() && string.charAt(n3 + 1) == '*') {
                            this.decisionPointStack.push(this.decisionPointList.clone());
                        }
                        n6 = this.tempStateTable.size();
                        if (this.loopingStates.size() != 0) {
                            this.statesToBackfill.addElement(new Integer(n6));
                        }
                        sArray = new short[RuleBasedBreakIterator.this.numCategories + 1];
                        if (bl2) {
                            sArray[((RuleBasedBreakIterator)RuleBasedBreakIterator.this).numCategories] = 16384;
                        }
                        this.tempStateTable.addElement(sArray);
                        this.updateStateTable(this.decisionPointList, string2, (short)n6);
                        this.decisionPointList.removeAllElements();
                        n4 = n2;
                        do {
                            this.decisionPointList.addElement(new Integer(++n2));
                        } while (n2 + 1 < this.tempStateTable.size());
                    }
                } else if (n == 123) {
                    this.decisionPointStack.push(this.decisionPointList.clone());
                } else if (n == 125 || n == 42) {
                    if (n == 42) {
                        for (int i = n4 + 1; i < this.tempStateTable.size(); ++i) {
                            Vector vector = new Vector();
                            vector.addElement(new Integer(i));
                            this.updateStateTable(vector, string2, (short)(n4 + 1));
                        }
                    }
                    Vector vector = (Vector)this.decisionPointStack.pop();
                    for (int i = 0; i < this.decisionPointList.size(); ++i) {
                        vector.addElement(this.decisionPointList.elementAt(i));
                    }
                    this.decisionPointList = vector;
                } else if (n == 63) {
                    this.setLoopingStates(this.decisionPointList, this.decisionPointList);
                } else if (n == 40) {
                    this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
                    n4 = n2++;
                    this.decisionPointList.insertElementAt(new Integer(n2), 0);
                    this.decisionPointStack.push(this.decisionPointList.clone());
                    this.decisionPointStack.push(new Vector());
                } else if (n == 124) {
                    Vector vector = (Vector)this.decisionPointStack.pop();
                    Vector vector2 = (Vector)this.decisionPointStack.peek();
                    this.decisionPointStack.push(vector);
                    for (n5 = 0; n5 < this.decisionPointList.size(); ++n5) {
                        vector.addElement(this.decisionPointList.elementAt(n5));
                    }
                    this.decisionPointList = (Vector)vector2.clone();
                } else if (n == 41) {
                    Vector vector = (Vector)this.decisionPointStack.pop();
                    for (int i = 0; i < this.decisionPointList.size(); ++i) {
                        vector.addElement(this.decisionPointList.elementAt(i));
                    }
                    this.decisionPointList = vector;
                    if (n3 + 1 >= string.length() || string.charAt(n3 + 1) != '*') {
                        this.decisionPointStack.pop();
                    } else {
                        int n8;
                        vector = (Vector)this.decisionPointList.clone();
                        Vector vector3 = (Vector)this.decisionPointStack.pop();
                        n5 = (Integer)vector3.firstElement();
                        short[] sArray2 = (short[])this.tempStateTable.elementAt(n5);
                        for (n8 = 0; n8 < this.decisionPointList.size(); ++n8) {
                            vector3.addElement(this.decisionPointList.elementAt(n8));
                        }
                        this.decisionPointList = vector3;
                        for (n8 = 0; n8 < sArray2.length; ++n8) {
                            if (sArray2[n8] <= n5) continue;
                            this.updateStateTable(vector, new Character((char)(n8 + 256)).toString(), sArray2[n8]);
                        }
                        n4 = n2;
                        n2 = this.tempStateTable.size() - 1;
                        ++n3;
                    }
                } else if (n == 47) {
                    bl2 = true;
                    for (int i = 0; i < this.decisionPointList.size(); ++i) {
                        sArray = (short[])this.tempStateTable.elementAt((Integer)this.decisionPointList.elementAt(i));
                        int n9 = RuleBasedBreakIterator.this.numCategories;
                        sArray[n9] = (short)(sArray[n9] | 0x2000);
                    }
                }
                if (this.clearLoopingStates) {
                    this.setLoopingStates(null, this.decisionPointList);
                }
                ++n3;
            }
            this.setLoopingStates(null, this.decisionPointList);
            for (n = 0; n < this.decisionPointList.size(); ++n) {
                int n10 = (Integer)this.decisionPointList.elementAt(n);
                sArray = (short[])this.tempStateTable.elementAt(n10);
                int n11 = RuleBasedBreakIterator.this.numCategories;
                sArray[n11] = (short)(sArray[n11] | 0x8000);
                if (!bl2) continue;
                int n12 = RuleBasedBreakIterator.this.numCategories;
                sArray[n12] = (short)(sArray[n12] | 0x2000);
            }
        }

        protected void mungeExpressionList(Hashtable hashtable) {
        }

        private void mergeStates(int n, short[] sArray, Vector vector) {
            short[] sArray2 = (short[])this.tempStateTable.elementAt(n);
            boolean bl = this.loopingStates.contains(new Integer(n));
            for (int i = 0; i < sArray2.length; ++i) {
                if (sArray2[i] == sArray[i]) continue;
                if (bl && this.loopingStates.contains(new Integer(sArray2[i]))) {
                    if (sArray[i] == 0) continue;
                    if (sArray2[i] == 0) {
                        this.clearLoopingStates = true;
                    }
                    sArray2[i] = sArray[i];
                    continue;
                }
                if (sArray2[i] == 0) {
                    sArray2[i] = sArray[i];
                    continue;
                }
                if (i == RuleBasedBreakIterator.this.numCategories) {
                    sArray2[i] = (short)(sArray[i] & 0xE000 | sArray2[i]);
                    continue;
                }
                if (sArray2[i] == 0 || sArray[i] == 0) continue;
                int n2 = this.searchMergeList(sArray2[i], sArray[i]);
                if (n2 != 0) {
                    sArray2[i] = (short)n2;
                    continue;
                }
                int n3 = sArray2[i];
                int n4 = sArray[i];
                n2 = this.tempStateTable.size();
                if (this.mergeList == null) {
                    this.mergeList = new Vector();
                }
                this.mergeList.addElement(new int[]{n3, n4, n2});
                short[] sArray3 = new short[RuleBasedBreakIterator.this.numCategories + 1];
                short[] sArray4 = (short[])this.tempStateTable.elementAt(n3);
                System.arraycopy(sArray4, 0, sArray3, 0, RuleBasedBreakIterator.this.numCategories + 1);
                this.tempStateTable.addElement(sArray3);
                sArray2[i] = (short)n2;
                if ((this.decisionPointList.contains(new Integer(n3)) || this.decisionPointList.contains(new Integer(n4))) && !this.decisionPointList.contains(new Integer(n2))) {
                    this.decisionPointList.addElement(new Integer(n2));
                }
                if ((vector.contains(new Integer(n3)) || vector.contains(new Integer(n4))) && !vector.contains(new Integer(n2))) {
                    this.decisionPointList.addElement(new Integer(n2));
                }
                for (int j = 0; j < this.decisionPointStack.size(); ++j) {
                    Vector vector2 = (Vector)this.decisionPointStack.elementAt(j);
                    if (!vector2.contains(new Integer(n3)) && !vector2.contains(new Integer(n4)) || vector2.contains(new Integer(n2))) continue;
                    vector2.addElement(new Integer(n2));
                }
                this.mergeStates(n2, (short[])this.tempStateTable.elementAt(sArray[i]), vector);
            }
        }

        private void buildBackwardsStateTable(Vector vector) {
            int n;
            int n2;
            int n3;
            int n4;
            this.tempStateTable = new Vector();
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            for (n4 = 0; n4 < vector.size(); ++n4) {
                String string = (String)vector.elementAt(n4);
                if (string.charAt(0) != '!') continue;
                this.parseRule(string.substring(1), false);
            }
            this.backfillLoopingStates();
            n4 = this.tempStateTable.size();
            if (n4 > 2) {
                ++n4;
            }
            for (int i = 0; i < RuleBasedBreakIterator.this.numCategories + 1; ++i) {
                this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            }
            short[] sArray = (short[])this.tempStateTable.elementAt(n4 - 1);
            for (n3 = 0; n3 < RuleBasedBreakIterator.this.numCategories; ++n3) {
                sArray[n3] = (short)(n3 + n4);
            }
            n3 = RuleBasedBreakIterator.this.stateTable.length / RuleBasedBreakIterator.this.numCategories;
            for (n2 = 0; n2 < RuleBasedBreakIterator.this.numCategories; ++n2) {
                for (int i = 0; i < n3; ++i) {
                    n = RuleBasedBreakIterator.this.lookupState(i, n2);
                    if (n == 0) continue;
                    for (int j = 0; j < RuleBasedBreakIterator.this.numCategories; ++j) {
                        int n5 = RuleBasedBreakIterator.this.lookupState(n, j);
                        if (n5 == 0) continue;
                        sArray = (short[])this.tempStateTable.elementAt(j + n4);
                        sArray[n2] = (short)(n2 + n4);
                    }
                }
            }
            if (n4 > 1) {
                sArray = (short[])this.tempStateTable.elementAt(1);
                for (n2 = n4 - 1; n2 < this.tempStateTable.size(); ++n2) {
                    short[] sArray2 = (short[])this.tempStateTable.elementAt(n2);
                    for (n = 0; n < RuleBasedBreakIterator.this.numCategories; ++n) {
                        if (sArray[n] == 0 || sArray2[n] == 0) continue;
                        sArray2[n] = sArray[n];
                    }
                }
                sArray = (short[])this.tempStateTable.elementAt(n4 - 1);
                for (n2 = 1; n2 < n4 - 1; ++n2) {
                    short[] sArray3 = (short[])this.tempStateTable.elementAt(n2);
                    if ((sArray3[RuleBasedBreakIterator.this.numCategories] & 0x8000) != 0) continue;
                    for (n = 0; n < RuleBasedBreakIterator.this.numCategories; ++n) {
                        if (sArray3[n] != 0) continue;
                        sArray3[n] = sArray[n];
                    }
                }
            }
            this.finishBuildingStateTable(false);
        }

        protected void buildCharCategories(Vector vector) {
            Object object;
            CharSet charSet;
            Object object2;
            int n;
            Object object3;
            int n2 = 0;
            int n3 = 0;
            this.expressions = new Hashtable();
            for (int i = 0; i < vector.size(); ++i) {
                object3 = (String)vector.elementAt(i);
                block11: for (n3 = 0; n3 < ((String)object3).length(); ++n3) {
                    char c = ((String)object3).charAt(n3);
                    switch (c) {
                        case '!': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '.': 
                        case '/': 
                        case ';': 
                        case '?': 
                        case '{': 
                        case '|': 
                        case '}': {
                            continue block11;
                        }
                        case '[': {
                            ++n2;
                            block12: for (n = n3 + 1; n < ((String)object3).length() && n2 != 0; ++n) {
                                c = ((String)object3).charAt(n);
                                switch (c) {
                                    case '\\': {
                                        ++n;
                                        continue block12;
                                    }
                                    case '[': {
                                        ++n2;
                                        continue block12;
                                    }
                                    case ']': {
                                        --n2;
                                    }
                                }
                            }
                            if (this.expressions.get(((String)object3).substring(n3, n)) == null) {
                                this.expressions.put(((String)object3).substring(n3, n), CharSet.parseString(((String)object3).substring(n3, n)));
                            }
                            n3 = n - 1;
                            continue block11;
                        }
                        case '\\': {
                            c = ((String)object3).charAt(++n3);
                        }
                        default: {
                            this.expressions.put(((String)object3).substring(n3, n3 + 1), CharSet.parseString(((String)object3).substring(n3, n3 + 1)));
                        }
                    }
                }
            }
            CharSet.releaseExpressionCache();
            this.categories = new Vector();
            if (this.ignoreChars != null) {
                this.categories.addElement(this.ignoreChars);
            } else {
                this.categories.addElement(new CharSet());
            }
            this.ignoreChars = null;
            this.mungeExpressionList(this.expressions);
            object3 = this.expressions.elements();
            while (object3.hasMoreElements()) {
                CharSet charSet2 = (CharSet)object3.nextElement();
                for (n = this.categories.size() - 1; !charSet2.empty() && n > 0; --n) {
                    object2 = (CharSet)this.categories.elementAt(n);
                    if (((CharSet)object2).intersection(charSet2).empty()) continue;
                    charSet = ((CharSet)object2).difference(charSet2);
                    if (!charSet.empty()) {
                        this.categories.addElement(charSet);
                    }
                    charSet = charSet2.intersection((CharSet)object2);
                    charSet2 = charSet2.difference((CharSet)object2);
                    if (charSet.equals(object2)) continue;
                    this.categories.setElementAt(charSet, n);
                }
                if (charSet2.empty()) continue;
                this.categories.addElement(charSet2);
            }
            CharSet charSet3 = new CharSet();
            for (n = 1; n < this.categories.size(); ++n) {
                charSet3 = charSet3.union((CharSet)this.categories.elementAt(n));
            }
            CharSet charSet4 = (CharSet)this.categories.elementAt(0);
            charSet4 = charSet4.difference(charSet3);
            this.categories.setElementAt(charSet4, 0);
            object3 = this.expressions.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                charSet = (CharSet)this.expressions.get(object2);
                object = new StringBuffer();
                for (int i = 0; i < this.categories.size(); ++i) {
                    CharSet charSet5 = charSet.intersection((CharSet)this.categories.elementAt(i));
                    if (charSet5.empty()) continue;
                    ((StringBuffer)object).append((char)(256 + i));
                    if (charSet5.equals(charSet)) break;
                }
                this.expressions.put(object2, ((StringBuffer)object).toString());
            }
            RuleBasedBreakIterator.this.charCategoryTable = new CompactByteArray(0);
            for (int i = 0; i < this.categories.size(); ++i) {
                charSet = (CharSet)this.categories.elementAt(i);
                object = charSet.getChars();
                while (object.hasMoreElements()) {
                    char[] cArray = (char[])object.nextElement();
                    if (i != 0) {
                        RuleBasedBreakIterator.this.charCategoryTable.setElementAt(cArray[0], cArray[1], (byte)i);
                        continue;
                    }
                    RuleBasedBreakIterator.this.charCategoryTable.setElementAt(cArray[0], cArray[1], (byte)-1);
                }
            }
            RuleBasedBreakIterator.this.charCategoryTable.compact();
            RuleBasedBreakIterator.this.numCategories = this.categories.size();
        }

        private void buildStateTable(Vector vector) {
            this.tempStateTable = new Vector();
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator.this.numCategories + 1]);
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                if (string.charAt(0) == '!') continue;
                this.parseRule(string, true);
            }
            this.finishBuildingStateTable(true);
        }

        protected void error(String string, int n, String string2) {
            throw new IllegalArgumentException("Parse error at position (" + n + "): " + string + "\n" + string2.substring(0, n) + " -here- " + string2.substring(n));
        }

        private void updateStateTable(Vector vector, String string, short s) {
            int n;
            short[] sArray = new short[RuleBasedBreakIterator.this.numCategories + 1];
            for (n = 0; n < string.length(); ++n) {
                sArray[string.charAt((int)n) - 256] = s;
            }
            for (n = 0; n < vector.size(); ++n) {
                this.mergeStates((Integer)vector.elementAt(n), sArray, vector);
            }
        }

        private Vector buildRuleList(String string) {
            Vector vector = new Vector();
            Stack stack = new Stack();
            int n = 0;
            int n2 = 0;
            char c = '\u0000';
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (string.length() != 0 && string.charAt(string.length() - 1) != ';') {
                string = string + ";";
            }
            while (n < string.length()) {
                c = string.charAt(n);
                switch (c) {
                    case '\\': {
                        ++n;
                        break;
                    }
                    case '(': 
                    case '<': 
                    case '[': 
                    case '{': {
                        if (n4 == 60) {
                            this.error("Can't nest brackets inside <>", n, string);
                        }
                        if (n4 == 91 && c != '[') {
                            this.error("Can't nest anything in [] but []", n, string);
                        }
                        if (c == '<' && (bl || bl2)) {
                            this.error("Unknown variable name", n, string);
                        }
                        n4 = c;
                        stack.push(new Character(c));
                        if (c != '<') break;
                        bl3 = true;
                        break;
                    }
                    case ')': 
                    case '>': 
                    case ']': 
                    case '}': {
                        char c2 = '\u0000';
                        switch (n4) {
                            case 123: {
                                c2 = '}';
                                break;
                            }
                            case 91: {
                                c2 = ']';
                                break;
                            }
                            case 40: {
                                c2 = ')';
                                break;
                            }
                            case 60: {
                                c2 = '>';
                            }
                        }
                        if (c != c2) {
                            this.error("Unbalanced parentheses", n, string);
                        }
                        if (n3 == n4) {
                            this.error("Parens don't contain anything", n, string);
                        }
                        stack.pop();
                        if (!stack.empty()) {
                            n4 = ((Character)stack.peek()).charValue();
                            break;
                        }
                        n4 = 0;
                        break;
                    }
                    case '*': {
                        if ("=/{(|}*;\u0000".indexOf(n3) == -1) break;
                        this.error("Misplaced asterisk", n, string);
                        break;
                    }
                    case '?': {
                        if (n3 == 42) break;
                        this.error("Misplaced ?", n, string);
                        break;
                    }
                    case '=': {
                        if (bl || bl2) {
                            this.error("More than one = or / in rule", n, string);
                        }
                        bl = true;
                        break;
                    }
                    case '/': {
                        if (bl || bl2) {
                            this.error("More than one = or / in rule", n, string);
                        }
                        if (bl3) {
                            this.error("Unknown variable name", n, string);
                        }
                        bl2 = true;
                        break;
                    }
                    case '!': {
                        if (n3 == 59 || n3 == 0) break;
                        this.error("! can only occur at the beginning of a rule", n, string);
                        break;
                    }
                    case '.': {
                        break;
                    }
                    case '-': 
                    case ':': 
                    case '^': {
                        if (n4 == 91 || n4 == 60) break;
                        this.error("Illegal character", n, string);
                        break;
                    }
                    case ';': {
                        if (n3 == 59 || n3 == 0) {
                            this.error("Empty rule", n, string);
                        }
                        if (!stack.empty()) {
                            this.error("Unbalanced parenheses", n, string);
                        }
                        if (!stack.empty()) break;
                        if (bl) {
                            string = this.processSubstitution(string.substring(n2, n), string, n + 1);
                        } else {
                            if (bl3) {
                                this.error("Unknown variable name", n, string);
                            }
                            vector.addElement(string.substring(n2, n));
                        }
                        n2 = n + 1;
                        bl3 = false;
                        bl2 = false;
                        bl = false;
                        break;
                    }
                    case '|': {
                        if (n3 == 124) {
                            this.error("Empty alternative", n, string);
                        }
                        if (!stack.empty() && n4 == 40) break;
                        this.error("Misplaced |", n, string);
                        break;
                    }
                    default: {
                        if (c < ' ' || c >= '\u007f' || Character.isLetter(c) || Character.isDigit(c)) break;
                        this.error("Illegal character", n, string);
                    }
                }
                n3 = c;
                ++n;
            }
            if (vector.size() == 0) {
                this.error("No valid rules in description", n, string);
            }
            return vector;
        }

        private void setLoopingStates(Vector vector, Vector vector2) {
            if (!this.loopingStates.isEmpty()) {
                int n;
                int n2 = (Integer)this.loopingStates.lastElement();
                for (n = 0; n < vector2.size(); ++n) {
                    this.eliminateBackfillStates((Integer)vector2.elementAt(n));
                }
                for (n = 0; n < this.statesToBackfill.size(); ++n) {
                    int n3 = (Integer)this.statesToBackfill.elementAt(n);
                    short[] sArray = (short[])this.tempStateTable.elementAt(n3);
                    sArray[((RuleBasedBreakIterator)RuleBasedBreakIterator.this).numCategories] = (short)(sArray[RuleBasedBreakIterator.this.numCategories] & 0xE000 | n2);
                }
                this.statesToBackfill.removeAllElements();
                this.loopingStates.removeAllElements();
            }
            if (vector != null) {
                this.loopingStates = (Vector)vector.clone();
            }
        }

        protected String processSubstitution(String string, String string2, int n) {
            int n2 = string.indexOf(61);
            String string3 = string.substring(0, n2);
            String string4 = string.substring(n2 + 1);
            this.handleSpecialSubstitution(string3, string4, n, string2);
            if (string4.length() == 0) {
                this.error("Nothing on right-hand side of =", n, string2);
            }
            if (string3.length() == 0) {
                this.error("Nothing on left-hand side of =", n, string2);
            }
            if (string3.length() == 2 && string3.charAt(0) != '\\') {
                this.error("Illegal left-hand side for =", n, string2);
            }
            if (string3.length() >= 3 && string3.charAt(0) != '<' && string3.charAt(n2 - 1) != '>') {
                this.error("Illegal left-hand side for =", n, string2);
            }
            if (!(string4.charAt(0) == '[' && string4.charAt(string4.length() - 1) == ']' || string4.charAt(0) == '(' && string4.charAt(string4.length() - 1) == ')')) {
                this.error("Illegal right-hand side for =", n, string2);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2.substring(0, n));
            int n3 = n;
            int n4 = string2.indexOf(string3, n);
            while (n4 != -1) {
                stringBuffer.append(string2.substring(n3, n4));
                stringBuffer.append(string4);
                n3 = n4 + string3.length();
                n4 = string2.indexOf(string3, n3);
            }
            stringBuffer.append(string2.substring(n3));
            return stringBuffer.toString();
        }

        protected void handleSpecialSubstitution(String string, String string2, int n, String string3) {
            if (string.equals("<ignore>")) {
                if (string2.charAt(0) == '(') {
                    this.error("Ignore group can't be enclosed in (", n, string3);
                }
                this.ignoreChars = CharSet.parseString(string2);
            }
        }
    }

    private static final class SafeCharIterator
    implements CharacterIterator,
    Cloneable {
        private CharacterIterator base;
        private int rangeStart;
        private int rangeLimit;
        private int currentIndex;

        public char current() {
            if (this.currentIndex < this.rangeStart || this.currentIndex >= this.rangeLimit) {
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char first() {
            return this.setIndex(this.rangeStart);
        }

        public char last() {
            return this.setIndex(this.rangeLimit - 1);
        }

        public char next() {
            ++this.currentIndex;
            if (this.currentIndex >= this.rangeLimit) {
                this.currentIndex = this.rangeLimit;
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char previous() {
            --this.currentIndex;
            if (this.currentIndex < this.rangeStart) {
                this.currentIndex = this.rangeStart;
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public int getBeginIndex() {
            return this.rangeStart;
        }

        public int getEndIndex() {
            return this.rangeLimit;
        }

        public int getIndex() {
            return this.currentIndex;
        }

        public char setIndex(int n) {
            if (n < this.rangeStart || n > this.rangeLimit) {
                throw new IllegalArgumentException("Invalid position");
            }
            this.currentIndex = n;
            return this.current();
        }

        public Object clone() {
            CharacterIterator characterIterator;
            SafeCharIterator safeCharIterator = null;
            try {
                safeCharIterator = (SafeCharIterator)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("Clone not supported: " + cloneNotSupportedException);
            }
            safeCharIterator.base = characterIterator = (CharacterIterator)this.base.clone();
            return safeCharIterator;
        }

        SafeCharIterator(CharacterIterator characterIterator) {
            this.base = characterIterator;
            this.rangeStart = characterIterator.getBeginIndex();
            this.rangeLimit = characterIterator.getEndIndex();
            this.currentIndex = characterIterator.getIndex();
        }
    }
}

