/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.PropertyPermissionCollection;

public final class PropertyPermission
extends BasicPermission {
    private static final int READ = 1;
    private static final int WRITE = 2;
    private static final int ALL = 3;
    private static final int NONE = 0;
    private transient int mask;
    private String actions;

    int getMask() {
        return this.mask;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private void init(int n) {
        if ((n & 3) != n) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (n == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (this.getName() == null) {
            throw new NullPointerException("name can't be null");
        }
        this.mask = n;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(PropertyPermission.getMask(this.actions));
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission = (PropertyPermission)object;
        return this.mask == propertyPermission.mask && this.getName().equals(propertyPermission.getName());
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = PropertyPermission.getActions(this.mask);
        }
        return this.actions;
    }

    static String getActions(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if ((n & 1) == 1) {
            bl = true;
            stringBuffer.append("read");
        }
        if ((n & 2) == 2) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("write");
        }
        return stringBuffer.toString();
    }

    private static int getMask(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        if (string == "read") {
            return 1;
        }
        if (string == "write") {
            return 2;
        }
        if (string == "read,write") {
            return 3;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 3 || cArray[n2 - 3] != 'r' && cArray[n2 - 3] != 'R' || cArray[n2 - 2] != 'e' && cArray[n2 - 2] != 'E' || cArray[n2 - 1] != 'a' && cArray[n2 - 1] != 'A' || cArray[n2] != 'd' && cArray[n2] != 'D')) {
                n3 = 4;
                n |= 1;
            } else if (!(n2 < 4 || cArray[n2 - 4] != 'w' && cArray[n2 - 4] != 'W' || cArray[n2 - 3] != 'r' && cArray[n2 - 3] != 'R' || cArray[n2 - 2] != 'i' && cArray[n2 - 2] != 'I' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 5;
                n |= 2;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            boolean bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        return n;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission = (PropertyPermission)permission;
        return (this.mask & propertyPermission.mask) == propertyPermission.mask && super.implies(propertyPermission);
    }

    public PermissionCollection newPermissionCollection() {
        return new PropertyPermissionCollection();
    }

    public PropertyPermission(String string, String string2) {
        super(string, string2);
        this.init(PropertyPermission.getMask(string2));
    }
}

