/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.Gregorian;

public class SimpleTimeZone
extends TimeZone {
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int startTimeMode;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int endTimeMode;
    private int startYear;
    private int rawOffset;
    private boolean useDaylight = false;
    private static final int millisPerHour = 3600000;
    private static final int millisPerDay = 86400000;
    private final byte[] monthLength = staticMonthLength;
    private static final byte[] staticMonthLength = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final byte[] staticLeapMonthLength = new byte[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int startMode;
    private int endMode;
    private int dstSavings;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    public static final int WALL_TIME = 0;
    public static final int STANDARD_TIME = 1;
    public static final int UTC_TIME = 2;
    static final long serialVersionUID = -403250971215465050L;
    static final int currentSerialVersion = 2;
    private int serialVersionOnStream = 2;

    public int getDSTSavings() {
        if (this.useDaylight) {
            return this.dstSavings;
        }
        return 0;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public synchronized int hashCode() {
        return this.startMonth ^ this.startDay ^ this.startDayOfWeek ^ this.startTime ^ this.endMonth ^ this.endDay ^ this.endDayOfWeek ^ this.endTime ^ this.rawOffset;
    }

    private void decodeEndRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.endDay != 0) {
            if (this.endMonth < 0 || this.endMonth > 11) {
                throw new IllegalArgumentException("Illegal end month " + this.endMonth);
            }
            if (this.endTime < 0 || this.endTime >= 86400000) {
                throw new IllegalArgumentException("Illegal end time " + this.endTime);
            }
            if (this.endDayOfWeek == 0) {
                this.endMode = 1;
            } else {
                if (this.endDayOfWeek > 0) {
                    this.endMode = 2;
                } else {
                    this.endDayOfWeek = -this.endDayOfWeek;
                    if (this.endDay > 0) {
                        this.endMode = 3;
                    } else {
                        this.endDay = -this.endDay;
                        this.endMode = 4;
                    }
                }
                if (this.endDayOfWeek > 7) {
                    throw new IllegalArgumentException("Illegal end day of week " + this.endDayOfWeek);
                }
            }
            if (this.endMode == 2) {
                if (this.endDay < -5 || this.endDay > 5) {
                    throw new IllegalArgumentException("Illegal end day of week in month " + this.endDay);
                }
            } else if (this.endDay < 1 || this.endDay > staticMonthLength[this.endMonth]) {
                throw new IllegalArgumentException("Illegal end day " + this.endDay);
            }
        }
    }

    private void decodeRules() {
        this.decodeStartRule();
        this.decodeEndRule();
    }

    private void decodeStartRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.startDay != 0) {
            if (this.startMonth < 0 || this.startMonth > 11) {
                throw new IllegalArgumentException("Illegal start month " + this.startMonth);
            }
            if (this.startTime < 0 || this.startTime >= 86400000) {
                throw new IllegalArgumentException("Illegal start time " + this.startTime);
            }
            if (this.startDayOfWeek == 0) {
                this.startMode = 1;
            } else {
                if (this.startDayOfWeek > 0) {
                    this.startMode = 2;
                } else {
                    this.startDayOfWeek = -this.startDayOfWeek;
                    if (this.startDay > 0) {
                        this.startMode = 3;
                    } else {
                        this.startDay = -this.startDay;
                        this.startMode = 4;
                    }
                }
                if (this.startDayOfWeek > 7) {
                    throw new IllegalArgumentException("Illegal start day of week " + this.startDayOfWeek);
                }
            }
            if (this.startMode == 2) {
                if (this.startDay < -5 || this.startDay > 5) {
                    throw new IllegalArgumentException("Illegal start day of week in month " + this.startDay);
                }
            } else if (this.startDay < 1 || this.startDay > staticMonthLength[this.startMonth]) {
                throw new IllegalArgumentException("Illegal start day " + this.startDay);
            }
        }
    }

    private void makeRulesCompatible() {
        switch (this.startMode) {
            case 1: {
                this.startDay = 1 + this.startDay / 7;
                this.startDayOfWeek = 1;
                break;
            }
            case 3: {
                if (this.startDay == 1) break;
                this.startDay = 1 + this.startDay / 7;
                break;
            }
            case 4: {
                this.startDay = this.startDay >= 30 ? -1 : 1 + this.startDay / 7;
            }
        }
        switch (this.endMode) {
            case 1: {
                this.endDay = 1 + this.endDay / 7;
                this.endDayOfWeek = 1;
                break;
            }
            case 3: {
                if (this.endDay == 1) break;
                this.endDay = 1 + this.endDay / 7;
                break;
            }
            case 4: {
                this.endDay = this.endDay >= 30 ? -1 : 1 + this.endDay / 7;
            }
        }
        switch (this.startTimeMode) {
            case 2: {
                this.startTime += this.rawOffset;
            }
        }
        while (this.startTime < 0) {
            this.startTime += 86400000;
            this.startDayOfWeek = 1 + (this.startDayOfWeek + 5) % 7;
        }
        while (this.startTime >= 86400000) {
            this.startTime -= 86400000;
            this.startDayOfWeek = 1 + this.startDayOfWeek % 7;
        }
        switch (this.endTimeMode) {
            case 2: {
                this.endTime += this.rawOffset + this.dstSavings;
                break;
            }
            case 1: {
                this.endTime += this.dstSavings;
            }
        }
        while (this.endTime < 0) {
            this.endTime += 86400000;
            this.endDayOfWeek = 1 + (this.endDayOfWeek + 5) % 7;
        }
        while (this.endTime >= 86400000) {
            this.endTime -= 86400000;
            this.endDayOfWeek = 1 + this.endDayOfWeek % 7;
        }
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    private byte[] packRules() {
        byte[] byArray = new byte[]{(byte)this.startDay, (byte)this.startDayOfWeek, (byte)this.endDay, (byte)this.endDayOfWeek, (byte)this.startTimeMode, (byte)this.endTimeMode};
        return byArray;
    }

    private int[] packTimes() {
        int[] nArray = new int[]{this.startTime, this.endTime};
        return nArray;
    }

    public void setDSTSavings(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal daylight saving value: " + n);
        }
        this.dstSavings = n;
    }

    public void setRawOffset(int n) {
        this.rawOffset = n;
    }

    public void setStartYear(int n) {
        this.startYear = n;
    }

    public void setEndRule(int n, int n2, int n3) {
        this.setEndRule(n, n2, 0, n3);
    }

    public void setStartRule(int n, int n2, int n3) {
        this.setStartRule(n, n2, 0, n3);
    }

    public void setEndRule(int n, int n2, int n3, int n4) {
        this.endMonth = n;
        this.endDay = n2;
        this.endDayOfWeek = n3;
        this.endTime = n4;
        this.endTimeMode = 0;
        this.decodeEndRule();
    }

    public void setStartRule(int n, int n2, int n3, int n4) {
        this.startMonth = n;
        this.startDay = n2;
        this.startDayOfWeek = n3;
        this.startTime = n4;
        this.startTimeMode = 0;
        this.decodeStartRule();
    }

    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        byte by;
        if (n3 < 0 || n3 > 11) {
            throw new IllegalArgumentException("Illegal month " + n3);
        }
        if (n == 1 && Gregorian.isLeapYear(n2)) {
            by = staticLeapMonthLength[n3];
            n7 = n3 > 1 ? staticLeapMonthLength[n3 - 1] : 31;
        } else {
            by = staticMonthLength[n3];
            int n8 = n7 = n3 > 1 ? staticMonthLength[n3 - 1] : 31;
        }
        if (n != 1 && n != 0 || n3 < 0 || n3 > 11 || n4 < 1 || n4 > by || n5 < 1 || n5 > 7 || n6 < 0 || n6 >= 86400000) {
            throw new IllegalArgumentException();
        }
        return this.getOffset(n, n2, n3, n4, n5, n6, by, n7);
    }

    private int getOffset(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = this.rawOffset;
        if (!this.useDaylight || n2 < this.startYear || n != 1) {
            return n9;
        }
        boolean bl = this.startMonth > this.endMonth;
        int n10 = SimpleTimeZone.compareToRule(n3, n7, n8, n4, n5, n6, this.startTimeMode == 2 ? -this.rawOffset : 0, this.startMode, this.startMonth, this.startDayOfWeek, this.startDay, this.startTime);
        int n11 = 0;
        if (bl != n10 >= 0) {
            n11 = SimpleTimeZone.compareToRule(n3, n7, n8, n4, n5, n6, this.endTimeMode == 0 ? this.dstSavings : (this.endTimeMode == 2 ? -this.rawOffset : 0), this.endMode, this.endMonth, this.endDayOfWeek, this.endDay, this.endTime);
        }
        if (!bl && n10 >= 0 && n11 < 0 || bl && (n10 >= 0 || n11 < 0)) {
            n9 += this.dstSavings;
        }
        return n9;
    }

    private static int compareToRule(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        n6 += n7;
        while (n6 >= 86400000) {
            n6 -= 86400000;
            n5 = 1 + n5 % 7;
            if (++n4 <= n2) continue;
            n4 = 1;
            ++n;
        }
        while (n6 < 0) {
            n6 += 86400000;
            n5 = 1 + (n5 + 5) % 7;
            if (--n4 >= 1) continue;
            n4 = n3;
            --n;
        }
        if (n < n9) {
            return -1;
        }
        if (n > n9) {
            return 1;
        }
        int n13 = 0;
        switch (n8) {
            case 1: {
                n13 = n11;
                break;
            }
            case 2: {
                if (n11 > 0) {
                    n13 = 1 + (n11 - 1) * 7 + (7 + n10 - (n5 - n4 + 1)) % 7;
                    break;
                }
                n13 = n2 + (n11 + 1) * 7 - (7 + (n5 + n2 - n4) - n10) % 7;
                break;
            }
            case 3: {
                n13 = n11 + (49 + n10 - n11 - n5 + n4) % 7;
                break;
            }
            case 4: {
                n13 = n11 - (49 - n10 + n11 + n5 - n4) % 7;
            }
        }
        if (n4 < n13) {
            return -1;
        }
        if (n4 > n13) {
            return 1;
        }
        if (n6 < n12) {
            return -1;
        }
        if (n6 > n12) {
            return 1;
        }
        return 0;
    }

    public void setEndRule(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.setEndRule(n, n2, -n3, n4);
        } else {
            this.setEndRule(n, -n2, -n3, n4);
        }
    }

    public void setStartRule(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.setStartRule(n, n2, -n3, n4);
        } else {
            this.setStartRule(n, -n2, -n3, n4);
        }
    }

    public int getOffset(long l) {
        return this.getOffsets(l, null);
    }

    int getOffsets(long l, int[] nArray) {
        int n;
        if (!this.useDaylight) {
            n = this.rawOffset;
        } else {
            CalendarDate calendarDate = Gregorian.getCalendarDate(l + (long)this.rawOffset);
            int n2 = calendarDate.getYear();
            if (n2 <= 0) {
                n = this.rawOffset;
            } else {
                int n3 = calendarDate.getMonth();
                int n4 = staticMonthLength[n3];
                int n5 = staticMonthLength[(n3 + 11) % 12];
                if (Gregorian.isLeapYear(n2)) {
                    if (n3 == 1) {
                        ++n4;
                    } else if (n3 == 2) {
                        ++n5;
                    }
                }
                n = this.getOffset(1, n2, n3, calendarDate.getDate(), calendarDate.getDayOfWeek(), calendarDate.getTimeOfDay(), n4, n5);
            }
        }
        if (nArray != null) {
            nArray[0] = this.rawOffset;
            nArray[1] = n - this.rawOffset;
        }
        return n;
    }

    private void unpackRules(byte[] byArray) {
        this.startDay = byArray[0];
        this.startDayOfWeek = byArray[1];
        this.endDay = byArray[2];
        this.endDayOfWeek = byArray[3];
        if (byArray.length >= 6) {
            this.startTimeMode = byArray[4];
            this.endTimeMode = byArray[5];
        }
    }

    private void unpackTimes(int[] nArray) {
        this.startTime = nArray[0];
        this.endTime = nArray[1];
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            if (this.startDayOfWeek == 0) {
                this.startDayOfWeek = 1;
            }
            if (this.endDayOfWeek == 0) {
                this.endDayOfWeek = 1;
            }
            this.endMode = 2;
            this.startMode = 2;
            this.dstSavings = 3600000;
        } else {
            int n = objectInputStream.readInt();
            byte[] byArray = new byte[n];
            objectInputStream.readFully(byArray);
            this.unpackRules(byArray);
        }
        if (this.serialVersionOnStream >= 2) {
            int[] nArray = (int[])objectInputStream.readObject();
            this.unpackTimes(nArray);
        }
        this.serialVersionOnStream = 2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = this.packRules();
        int[] nArray = this.packTimes();
        this.makeRulesCompatible();
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray);
        objectOutputStream.writeObject(nArray);
        this.unpackRules(byArray);
        this.unpackTimes(nArray);
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)object;
        return this.getID().equals(simpleTimeZone.getID()) && this.hasSameRules(simpleTimeZone);
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.getID() + ",offset=" + this.rawOffset + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylight + ",startYear=" + this.startYear + ",startMode=" + this.startMode + ",startMonth=" + this.startMonth + ",startDay=" + this.startDay + ",startDayOfWeek=" + this.startDayOfWeek + ",startTime=" + this.startTime + ",startTimeMode=" + this.startTimeMode + ",endMode=" + this.endMode + ",endMonth=" + this.endMonth + ",endDay=" + this.endDay + ",endDayOfWeek=" + this.endDayOfWeek + ",endTime=" + this.endTime + ",endTimeMode=" + this.endTimeMode + ']';
    }

    public SimpleTimeZone(int n, String string) {
        this.rawOffset = n;
        this.setID(string);
        this.dstSavings = 3600000;
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this(n, string, n2, n3, n4, n5, 0, n6, n7, n8, n9, 0, 3600000);
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this(n, string, n2, n3, n4, n5, 0, n6, n7, n8, n9, 0, n10);
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        if (n7 == 0 && n8 == 1 && n9 == 0 && n10 == 0 && n11 == 0 && n12 > 0) {
            n7 = 11;
            n8 = 31;
            n10 = 86400000 - n12;
            n11 = 1;
        }
        this.setID(string);
        this.rawOffset = n;
        this.startMonth = n2;
        this.startDay = n3;
        this.startDayOfWeek = n4;
        this.startTime = n5;
        this.startTimeMode = n6;
        this.endMonth = n7;
        this.endDay = n8;
        this.endDayOfWeek = n9;
        this.endTime = n10;
        this.endTimeMode = n11;
        this.dstSavings = n12;
        this.decodeRules();
        if (n12 <= 0) {
            throw new IllegalArgumentException("Illegal daylight saving value: " + n12);
        }
    }

    public boolean inDaylightTime(Date date) {
        return this.getOffset(date.getTime()) != this.rawOffset;
    }

    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (!(timeZone instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)timeZone;
        return this.rawOffset == simpleTimeZone.rawOffset && this.useDaylight == simpleTimeZone.useDaylight && (!this.useDaylight || this.dstSavings == simpleTimeZone.dstSavings && this.startMode == simpleTimeZone.startMode && this.startMonth == simpleTimeZone.startMonth && this.startDay == simpleTimeZone.startDay && this.startDayOfWeek == simpleTimeZone.startDayOfWeek && this.startTime == simpleTimeZone.startTime && this.startTimeMode == simpleTimeZone.startTimeMode && this.endMode == simpleTimeZone.endMode && this.endMonth == simpleTimeZone.endMonth && this.endDay == simpleTimeZone.endDay && this.endDayOfWeek == simpleTimeZone.endDayOfWeek && this.endTime == simpleTimeZone.endTime && this.endTimeMode == simpleTimeZone.endTimeMode && this.startYear == simpleTimeZone.startYear);
    }
}

