/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.apache.crimson.parser.ElementValidator;
import org.apache.crimson.parser.EndOfInputException;
import org.apache.crimson.parser.Parser2;
import org.apache.crimson.parser.XmlReader;
import org.apache.crimson.util.XmlChars;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class InputEntity
implements Locator {
    private int start;
    private int finish;
    private char[] buf;
    private int lineNumber = 1;
    private boolean returnedFirstHalf = false;
    private boolean maybeInCRLF = false;
    private String name;
    private InputEntity next;
    private InputSource input;
    private Reader reader;
    private boolean isClosed;
    private ErrorHandler errHandler;
    private Locale locale;
    private StringBuffer rememberedText;
    private int startRemember;
    private boolean isPE;
    private static final int BUFSIZ = 8193;
    private static final char[] newline = new char[]{'\n'};

    public char getNameChar() throws IOException, SAXException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            char c;
            if (XmlChars.isNameChar(c = this.buf[this.start++])) {
                return c;
            }
            --this.start;
        }
        return '\u0000';
    }

    public char getc() throws IOException, SAXException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            char c = this.buf[this.start++];
            if (this.returnedFirstHalf) {
                if (c >= '\udc00' && c <= '\udfff') {
                    this.returnedFirstHalf = false;
                    return c;
                }
                this.fatal("P-070", new Object[]{Integer.toHexString(c)});
            }
            if (c >= ' ' && c <= '\ud7ff' || c == '\t' || c >= '\ue000' && c <= '\ufffd') {
                return c;
            }
            if (c == '\r' && !this.isInternal()) {
                this.maybeInCRLF = true;
                c = this.getc();
                if (c != '\n') {
                    this.ungetc();
                }
                this.maybeInCRLF = false;
                ++this.lineNumber;
                return '\n';
            }
            if (c == '\n' || c == '\r') {
                if (!this.isInternal() && !this.maybeInCRLF) {
                    ++this.lineNumber;
                }
                return c;
            }
            if (c >= '\ud800' && c < '\udc00') {
                this.returnedFirstHalf = true;
                return c;
            }
            this.fatal("P-071", new Object[]{Integer.toHexString(c)});
        }
        throw new EndOfInputException();
    }

    public int getColumnNumber() {
        return -1;
    }

    public int getLineNumber() {
        Locator locator = this.getLocator();
        if (locator == this) {
            return this.lineNumber;
        }
        return locator.getLineNumber();
    }

    private InputEntity() {
    }

    public void close() {
        try {
            if (this.reader != null && !this.isClosed) {
                this.reader.close();
            }
            this.isClosed = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void fillbuf() throws IOException, SAXException {
        boolean bl;
        if (this.reader == null || this.isClosed) {
            return;
        }
        if (this.startRemember != 0) {
            if (this.rememberedText == null) {
                this.rememberedText = new StringBuffer(this.buf.length);
            }
            this.rememberedText.append(this.buf, this.startRemember, this.start - this.startRemember);
        }
        boolean bl2 = bl = this.finish > 0 && this.start > 0;
        if (bl) {
            --this.start;
        }
        int n = this.finish - this.start;
        System.arraycopy(this.buf, this.start, this.buf, 0, n);
        this.start = 0;
        this.finish = n;
        try {
            n = this.buf.length - n;
            n = this.reader.read(this.buf, this.finish, n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.fatal("P-075", new Object[]{unsupportedEncodingException.getMessage()});
        }
        catch (CharConversionException charConversionException) {
            this.fatal("P-076", new Object[]{charConversionException.getMessage()});
        }
        if (n >= 0) {
            this.finish += n;
        } else {
            this.close();
        }
        if (bl) {
            ++this.start;
        }
        if (this.startRemember != 0) {
            this.startRemember = 1;
        }
    }

    public void startRemembering() {
        if (this.startRemember != 0) {
            throw new InternalError();
        }
        this.startRemember = this.start;
    }

    public void ungetc() {
        if (this.start == 0) {
            throw new InternalError("ungetc");
        }
        --this.start;
        if (this.buf[this.start] == '\n' || this.buf[this.start] == '\r') {
            if (!this.isInternal()) {
                --this.lineNumber;
            }
        } else if (this.returnedFirstHalf) {
            this.returnedFirstHalf = false;
        }
    }

    public boolean isDocument() {
        return this.next == null;
    }

    public boolean isEOF() throws IOException, SAXException {
        if (this.start >= this.finish) {
            this.fillbuf();
            return this.start >= this.finish;
        }
        return false;
    }

    public boolean isInternal() {
        return this.reader == null;
    }

    public boolean isParameterEntity() {
        return this.isPE;
    }

    boolean isXmlDeclOrTextDeclPrefix() throws IOException, SAXException {
        int n;
        String string = "<?xml";
        int n2 = string.length();
        int n3 = n2 + 1;
        if (this.finish <= this.start || this.finish - this.start < n3) {
            this.fillbuf();
        }
        if (this.finish <= this.start) {
            return false;
        }
        for (n = 0; n < n2 && this.start + n < this.finish; ++n) {
            if (this.buf[this.start + n] == string.charAt(n)) continue;
            return false;
        }
        if (n < n2) {
            if (this.reader == null || this.isClosed) {
                return false;
            }
            this.fillbuf();
            return this.isXmlDeclOrTextDeclPrefix();
        }
        return XmlChars.isSpace(this.buf[n]);
    }

    public boolean maybeWhitespace() throws IOException, SAXException {
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            char c;
            if (this.finish <= this.start) {
                this.fillbuf();
            }
            if (this.finish <= this.start) {
                return bl;
            }
            if ((c = this.buf[this.start++]) != ' ' && c != '\t' && c != '\n' && c != '\r') break;
            bl = true;
            if (c != '\n' && c != '\r' || this.isInternal()) continue;
            if (c != '\n' || !bl2) {
                ++this.lineNumber;
                bl2 = false;
            }
            if (c != '\r') continue;
            bl2 = true;
        }
        --this.start;
        return bl;
    }

    public boolean peekc(char c) throws IOException, SAXException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            if (this.buf[this.start] == c) {
                ++this.start;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean checkSurrogatePair(int n) throws SAXException {
        if (n + 1 >= this.finish) {
            return false;
        }
        char c = this.buf[n++];
        char c2 = this.buf[n];
        if (c >= '\ud800' && c < '\udc00' && c2 >= '\udc00' && c2 <= '\udfff') {
            return true;
        }
        this.fatal("P-074", new Object[]{Integer.toHexString(c & 0xFFFF), Integer.toHexString(c2 & 0xFFFF)});
        return false;
    }

    public String getEncoding() {
        if (this.reader == null) {
            return null;
        }
        if (this.reader instanceof XmlReader) {
            return ((XmlReader)this.reader).getEncoding();
        }
        if (this.reader instanceof InputStreamReader) {
            return ((InputStreamReader)this.reader).getEncoding();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getPublicId() {
        Locator locator = this.getLocator();
        if (locator == this) {
            return this.input.getPublicId();
        }
        return locator.getPublicId();
    }

    public String getSystemId() {
        Locator locator = this.getLocator();
        if (locator == this) {
            return this.input.getSystemId();
        }
        return locator.getSystemId();
    }

    public String rememberText() {
        String string;
        if (this.rememberedText != null) {
            this.rememberedText.append(this.buf, this.startRemember, this.start - this.startRemember);
            string = this.rememberedText.toString();
        } else {
            string = new String(this.buf, this.startRemember, this.start - this.startRemember);
        }
        this.startRemember = 0;
        this.rememberedText = null;
        return string;
    }

    public boolean peek(String string, char[] cArray) throws IOException, SAXException {
        int n;
        int n2 = cArray != null ? cArray.length : string.length();
        if (this.finish <= this.start || this.finish - this.start < n2) {
            this.fillbuf();
        }
        if (this.finish <= this.start) {
            return false;
        }
        if (cArray != null) {
            for (n = 0; n < n2 && this.start + n < this.finish; ++n) {
                if (this.buf[this.start + n] == cArray[n]) continue;
                return false;
            }
        } else {
            for (n = 0; n < n2 && this.start + n < this.finish; ++n) {
                if (this.buf[this.start + n] == string.charAt(n)) continue;
                return false;
            }
        }
        if (n < n2) {
            if (this.reader == null || this.isClosed) {
                return false;
            }
            if (n2 > this.buf.length) {
                this.fatal("P-077", new Object[]{new Integer(this.buf.length)});
            }
            this.fillbuf();
            return this.peek(string, cArray);
        }
        this.start += n2;
        return true;
    }

    public InputEntity pop() throws IOException {
        this.close();
        return this.next;
    }

    private void checkRecursion(InputEntity inputEntity) throws SAXException {
        if (inputEntity == null) {
            return;
        }
        inputEntity = inputEntity.next;
        while (inputEntity != null) {
            if (inputEntity.name != null && inputEntity.name.equals(this.name)) {
                this.fatal("P-069", new Object[]{this.name});
            }
            inputEntity = inputEntity.next;
        }
    }

    public boolean ignorableWhitespace(ContentHandler contentHandler) throws IOException, SAXException {
        boolean bl = false;
        int n = this.start;
        block5: while (true) {
            if (this.finish <= this.start) {
                if (bl) {
                    contentHandler.ignorableWhitespace(this.buf, n, this.start - n);
                }
                this.fillbuf();
                n = this.start;
            }
            if (this.finish <= this.start) {
                return bl;
            }
            char c = this.buf[this.start++];
            switch (c) {
                case '\n': {
                    if (!this.isInternal()) {
                        ++this.lineNumber;
                    }
                }
                case '\t': 
                case ' ': {
                    bl = true;
                    continue block5;
                }
                case '\r': {
                    bl = true;
                    if (!this.isInternal()) {
                        ++this.lineNumber;
                    }
                    contentHandler.ignorableWhitespace(this.buf, n, this.start - 1 - n);
                    contentHandler.ignorableWhitespace(newline, 0, 1);
                    if (this.start >= this.finish || this.buf[this.start] == '\n') {
                        // empty if block
                    }
                    n = ++this.start;
                    continue block5;
                }
            }
            break;
        }
        this.ungetc();
        if (bl) {
            contentHandler.ignorableWhitespace(this.buf, n, this.start - n);
        }
        return bl;
    }

    private Locator getLocator() {
        InputEntity inputEntity = this;
        while (inputEntity != null && inputEntity.input == null) {
            inputEntity = inputEntity.next;
        }
        return inputEntity == null ? this : inputEntity;
    }

    private void fatal(String string, Object[] objectArray) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(Parser2.messages.getMessage(this.locale, string, objectArray), this);
        this.close();
        this.errHandler.fatalError(sAXParseException);
        throw sAXParseException;
    }

    private static String convertToFileURL(String string) {
        String string2 = new File(string).getAbsolutePath();
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return "file:" + string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean parsedContent(ContentHandler contentHandler, ElementValidator elementValidator) throws IOException, SAXException {
        int n;
        int n2 = n = this.start;
        boolean bl = false;
        while (true) {
            block21: {
                char c;
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    if (n < this.finish) break block22;
                                    if (n > n2) {
                                        elementValidator.text();
                                        contentHandler.characters(this.buf, n2, n - n2);
                                        bl = true;
                                        this.start = n;
                                    }
                                    if (this.isEOF()) {
                                        return bl;
                                    }
                                    n2 = this.start;
                                    n = n2 - 1;
                                    break block21;
                                }
                                c = this.buf[n];
                                if (c > ']' && c <= '\ud7ff' || c < '&' && c >= ' ' || c > '<' && c < ']' || c > '&' && c < '<' || c == '\t' || c >= '\ue000' && c <= '\ufffd') break block21;
                                if (c == '<' || c == '&') break;
                                if (c != '\n') break block23;
                                if (!this.isInternal()) {
                                    ++this.lineNumber;
                                }
                                break block21;
                            }
                            if (c != '\r') break block24;
                            if (!this.isInternal()) {
                                contentHandler.characters(this.buf, n2, n - n2);
                                contentHandler.characters(newline, 0, 1);
                                bl = true;
                                ++this.lineNumber;
                                if (this.finish > n + 1 && this.buf[n + 1] == '\n') {
                                    ++n;
                                }
                                n2 = this.start = n + 1;
                            }
                            break block21;
                        }
                        if (c != ']') break block25;
                        switch (this.finish - n) {
                            case 2: {
                                if (this.buf[n + 1] != ']') break;
                            }
                            case 1: {
                                if (this.reader != null) {
                                    if (this.isClosed) break;
                                    if (n == n2) {
                                        throw new InternalError("fillbuf");
                                    }
                                    if (--n > n2) {
                                        elementValidator.text();
                                        contentHandler.characters(this.buf, n2, n - n2);
                                        bl = true;
                                        this.start = n;
                                    }
                                    this.fillbuf();
                                    n2 = n = this.start;
                                    break;
                                }
                                break block21;
                            }
                            default: {
                                if (this.buf[n + 1] == ']' && this.buf[n + 2] == '>') {
                                    this.fatal("P-072", null);
                                    break;
                                }
                                break block21;
                            }
                        }
                        break block21;
                    }
                    if (c < '\ud800' || c > '\udfff') break block26;
                    if (n + 1 >= this.finish) {
                        if (n > n2) {
                            elementValidator.text();
                            contentHandler.characters(this.buf, n2, n - n2);
                            bl = true;
                            this.start = n + 1;
                        }
                        if (this.isEOF()) {
                            this.fatal("P-081", new Object[]{Integer.toHexString(c)});
                        }
                        n = n2 = this.start;
                        break block21;
                    } else if (this.checkSurrogatePair(n)) {
                        ++n;
                        break block21;
                    } else {
                        --n;
                        break;
                    }
                }
                this.fatal("P-071", new Object[]{Integer.toHexString(c)});
            }
            ++n;
        }
        if (n == n2) {
            return bl;
        }
        elementValidator.text();
        contentHandler.characters(this.buf, n2, n - n2);
        this.start = n;
        return true;
    }

    public void init(char[] cArray, String string, InputEntity inputEntity, boolean bl) throws SAXException {
        this.next = inputEntity;
        this.buf = cArray;
        this.finish = cArray.length;
        this.name = string;
        this.isPE = bl;
        this.checkRecursion(inputEntity);
    }

    public void unparsedContent(ContentHandler contentHandler, ElementValidator elementValidator, boolean bl, String string) throws IOException, SAXException {
        int n;
        while (true) {
            boolean bl2 = false;
            boolean bl3 = bl;
            for (n = this.start; n < this.finish; ++n) {
                char c = this.buf[n];
                if (!XmlChars.isChar(c)) {
                    bl3 = false;
                    if (c >= '\ud800' && c <= '\udfff') {
                        if (this.checkSurrogatePair(n)) {
                            ++n;
                            continue;
                        }
                        --n;
                        break;
                    }
                    this.fatal("P-071", new Object[]{Integer.toHexString(this.buf[n])});
                }
                if (c == '\n') {
                    if (this.isInternal()) continue;
                    ++this.lineNumber;
                    continue;
                }
                if (c == '\r') {
                    if (this.isInternal()) continue;
                    if (bl3) {
                        if (string != null) {
                            this.errHandler.error(new SAXParseException(Parser2.messages.getMessage(this.locale, string), this));
                        }
                        contentHandler.ignorableWhitespace(this.buf, this.start, n - this.start);
                        contentHandler.ignorableWhitespace(newline, 0, 1);
                    } else {
                        elementValidator.text();
                        contentHandler.characters(this.buf, this.start, n - this.start);
                        contentHandler.characters(newline, 0, 1);
                    }
                    ++this.lineNumber;
                    if (this.finish > n + 1 && this.buf[n + 1] == '\n') {
                        ++n;
                    }
                    this.start = n + 1;
                    continue;
                }
                if (c != ']') {
                    if (c == ' ' || c == '\t') continue;
                    bl3 = false;
                    continue;
                }
                if (n + 2 >= this.finish) break;
                if (this.buf[n + 1] == ']' && this.buf[n + 2] == '>') {
                    bl2 = true;
                    break;
                }
                bl3 = false;
            }
            if (bl3) {
                if (string != null) {
                    this.errHandler.error(new SAXParseException(Parser2.messages.getMessage(this.locale, string), this));
                }
                contentHandler.ignorableWhitespace(this.buf, this.start, n - this.start);
            } else {
                elementValidator.text();
                contentHandler.characters(this.buf, this.start, n - this.start);
            }
            if (bl2) break;
            this.start = n;
            this.fillbuf();
            if (!this.isEOF()) continue;
            this.fatal("P-073", null);
        }
        this.start = n + 3;
    }

    public void init(InputSource inputSource, String string, InputEntity inputEntity, boolean bl) throws IOException, SAXException {
        this.input = inputSource;
        this.isPE = bl;
        this.reader = inputSource.getCharacterStream();
        if (this.reader == null) {
            InputStream inputStream = inputSource.getByteStream();
            if (inputStream == null) {
                URL uRL;
                String string2 = inputSource.getSystemId();
                try {
                    uRL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    String string3 = InputEntity.convertToFileURL(string2);
                    inputSource.setSystemId(string3);
                    uRL = new URL(string3);
                }
                this.reader = XmlReader.createReader(uRL.openStream());
            } else {
                this.reader = inputSource.getEncoding() != null ? XmlReader.createReader(inputSource.getByteStream(), inputSource.getEncoding()) : XmlReader.createReader(inputSource.getByteStream());
            }
        }
        this.next = inputEntity;
        this.buf = new char[8193];
        this.name = string;
        this.checkRecursion(inputEntity);
    }

    public static InputEntity getInputEntity(ErrorHandler errorHandler, Locale locale) {
        InputEntity inputEntity = new InputEntity();
        inputEntity.errHandler = errorHandler;
        inputEntity.locale = locale;
        return inputEntity;
    }
}

